<?php
/**
 * Auth form login
 *
 * This template can be overridden by copying it to yourtheme/kkart/auth/form-login.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates\Auth
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'kkart_auth_page_header' ); ?>

<h1>
	<?php
	/* translators: %s: app name */
	printf( esc_html__( '%s would like to connect to your store', 'kkart' ), esc_html( $app_name ) );
	?>
</h1>

<?php kkart_print_notices(); ?>

<p>
	<?php
	/* translators: %1$s: app name, %2$s: URL */
	echo wp_kses_post( sprintf( __( 'To connect to %1$s you need to be logged in. Log in to your store below, or <a href="%2$s">cancel and return to %1$s</a>', 'kkart' ), esc_html( kkart_clean( $app_name ) ), esc_url( $return_url ) ) );
	?>
</p>

<form method="post" class="kkart-auth-login">
	<p class="form-row form-row-wide">
		<label for="username"><?php esc_html_e( 'Username or email address', 'kkart' ); ?>&nbsp;<span class="required">*</span></label>
		<input type="text" class="input-text" name="username" id="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( $_POST['username'] ) : ''; ?>" /><?php //@codingStandardsIgnoreLine ?>
	</p>
	<p class="form-row form-row-wide">
		<label for="password"><?php esc_html_e( 'Password', 'kkart' ); ?>&nbsp;<span class="required">*</span></label>
		<input class="input-text" type="password" name="password" id="password" />
	</p>
	<p class="kkart-auth-actions">
		<?php wp_nonce_field( 'kkart-login', 'kkart-login-nonce' ); ?>
		<button type="submit" class="button button-large button-primary kkart-auth-login-button" name="login" value="<?php esc_attr_e( 'Login', 'kkart' ); ?>"><?php esc_html_e( 'Login', 'kkart' ); ?></button>
		<input type="hidden" name="redirect" value="<?php echo esc_url( $redirect_url ); ?>" />
	</p>
</form>

<?php do_action( 'kkart_auth_page_footer' ); ?>
