<?php
/**
 * Kkart Legacy API. Was deprecated with 2.6.0.
 *
 * @author   WooThemes
 * @category API
 * @package  Kkart\RestApi
 * @since    2.6
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Legacy API.
 */
class KKART_Legacy_API {

	/**
	 * This is the major version for the REST API and takes
	 * first-order position in endpoint URLs.
	 *
	 * @deprecated 2.6.0
	 * @var string
	 */
	const VERSION = '3.1.0';

	/**
	 * The REST API server.
	 *
	 * @deprecated 2.6.0
	 * @var KKART_API_Server
	 */
	public $server;

	/**
	 * REST API authentication class instance.
	 *
	 * @deprecated 2.6.0
	 * @var KKART_API_Authentication
	 */
	public $authentication;

	/**
	 * Init the legacy API.
	 */
	public function init() {
		add_action( 'parse_request', array( $this, 'handle_rest_api_requests' ), 0 );
	}

	/**
	 * Add new query vars.
	 *
	 * @since 2.0
	 * @param array $vars Vars.
	 * @return string[]
	 */
	public function add_query_vars( $vars ) {
		$vars[] = 'kkart-api-version'; // Deprecated since 2.6.0.
		$vars[] = 'kkart-api-route'; // Deprecated since 2.6.0.
		return $vars;
	}

	/**
	 * Add new endpoints.
	 *
	 * @since 2.0
	 */
	public static function add_endpoint() {
		// REST API, deprecated since 2.6.0.
		add_rewrite_rule( '^kkart-api/v([1-3]{1})/?$', 'index.php?kkart-api-version=$matches[1]&kkart-api-route=/', 'top' );
		add_rewrite_rule( '^kkart-api/v([1-3]{1})(.*)?', 'index.php?kkart-api-version=$matches[1]&kkart-api-route=$matches[2]', 'top' );
	}

	/**
	 * Handle REST API requests.
	 *
	 * @since 2.2
	 * @deprecated 2.6.0
	 */
	public function handle_rest_api_requests() {
		global $wp;

		if ( ! empty( $_GET['kkart-api-version'] ) ) {
			$wp->query_vars['kkart-api-version'] = $_GET['kkart-api-version'];
		}

		if ( ! empty( $_GET['kkart-api-route'] ) ) {
			$wp->query_vars['kkart-api-route'] = $_GET['kkart-api-route'];
		}

		// REST API request.
		if ( ! empty( $wp->query_vars['kkart-api-version'] ) && ! empty( $wp->query_vars['kkart-api-route'] ) ) {

			kkart_maybe_define_constant( 'KKART_API_REQUEST', true );
			kkart_maybe_define_constant( 'KKART_API_REQUEST_VERSION', absint( $wp->query_vars['kkart-api-version'] ) );

			// Legacy v1 API request.
			if ( 1 === KKART_API_REQUEST_VERSION ) {
				$this->handle_v1_rest_api_request();
			} elseif ( 2 === KKART_API_REQUEST_VERSION ) {
				$this->handle_v2_rest_api_request();
			} else {
				$this->includes();

				$this->server = new KKART_API_Server( $wp->query_vars['kkart-api-route'] );

				// load API resource classes.
				$this->register_resources( $this->server );

				// Fire off the request.
				$this->server->serve_request();
			}

			exit;
		}
	}

	/**
	 * Include required files for REST API request.
	 *
	 * @since 2.1
	 * @deprecated 2.6.0
	 */
	public function includes() {

		// API server / response handlers.
		include_once( dirname( __FILE__ ) . '/api/v3/class-kkart-api-exception.php' );
		include_once( dirname( __FILE__ ) . '/api/v3/class-kkart-api-server.php' );
		include_once( dirname( __FILE__ ) . '/api/v3/interface-kkart-api-handler.php' );
		include_once( dirname( __FILE__ ) . '/api/v3/class-kkart-api-json-handler.php' );

		// Authentication.
		include_once( dirname( __FILE__ ) . '/api/v3/class-kkart-api-authentication.php' );
		$this->authentication = new KKART_API_Authentication();

		include_once( dirname( __FILE__ ) . '/api/v3/class-kkart-api-resource.php' );
		include_once( dirname( __FILE__ ) . '/api/v3/class-kkart-api-coupons.php' );
		include_once( dirname( __FILE__ ) . '/api/v3/class-kkart-api-customers.php' );
		include_once( dirname( __FILE__ ) . '/api/v3/class-kkart-api-orders.php' );
		include_once( dirname( __FILE__ ) . '/api/v3/class-kkart-api-products.php' );
		include_once( dirname( __FILE__ ) . '/api/v3/class-kkart-api-reports.php' );
		include_once( dirname( __FILE__ ) . '/api/v3/class-kkart-api-taxes.php' );
		include_once( dirname( __FILE__ ) . '/api/v3/class-kkart-api-webhooks.php' );

		// Allow plugins to load other response handlers or resource classes.
		do_action( 'kkart_api_loaded' );
	}

	/**
	 * Register available API resources.
	 *
	 * @since 2.1
	 * @deprecated 2.6.0
	 * @param KKART_API_Server $server the REST server.
	 */
	public function register_resources( $server ) {

		$api_classes = apply_filters( 'kkart_api_classes',
			array(
				'KKART_API_Coupons',
				'KKART_API_Customers',
				'KKART_API_Orders',
				'KKART_API_Products',
				'KKART_API_Reports',
				'KKART_API_Taxes',
				'KKART_API_Webhooks',
			)
		);

		foreach ( $api_classes as $api_class ) {
			$this->$api_class = new $api_class( $server );
		}
	}


	/**
	 * Handle legacy v1 REST API requests.
	 *
	 * @since 2.2
	 * @deprecated 2.6.0
	 */
	private function handle_v1_rest_api_request() {

		// Include legacy required files for v1 REST API request.
		include_once( dirname( __FILE__ ) . '/api/v1/class-kkart-api-server.php' );
		include_once( dirname( __FILE__ ) . '/api/v1/interface-kkart-api-handler.php' );
		include_once( dirname( __FILE__ ) . '/api/v1/class-kkart-api-json-handler.php' );
		include_once( dirname( __FILE__ ) . '/api/v1/class-kkart-api-xml-handler.php' );

		include_once( dirname( __FILE__ ) . '/api/v1/class-kkart-api-authentication.php' );
		$this->authentication = new KKART_API_Authentication();

		include_once( dirname( __FILE__ ) . '/api/v1/class-kkart-api-resource.php' );
		include_once( dirname( __FILE__ ) . '/api/v1/class-kkart-api-coupons.php' );
		include_once( dirname( __FILE__ ) . '/api/v1/class-kkart-api-customers.php' );
		include_once( dirname( __FILE__ ) . '/api/v1/class-kkart-api-orders.php' );
		include_once( dirname( __FILE__ ) . '/api/v1/class-kkart-api-products.php' );
		include_once( dirname( __FILE__ ) . '/api/v1/class-kkart-api-reports.php' );

		// Allow plugins to load other response handlers or resource classes.
		do_action( 'kkart_api_loaded' );

		$this->server = new KKART_API_Server( $GLOBALS['wp']->query_vars['kkart-api-route'] );

		// Register available resources for legacy v1 REST API request.
		$api_classes = apply_filters( 'kkart_api_classes',
			array(
				'KKART_API_Customers',
				'KKART_API_Orders',
				'KKART_API_Products',
				'KKART_API_Coupons',
				'KKART_API_Reports',
			)
		);

		foreach ( $api_classes as $api_class ) {
			$this->$api_class = new $api_class( $this->server );
		}

		// Fire off the request.
		$this->server->serve_request();
	}

	/**
	 * Handle legacy v2 REST API requests.
	 *
	 * @since 2.4
	 * @deprecated 2.6.0
	 */
	private function handle_v2_rest_api_request() {
		include_once( dirname( __FILE__ ) . '/api/v2/class-kkart-api-exception.php' );
		include_once( dirname( __FILE__ ) . '/api/v2/class-kkart-api-server.php' );
		include_once( dirname( __FILE__ ) . '/api/v2/interface-kkart-api-handler.php' );
		include_once( dirname( __FILE__ ) . '/api/v2/class-kkart-api-json-handler.php' );

		include_once( dirname( __FILE__ ) . '/api/v2/class-kkart-api-authentication.php' );
		$this->authentication = new KKART_API_Authentication();

		include_once( dirname( __FILE__ ) . '/api/v2/class-kkart-api-resource.php' );
		include_once( dirname( __FILE__ ) . '/api/v2/class-kkart-api-coupons.php' );
		include_once( dirname( __FILE__ ) . '/api/v2/class-kkart-api-customers.php' );
		include_once( dirname( __FILE__ ) . '/api/v2/class-kkart-api-orders.php' );
		include_once( dirname( __FILE__ ) . '/api/v2/class-kkart-api-products.php' );
		include_once( dirname( __FILE__ ) . '/api/v2/class-kkart-api-reports.php' );
		include_once( dirname( __FILE__ ) . '/api/v2/class-kkart-api-webhooks.php' );

		// allow plugins to load other response handlers or resource classes.
		do_action( 'kkart_api_loaded' );

		$this->server = new KKART_API_Server( $GLOBALS['wp']->query_vars['kkart-api-route'] );

		// Register available resources for legacy v2 REST API request.
		$api_classes = apply_filters( 'kkart_api_classes',
			array(
				'KKART_API_Customers',
				'KKART_API_Orders',
				'KKART_API_Products',
				'KKART_API_Coupons',
				'KKART_API_Reports',
				'KKART_API_Webhooks',
			)
		);

		foreach ( $api_classes as $api_class ) {
			$this->$api_class = new $api_class( $this->server );
		}

		// Fire off the request.
		$this->server->serve_request();
	}

	/**
	 * Rest API Init.
	 *
	 * @deprecated 3.7.0 - REST API clases autoload.
	 */
	public function rest_api_init() {}

	/**
	 * Include REST API classes.
	 *
	 * @deprecated 3.7.0 - REST API clases autoload.
	 */
	public function rest_api_includes() {
		$this->rest_api_init();
	}
	/**
	 * Register REST API routes.
	 *
	 * @deprecated 3.7.0
	 */
	public function register_rest_routes() {
		kkart_deprecated_function( 'KKART_Legacy_API::register_rest_routes', '3.7.0', '' );
		$this->register_wp_admin_settings();
	}
}
