<?php
/**
 * Kkart Widget Functions
 *
 * Widget related functions and widget registration.
 *
 * @package Kkart\Functions
 * @version 2.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Include widget classes.
require_once dirname( __FILE__ ) . '/abstracts/abstract-kkart-widget.php';
require_once dirname( __FILE__ ) . '/widgets/class-kkart-widget-cart.php';
require_once dirname( __FILE__ ) . '/widgets/class-kkart-widget-layered-nav-filters.php';
require_once dirname( __FILE__ ) . '/widgets/class-kkart-widget-layered-nav.php';
require_once dirname( __FILE__ ) . '/widgets/class-kkart-widget-price-filter.php';
require_once dirname( __FILE__ ) . '/widgets/class-kkart-widget-product-categories.php';
require_once dirname( __FILE__ ) . '/widgets/class-kkart-widget-product-search.php';
require_once dirname( __FILE__ ) . '/widgets/class-kkart-widget-product-tag-cloud.php';
require_once dirname( __FILE__ ) . '/widgets/class-kkart-widget-products.php';
require_once dirname( __FILE__ ) . '/widgets/class-kkart-widget-rating-filter.php';
require_once dirname( __FILE__ ) . '/widgets/class-kkart-widget-recent-reviews.php';
require_once dirname( __FILE__ ) . '/widgets/class-kkart-widget-recently-viewed.php';
require_once dirname( __FILE__ ) . '/widgets/class-kkart-widget-top-rated-products.php';

/**
 * Register Widgets.
 *
 * @since 2.3.0
 */
function kkart_register_widgets() {
	register_widget( 'KKART_Widget_Cart' );
	register_widget( 'KKART_Widget_Layered_Nav_Filters' );
	register_widget( 'KKART_Widget_Layered_Nav' );
	register_widget( 'KKART_Widget_Price_Filter' );
	register_widget( 'KKART_Widget_Product_Categories' );
	register_widget( 'KKART_Widget_Product_Search' );
	register_widget( 'KKART_Widget_Product_Tag_Cloud' );
	register_widget( 'KKART_Widget_Products' );
	register_widget( 'KKART_Widget_Recently_Viewed' );

	if ( 'yes' === get_option( 'kkart_enable_reviews', 'yes' ) ) {
		register_widget( 'KKART_Widget_Top_Rated_Products' );
		register_widget( 'KKART_Widget_Recent_Reviews' );
		register_widget( 'KKART_Widget_Rating_Filter' );
	}
}
add_action( 'widgets_init', 'kkart_register_widgets' );
