<?php
/**
 * Enables Kkart, via the the command line.
 *
 * @package Kkart\CLI
 * @version 3.0.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * CLI class.
 */
class KKART_CLI {
	/**
	 * Load required files and hooks to make the CLI work.
	 */
	public function __construct() {
		$this->includes();
		$this->hooks();
	}

	/**
	 * Load command files.
	 */
	private function includes() {
		require_once dirname( __FILE__ ) . '/cli/class-kkart-cli-runner.php';
		require_once dirname( __FILE__ ) . '/cli/class-kkart-cli-rest-command.php';
		require_once dirname( __FILE__ ) . '/cli/class-kkart-cli-tool-command.php';
		require_once dirname( __FILE__ ) . '/cli/class-kkart-cli-update-command.php';
	}

	/**
	 * Sets up and hooks WP CLI to our CLI code.
	 */
	private function hooks() {
		WP_CLI::add_hook( 'after_wp_load', 'KKART_CLI_Runner::after_wp_load' );
		WP_CLI::add_hook( 'after_wp_load', 'KKART_CLI_Tool_Command::register_commands' );
		WP_CLI::add_hook( 'after_wp_load', 'KKART_CLI_Update_Command::register_commands' );
	}
}

new KKART_CLI();
