<?php
/**
 * Admin View: Notice - No Shipping methods.
 *
 * @package Kkart\Admin\Notices
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div id="message" class="updated kkart-message">
	<a class="kkart-message-close notice-dismiss" href="<?php echo esc_url( wp_nonce_url( add_query_arg( 'kkart-hide-notice', 'no_shipping_methods' ), 'kkart_hide_notices_nonce', '_kkart_notice_nonce' ) ); ?>">
		<?php esc_html_e( 'Dismiss', 'kkart' ); ?>
	</a>

	<p class="main">
		<strong>
			<?php esc_html_e( 'Add shipping methods &amp; zones', 'kkart' ); ?>
		</strong>
	</p>
	<p>
		<?php esc_html_e( 'Shipping is currently enabled, but you have not added any shipping methods to your shipping zones.', 'kkart' ); ?>
	</p>
	<p>
		<?php esc_html_e( 'Customers will not be able to purchase physical goods from your store until a shipping method is available.', 'kkart' ); ?>
	</p>

	<p class="submit">
		<a class="button-primary" href="<?php echo esc_url( admin_url( 'admin.php?page=kkart-settings&tab=shipping' ) ); ?>">
			<?php esc_html_e( 'Setup shipping zones', 'kkart' ); ?>
		</a>
		<a class="button-secondary" href="https://docs.kkart.com/document/setting-up-shipping-zones/">
			<?php esc_html_e( 'Learn more about shipping zones', 'kkart' ); ?>
		</a>
	</p>
</div>
