<?php
/**
 * Admin View: Product Export
 *
 * @package Kkart\Admin\Export
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wp_enqueue_script( 'kkart-product-export' );

$exporter = new KKART_Product_CSV_Exporter();
?>
<div class="wrap kkart">
	<h1><?php esc_html_e( 'Export Products', 'kkart' ); ?></h1>

	<div class="kkart-exporter-wrapper">
		<form class="kkart-exporter">
			<header>
				<span class="spinner is-active"></span>
				<h2><?php esc_html_e( 'Export products to a CSV file', 'kkart' ); ?></h2>
				<p><?php esc_html_e( 'This tool allows you to generate and download a CSV file containing a list of all products.', 'kkart' ); ?></p>
			</header>
			<section>
				<table class="form-table kkart-exporter-options">
					<tbody>
						<tr>
							<th scope="row">
								<label for="kkart-exporter-columns"><?php esc_html_e( 'Which columns should be exported?', 'kkart' ); ?></label>
							</th>
							<td>
								<select id="kkart-exporter-columns" class="kkart-exporter-columns kkart-enhanced-select" style="width:100%;" multiple data-placeholder="<?php esc_attr_e( 'Export all columns', 'kkart' ); ?>">
									<?php
									foreach ( $exporter->get_default_column_names() as $column_id => $column_name ) {
										echo '<option value="' . esc_attr( $column_id ) . '">' . esc_html( $column_name ) . '</option>';
									}
									?>
									<option value="downloads"><?php esc_html_e( 'Downloads', 'kkart' ); ?></option>
									<option value="attributes"><?php esc_html_e( 'Attributes', 'kkart' ); ?></option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="kkart-exporter-types"><?php esc_html_e( 'Which product types should be exported?', 'kkart' ); ?></label>
							</th>
							<td>
								<select id="kkart-exporter-types" class="kkart-exporter-types kkart-enhanced-select" style="width:100%;" multiple data-placeholder="<?php esc_attr_e( 'Export all products', 'kkart' ); ?>">
									<?php
									foreach ( kkart_get_product_types() as $value => $label ) {
										echo '<option value="' . esc_attr( $value ) . '">' . esc_html( $label ) . '</option>';
									}
									?>
									<option value="variation"><?php esc_html_e( 'Product variations', 'kkart' ); ?></option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="kkart-exporter-category"><?php esc_html_e( 'Which product category should be exported?', 'kkart' ); ?></label>
							</th>
							<td>
								<select id="kkart-exporter-category" class="kkart-exporter-category kkart-enhanced-select" style="width:100%;" multiple data-placeholder="<?php esc_attr_e( 'Export all categories', 'kkart' ); ?>">
								<?php
								$categories = get_categories(
									array(
										'taxonomy'   => 'product_cat',
										'hide_empty' => false,
									)
								);
								foreach ( $categories as $category ) {
									echo '<option value="' . esc_attr( $category->slug ) . '">' . esc_html( $category->name ) . '</option>';
								}
								?>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="kkart-exporter-meta"><?php esc_html_e( 'Export custom meta?', 'kkart' ); ?></label>
							</th>
							<td>
								<input type="checkbox" id="kkart-exporter-meta" value="1" />
								<label for="kkart-exporter-meta"><?php esc_html_e( 'Yes, export all custom meta', 'kkart' ); ?></label>
							</td>
						</tr>
						<?php do_action( 'kkart_product_export_row' ); ?>
					</tbody>
				</table>
				<progress class="kkart-exporter-progress" max="100" value="0"></progress>
			</section>
			<div class="kkart-actions">
				<button type="submit" class="kkart-exporter-button button button-primary" value="<?php esc_attr_e( 'Generate CSV', 'kkart' ); ?>"><?php esc_html_e( 'Generate CSV', 'kkart' ); ?></button>
			</div>
		</form>
	</div>
</div>
