<?php
/**
 * Setup Wizard Class
 *
 * Takes new users through some basic steps to setup their store.
 *
 * @package     Kkart\Admin
 * @version     2.6.0
 * @deprecated  4.6.0
 */

use Automattic\Jetpack\Constants;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * KKART_Admin_Setup_Wizard class.
 */
class KKART_Admin_Setup_Wizard {

	/**
	 * Current step
	 *
	 * @var string
	 */
	private $step = '';

	/**
	 * Steps for the setup wizard
	 *
	 * @var array
	 */
	private $steps = array();

	/**
	 * Actions to be executed after the HTTP response has completed
	 *
	 * @var array
	 */
	private $deferred_actions = array();

	/**
	 * Tweets user can optionally send after install
	 *
	 * @var array
	 */
	private $tweets = array(
		'Someone give me woo-t, I just set up a new store with #WordPress and @Kkart!',
		'Someone give me high five, I just set up a new store with #WordPress and @Kkart!',
	);

	/**
	 * The version of WordPress required to run the Kkart Admin plugin
	 *
	 * @var string
	 */
	private $kkart_admin_plugin_minimum_wordpress_version = '5.3';

	/**
	 * Hook in tabs.
	 *
	 * @deprecated 4.6.0
	 */
	public function __construct() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
	}

	/**
	 * Add admin menus/screens.
	 *
	 * @deprecated 4.6.0
	 */
	public function admin_menus() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		add_dashboard_page( '', '', 'manage_options', 'kkart-setup', '' );
	}

	/**
	 * The theme "extra" should only be shown if the current user can modify themes
	 * and the store doesn't already have a Kkart theme.
	 *
	 * @deprecated 4.6.0
	 * @return boolean
	 */
	protected function should_show_theme() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$support_kkart = current_theme_supports( 'kkart' ) && ! kkart_is_wp_default_theme_active();

		return (
			current_user_can( 'install_themes' ) &&
			current_user_can( 'switch_themes' ) &&
			! is_multisite() &&
			! $support_kkart
		);
	}

	/**
	 * The "automated tax" extra should only be shown if the current user can
	 * install plugins and the store is in a supported country.
	 *
	 * @deprecated 4.6.0
	 */
	protected function should_show_automated_tax() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		if ( ! current_user_can( 'install_plugins' ) ) {
			return false;
		}

		$country_code = KKART()->countries->get_base_country();
		// https://developers.taxjar.com/api/reference/#countries .
		$tax_supported_countries = array_merge(
			array( 'US', 'CA', 'AU' ),
			KKART()->countries->get_european_union_countries()
		);

		return in_array( $country_code, $tax_supported_countries, true );
	}

	/**
	 * Should we show the MailChimp install option?
	 * True only if the user can install plugins.
	 *
	 * @deprecated 4.6.0
	 * @return boolean
	 */
	protected function should_show_mailchimp() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		return current_user_can( 'install_plugins' );
	}

	/**
	 * Should we show the Facebook install option?
	 * True only if the user can install plugins,
	 * and up until the end date of the recommendation.
	 *
	 * @deprecated 4.6.0
	 * @return boolean
	 */
	protected function should_show_facebook() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		return current_user_can( 'install_plugins' );
	}

	/**
	 * Is the Kkart Admin actively included in the Kkart core?
	 * Based on presence of a basic KKART Admin function.
	 *
	 * @deprecated 4.6.0
	 * @return boolean
	 */
	protected function is_kkart_admin_active() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		return function_exists( 'kkart_admin_url' );
	}

	/**
	 * Should we show the Kkart Admin install option?
	 * True only if the user can install plugins,
	 * and is running the correct version of WordPress.
	 *
	 * @see KKART_Admin_Setup_Wizard::$kkart_admin_plugin_minimum_wordpress_version
	 *
	 * @deprecated 4.6.0
	 * @return boolean
	 */
	protected function should_show_kkart_admin() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$wordpress_minimum_met = version_compare( get_bloginfo( 'version' ), $this->kkart_admin_plugin_minimum_wordpress_version, '>=' );
		return current_user_can( 'install_plugins' ) && $wordpress_minimum_met && ! $this->is_kkart_admin_active();
	}

	/**
	 * Should we show the new Kkart Admin onboarding experience?
	 *
	 * @deprecated 4.6.0
	 * @return boolean
	 */
	protected function should_show_kkart_admin_onboarding() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		// As of Kkart 4.1, all new sites should use the latest OBW from kkart-admin package.
		// This filter will allow for forcing the old wizard while we migrate e2e tests.
		return ! apply_filters( 'kkart_setup_wizard_force_legacy', false );
	}

	/**
	 * Should we display the 'Recommended' step?
	 * True if at least one of the recommendations will be displayed.
	 *
	 * @deprecated 4.6.0
	 * @return boolean
	 */
	protected function should_show_recommended_step() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		return $this->should_show_theme()
			|| $this->should_show_automated_tax()
			|| $this->should_show_mailchimp()
			|| $this->should_show_facebook()
			|| $this->should_show_kkart_admin();
	}

	/**
	 * Register/enqueue scripts and styles for the Setup Wizard.
	 *
	 * Hooked onto 'admin_enqueue_scripts'.
	 *
	 * @deprecated 4.6.0
	 */
	public function enqueue_scripts() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
	}

	/**
	 * Show the setup wizard.
	 *
	 * @deprecated 4.6.0
	 */
	public function setup_wizard() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		if ( empty( $_GET['page'] ) || 'kkart-setup' !== $_GET['page'] ) { // WPCS: CSRF ok, input var ok.
			return;
		}
		$default_steps = array(
			'new_onboarding' => array(
				'name'    => '',
				'view'    => array( $this, 'kkart_setup_new_onboarding' ),
				'handler' => array( $this, 'kkart_setup_new_onboarding_save' ),
			),
			'store_setup'    => array(
				'name'    => __( 'Store setup', 'kkart' ),
				'view'    => array( $this, 'kkart_setup_store_setup' ),
				'handler' => array( $this, 'kkart_setup_store_setup_save' ),
			),
			'payment'        => array(
				'name'    => __( 'Payment', 'kkart' ),
				'view'    => array( $this, 'kkart_setup_payment' ),
				'handler' => array( $this, 'kkart_setup_payment_save' ),
			),
			'shipping'       => array(
				'name'    => __( 'Shipping', 'kkart' ),
				'view'    => array( $this, 'kkart_setup_shipping' ),
				'handler' => array( $this, 'kkart_setup_shipping_save' ),
			),
			'recommended'    => array(
				'name'    => __( 'Recommended', 'kkart' ),
				'view'    => array( $this, 'kkart_setup_recommended' ),
				'handler' => array( $this, 'kkart_setup_recommended_save' ),
			),
			'activate'       => array(
				'name'    => __( 'Activate', 'kkart' ),
				'view'    => array( $this, 'kkart_setup_activate' ),
				'handler' => array( $this, 'kkart_setup_activate_save' ),
			),
			'next_steps'     => array(
				'name'    => __( 'Ready!', 'kkart' ),
				'view'    => array( $this, 'kkart_setup_ready' ),
				'handler' => '',
			),
		);

		// Hide the new/improved onboarding experience screen if the user is not part of the a/b test.
		if ( ! $this->should_show_kkart_admin_onboarding() ) {
			unset( $default_steps['new_onboarding'] );
		}

		// Hide recommended step if nothing is going to be shown there.
		if ( ! $this->should_show_recommended_step() ) {
			unset( $default_steps['recommended'] );
		}

		// Hide shipping step if the store is selling digital products only.
		if ( 'virtual' === get_option( 'kkart_product_type' ) ) {
			unset( $default_steps['shipping'] );
		}

		// Hide activate section when the user does not have capabilities to install plugins, think multiside admins not being a super admin.
		if ( ! current_user_can( 'install_plugins' ) ) {
			unset( $default_steps['activate'] );
		}

		$this->steps = apply_filters( 'kkart_setup_wizard_steps', $default_steps );
		$this->step  = isset( $_GET['step'] ) ? sanitize_key( $_GET['step'] ) : current( array_keys( $this->steps ) ); // WPCS: CSRF ok, input var ok.

		// @codingStandardsIgnoreStart
		if ( ! empty( $_POST['save_step'] ) && isset( $this->steps[ $this->step ]['handler'] ) ) {
			call_user_func( $this->steps[ $this->step ]['handler'], $this );
		}
		// @codingStandardsIgnoreEnd

		ob_start();
		$this->setup_wizard_header();
		$this->setup_wizard_steps();
		$this->setup_wizard_content();
		$this->setup_wizard_footer();
		exit;
	}

	/**
	 * Get the URL for the next step's screen.
	 *
	 * @param string $step  slug (default: current step).
	 * @return string       URL for next step if a next step exists.
	 *                      Admin URL if it's the last step.
	 *                      Empty string on failure.
	 *
	 * @deprecated 4.6.0
	 * @since 3.0.0
	 */
	public function get_next_step_link( $step = '' ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		if ( ! $step ) {
			$step = $this->step;
		}

		$keys = array_keys( $this->steps );
		if ( end( $keys ) === $step ) {
			return admin_url();
		}

		$step_index = array_search( $step, $keys, true );
		if ( false === $step_index ) {
			return '';
		}

		return add_query_arg( 'step', $keys[ $step_index + 1 ], remove_query_arg( 'activate_error' ) );
	}

	/**
	 * Setup Wizard Header.
	 *
	 * @deprecated 4.6.0
	 */
	public function setup_wizard_header() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		// same as default WP from wp-admin/admin-header.php.
		$wp_version_class = 'branch-' . str_replace( array( '.', ',' ), '-', floatval( get_bloginfo( 'version' ) ) );

		set_current_screen();
		?>
		<!DOCTYPE html>
		<html <?php language_attributes(); ?>>
		<head>
			<meta name="viewport" content="width=device-width" />
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
			<title><?php esc_html_e( 'Kkart &rsaquo; Setup Wizard', 'kkart' ); ?></title>
			<?php do_action( 'admin_enqueue_scripts' ); ?>
			<?php wp_print_scripts( 'kkart-setup' ); ?>
			<?php do_action( 'admin_print_styles' ); ?>
			<?php do_action( 'admin_head' ); ?>
		</head>
		<body class="kkart-setup wp-core-ui <?php echo esc_attr( 'kkart-setup-step__' . $this->step ); ?> <?php echo esc_attr( $wp_version_class ); ?>">
		<h1 class="kkart-logo"><a href="https://kkart.com/"><img src="<?php echo esc_url( KKART()->plugin_url() ); ?>/assets/images/kkart_logo.png" alt="<?php esc_attr_e( 'Kkart', 'kkart' ); ?>" /></a></h1>
		<?php
	}

	/**
	 * Setup Wizard Footer.
	 *
	 * @deprecated 4.6.0
	 */
	public function setup_wizard_footer() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$current_step = $this->step;
		?>
			<?php if ( 'new_onboarding' === $current_step || 'store-setup' === $current_step ) : ?>
				<a class="kkart-setup-footer-links" href="<?php echo esc_url( admin_url() ); ?>"><?php esc_html_e( 'Not right now', 'kkart' ); ?></a>
			<?php elseif ( 'recommended' === $current_step || 'activate' === $current_step ) : ?>
				<a class="kkart-setup-footer-links" href="<?php echo esc_url( $this->get_next_step_link() ); ?>"><?php esc_html_e( 'Skip this step', 'kkart' ); ?></a>
			<?php endif; ?>
			<?php do_action( 'kkart_setup_footer' ); ?>
			</body>
		</html>
		<?php
	}

	/**
	 * Output the steps.
	 *
	 * @deprecated 4.6.0
	 */
	public function setup_wizard_steps() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$output_steps      = $this->steps;
		$selected_features = array_filter( $this->kkart_setup_activate_get_feature_list() );

		// Hide the activate step if Jetpack is already active, unless Kkart Services
		// features are selected, or unless the Activate step was already taken.
		if ( class_exists( 'Jetpack' ) && Jetpack::is_active() && empty( $selected_features ) && 'yes' !== get_transient( 'kkart_setup_activated' ) ) {
			unset( $output_steps['activate'] );
		}

		unset( $output_steps['new_onboarding'] );

		?>
		<ol class="kkart-setup-steps">
			<?php
			foreach ( $output_steps as $step_key => $step ) {
				$is_completed = array_search( $this->step, array_keys( $this->steps ), true ) > array_search( $step_key, array_keys( $this->steps ), true );

				if ( $step_key === $this->step ) {
					?>
					<li class="active"><?php echo esc_html( $step['name'] ); ?></li>
					<?php
				} elseif ( $is_completed ) {
					?>
					<li class="done">
						<a href="<?php echo esc_url( add_query_arg( 'step', $step_key, remove_query_arg( 'activate_error' ) ) ); ?>"><?php echo esc_html( $step['name'] ); ?></a>
					</li>
					<?php
				} else {
					?>
					<li><?php echo esc_html( $step['name'] ); ?></li>
					<?php
				}
			}
			?>
		</ol>
		<?php
	}

	/**
	 * Output the content for the current step.
	 *
	 * @deprecated 4.6.0
	 */
	public function setup_wizard_content() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		echo '<div class="kkart-setup-content">';
		if ( ! empty( $this->steps[ $this->step ]['view'] ) ) {
			call_user_func( $this->steps[ $this->step ]['view'], $this );
		}
		echo '</div>';
	}

	/**
	 * Display's a prompt for users to try out the new improved Kkart onboarding experience in Kkart Admin.
	 *
	 * @deprecated 4.6.0
	 */
	public function kkart_setup_new_onboarding() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		?>
			<div class="kkart-setup-step__new_onboarding-wrapper">
				<p class="kkart-setup-step__new_onboarding-welcome"><?php esc_html_e( 'Welcome to', 'kkart' ); ?></p>
				<h1 class="kkart-logo"><a href="https://kkart.com/"><img src="<?php echo esc_url( KKART()->plugin_url() ); ?>/assets/images/kkart_logo.png" alt="<?php esc_attr_e( 'Kkart', 'kkart' ); ?>" /></a></h1>
				<p><?php esc_html_e( 'Get your store up and running more quickly with our new and improved setup experience', 'kkart' ); ?></p>

				<form method="post" class="activate-new-onboarding">
					<?php wp_nonce_field( 'kkart-setup' ); ?>
					<input type="hidden" name="save_step" value="new_onboarding" />
					<p class="kkart-setup-actions step">
						<button class="button-primary button button-large" value="<?php esc_attr_e( 'Yes please', 'kkart' ); ?>" name="save_step"><?php esc_html_e( 'Yes please', 'kkart' ); ?></button>
					</p>
				</form>
				<?php if ( ! $this->is_kkart_admin_active() ) : ?>
					<p class="kkart-setup-step__new_onboarding-plugin-info"><?php esc_html_e( 'The "Kkart Admin" plugin will be installed and activated', 'kkart' ); ?></p>
				<?php endif; ?>
			</div>
		<?php
	}

	/**
	 * Installs Kkart admin and redirects to the new onboarding experience.
	 *
	 * @deprecated 4.6.0
	 */
	public function kkart_setup_new_onboarding_save() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
	}

	/**
	 * Initial "store setup" step.
	 * Location, product type, page setup, and tracking opt-in.
	 */
	public function kkart_setup_store_setup() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$address        = KKART()->countries->get_base_address();
		$address_2      = KKART()->countries->get_base_address_2();
		$city           = KKART()->countries->get_base_city();
		$state          = KKART()->countries->get_base_state();
		$country        = KKART()->countries->get_base_country();
		$postcode       = KKART()->countries->get_base_postcode();
		$currency       = get_option( 'kkart_currency', 'GBP' );
		$product_type   = get_option( 'kkart_product_type', 'both' );
		$sell_in_person = get_option( 'kkart_sell_in_person', 'none_selected' );

		if ( empty( $country ) ) {
			$user_location = KKART_Geolocation::geolocate_ip();
			$country       = $user_location['country'];
			$state         = $user_location['state'];
		}

		$locale_info         = include KKART()->plugin_path() . '/i18n/locale-info.php';
		$currency_by_country = wp_list_pluck( $locale_info, 'currency_code' );
		?>
		<form method="post" class="address-step">
			<input type="hidden" name="save_step" value="store_setup" />
			<?php wp_nonce_field( 'kkart-setup' ); ?>
			<p class="store-setup"><?php esc_html_e( 'The following wizard will help you configure your store and get you started quickly.', 'kkart' ); ?></p>

			<div class="store-address-container">

				<label for="store_country" class="location-prompt"><?php esc_html_e( 'Where is your store based?', 'kkart' ); ?></label>
				<select id="store_country" name="store_country" required data-placeholder="<?php esc_attr_e( 'Choose a country / region&hellip;', 'kkart' ); ?>" aria-label="<?php esc_attr_e( 'Country / Region', 'kkart' ); ?>" class="location-input kkart-enhanced-select dropdown">
					<?php foreach ( KKART()->countries->get_countries() as $code => $label ) : ?>
						<option <?php selected( $code, $country ); ?> value="<?php echo esc_attr( $code ); ?>"><?php echo esc_html( $label ); ?></option>
					<?php endforeach; ?>
				</select>

				<label class="location-prompt" for="store_address"><?php esc_html_e( 'Address', 'kkart' ); ?></label>
				<input type="text" id="store_address" class="location-input" name="store_address" required value="<?php echo esc_attr( $address ); ?>" />

				<label class="location-prompt" for="store_address_2"><?php esc_html_e( 'Address line 2', 'kkart' ); ?></label>
				<input type="text" id="store_address_2" class="location-input" name="store_address_2" value="<?php echo esc_attr( $address_2 ); ?>" />

				<div class="city-and-postcode">
					<div>
						<label class="location-prompt" for="store_city"><?php esc_html_e( 'City', 'kkart' ); ?></label>
						<input type="text" id="store_city" class="location-input" name="store_city" required value="<?php echo esc_attr( $city ); ?>" />
					</div>
					<div class="store-state-container hidden">
						<label for="store_state" class="location-prompt">
							<?php esc_html_e( 'State', 'kkart' ); ?>
						</label>
						<select id="store_state" name="store_state" data-placeholder="<?php esc_attr_e( 'Choose a state&hellip;', 'kkart' ); ?>" aria-label="<?php esc_attr_e( 'State', 'kkart' ); ?>" class="location-input kkart-enhanced-select dropdown"></select>
					</div>
					<div>
						<label class="location-prompt" for="store_postcode"><?php esc_html_e( 'Postcode / ZIP', 'kkart' ); ?></label>
						<input type="text" id="store_postcode" class="location-input" name="store_postcode" required value="<?php echo esc_attr( $postcode ); ?>" />
					</div>
				</div>
			</div>

			<div class="store-currency-container">
			<label class="location-prompt" for="currency_code">
				<?php esc_html_e( 'What currency do you accept payments in?', 'kkart' ); ?>
			</label>
			<select
				id="currency_code"
				name="currency_code"
				required
				data-placeholder="<?php esc_attr_e( 'Choose a currency&hellip;', 'kkart' ); ?>"
				class="location-input kkart-enhanced-select dropdown"
			>
				<option value=""><?php esc_html_e( 'Choose a currency&hellip;', 'kkart' ); ?></option>
				<?php foreach ( get_kkart_currencies() as $code => $name ) : ?>
					<option value="<?php echo esc_attr( $code ); ?>" <?php selected( $currency, $code ); ?>>
						<?php
						$symbol = get_kkart_currency_symbol( $code );

						if ( $symbol === $code ) {
							/* translators: 1: currency name 2: currency code */
							echo esc_html( sprintf( __( '%1$s (%2$s)', 'kkart' ), $name, $code ) );
						} else {
							/* translators: 1: currency name 2: currency symbol, 3: currency code */
							echo esc_html( sprintf( __( '%1$s (%2$s %3$s)', 'kkart' ), $name, get_kkart_currency_symbol( $code ), $code ) );
						}
						?>
					</option>
				<?php endforeach; ?>
			</select>
			<script type="text/javascript">
				var kkart_setup_currencies = JSON.parse( decodeURIComponent( '<?php echo rawurlencode( wp_json_encode( $currency_by_country ) ); ?>' ) );
				var kkart_base_state       = "<?php echo esc_js( $state ); ?>";
			</script>
			</div>

			<div class="product-type-container">
			<label class="location-prompt" for="product_type">
				<?php esc_html_e( 'What type of products do you plan to sell?', 'kkart' ); ?>
			</label>
			<select id="product_type" name="product_type" required class="location-input kkart-enhanced-select dropdown">
				<option value="both" <?php selected( $product_type, 'both' ); ?>><?php esc_html_e( 'I plan to sell both physical and digital products', 'kkart' ); ?></option>
				<option value="physical" <?php selected( $product_type, 'physical' ); ?>><?php esc_html_e( 'I plan to sell physical products', 'kkart' ); ?></option>
				<option value="virtual" <?php selected( $product_type, 'virtual' ); ?>><?php esc_html_e( 'I plan to sell digital products', 'kkart' ); ?></option>
			</select>
			</div>

			<div class="sell-in-person-container">
			<input
				type="checkbox"
				id="kkart_sell_in_person"
				name="sell_in_person"
				value="yes"
				<?php checked( $sell_in_person, true ); ?>
			/>
			<label class="location-prompt" for="kkart_sell_in_person">
				<?php esc_html_e( 'I will also be selling products or services in person.', 'kkart' ); ?>
			</label>
			</div>

			<input type="checkbox" id="kkart_tracker_checkbox" name="kkart_tracker_checkbox" value="yes" <?php checked( 'yes', get_option( 'kkart_allow_tracking', 'no' ) ); ?> />

			<?php $this->tracking_modal(); ?>

			<p class="kkart-setup-actions step">
				<button class="button-primary button button-large" value="<?php esc_attr_e( "Let's go!", 'kkart' ); ?>" name="save_step"><?php esc_html_e( "Let's go!", 'kkart' ); ?></button>
			</p>
		</form>
		<?php
	}

	/**
	 * Template for the usage tracking modal.
	 *
	 * @deprecated 4.6.0
	 */
	public function tracking_modal() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		?>
		<script type="text/template" id="tmpl-kkart-modal-tracking-setup">
			<div class="kkart-backbone-modal kkart-tracker">
				<div class="kkart-backbone-modal-content">
					<section class="kkart-backbone-modal-main" role="main">
						<header class="kkart-backbone-modal-header">
							<h1><?php esc_html_e( 'Help improve Kkart with usage tracking', 'kkart' ); ?></h1>
						</header>
						<article>
							<p>
							<?php
								printf(
									wp_kses(
										/* translators: %1$s: usage tracking help link */
										__( 'Learn more about how usage tracking works, and how you\'ll be helping in our <a href="%1$s" target="_blank">usage tracking documentation</a>.', 'kkart' ),
										array(
											'a' => array(
												'href'   => array(),
												'target' => array(),
											),
										)
									),
									'https://kkart.com/usage-tracking/'
								);
							?>
							</p>
							<p class="kkart-tracker-checkbox">
								<input type="checkbox" id="kkart_tracker_checkbox_dialog" name="kkart_tracker_checkbox_dialog" value="yes" <?php checked( 'yes', get_option( 'kkart_allow_tracking', 'no' ) ); ?> />
								<label for="kkart_tracker_checkbox_dialog"><?php esc_html_e( 'Enable usage tracking and help improve Kkart', 'kkart' ); ?></label>
							</p>
						</article>
						<footer>
							<div class="inner">
								<button class="button button-primary button-large" id="kkart_tracker_submit" aria-label="<?php esc_attr_e( 'Continue', 'kkart' ); ?>"><?php esc_html_e( 'Continue', 'kkart' ); ?></button>
							</div>
						</footer>
					</section>
				</div>
			</div>
			<div class="kkart-backbone-modal-backdrop modal-close"></div>
		</script>
		<?php
	}

	/**
	 * Save initial store settings.
	 *
	 * @deprecated 4.6.0
	 */
	public function kkart_setup_store_setup_save() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
	}

	/**
	 * Finishes replying to the client, but keeps the process running for further (async) code execution.
	 *
	 * @see https://core.trac.wordpress.org/ticket/41358 .
	 */
	protected function close_http_connection() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		// Only 1 PHP process can access a session object at a time, close this so the next request isn't kept waiting.
		// @codingStandardsIgnoreStart
		if ( session_id() ) {
			session_write_close();
		}
		// @codingStandardsIgnoreEnd

		kkart_set_time_limit( 0 );

		// fastcgi_finish_request is the cleanest way to send the response and keep the script running, but not every server has it.
		if ( is_callable( 'fastcgi_finish_request' ) ) {
			fastcgi_finish_request();
		} else {
			// Fallback: send headers and flush buffers.
			if ( ! headers_sent() ) {
				header( 'Connection: close' );
			}
			@ob_end_flush(); // @codingStandardsIgnoreLine.
			flush();
		}
	}

	/**
	 * Function called after the HTTP request is finished, so it's executed without the client having to wait for it.
	 *
	 * @see KKART_Admin_Setup_Wizard::install_plugin
	 * @see KKART_Admin_Setup_Wizard::install_theme
	 *
	 * @deprecated 4.6.0
	 */
	public function run_deferred_actions() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$this->close_http_connection();
		foreach ( $this->deferred_actions as $action ) {
			$action['func']( ...$action['args'] );

			// Clear the background installation flag if this is a plugin.
			if (
				isset( $action['func'][1] ) &&
				'background_installer' === $action['func'][1] &&
				isset( $action['args'][0] )
			) {
				delete_option( 'kkart_setup_background_installing_' . $action['args'][0] );
			}
		}
	}

	/**
	 * Helper method to queue the background install of a plugin.
	 *
	 * @param string $plugin_id  Plugin id used for background install.
	 * @param array  $plugin_info Plugin info array containing name and repo-slug, and optionally file if different from [repo-slug].php.
	 *
	 * @deprecated 4.6.0
	 */
	protected function install_plugin( $plugin_id, $plugin_info ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		// Make sure we don't trigger multiple simultaneous installs.
		if ( get_option( 'kkart_setup_background_installing_' . $plugin_id ) ) {
			return;
		}

		$plugin_file = isset( $plugin_info['file'] ) ? $plugin_info['file'] : $plugin_info['repo-slug'] . '.php';
		if ( is_plugin_active( $plugin_info['repo-slug'] . '/' . $plugin_file ) ) {
			return;
		}

		if ( empty( $this->deferred_actions ) ) {
			add_action( 'shutdown', array( $this, 'run_deferred_actions' ) );
		}

		array_push(
			$this->deferred_actions,
			array(
				'func' => array( 'KKART_Install', 'background_installer' ),
				'args' => array( $plugin_id, $plugin_info ),
			)
		);

		// Set the background installation flag for this plugin.
		update_option( 'kkart_setup_background_installing_' . $plugin_id, true );
	}


	/**
	 * Helper method to queue the background install of a theme.
	 *
	 * @param string $theme_id  Theme id used for background install.
	 *
	 * @deprecated 4.6.0
	 */
	protected function install_theme( $theme_id ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		if ( empty( $this->deferred_actions ) ) {
			add_action( 'shutdown', array( $this, 'run_deferred_actions' ) );
		}
		array_push(
			$this->deferred_actions,
			array(
				'func' => array( 'KKART_Install', 'theme_background_installer' ),
				'args' => array( $theme_id ),
			)
		);
	}

	/**
	 * Helper method to install Jetpack.
	 *
	 * @deprecated 4.6.0
	 */
	protected function install_jetpack() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$this->install_plugin(
			'jetpack',
			array(
				'name'      => __( 'Jetpack', 'kkart' ),
				'repo-slug' => 'jetpack',
			)
		);
	}

	/**
	 * Helper method to install Kkart Services and its Jetpack dependency.
	 *
	 * @deprecated 4.6.0
	 */
	protected function install_kkart_services() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$this->install_jetpack();
		$this->install_plugin(
			'kkart-services',
			array(
				'name'      => __( 'Kkart Services', 'kkart' ),
				'repo-slug' => 'kkart-services',
			)
		);
	}

	/**
	 * Retrieve info for missing Kkart Services and/or Jetpack plugin.
	 *
	 * @deprecated 4.6.0
	 * @return array
	 */
	protected function get_wcs_requisite_plugins() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$plugins = array();
		if ( ! is_plugin_active( 'kkart-services/kkart-services.php' ) && ! get_option( 'kkart_setup_background_installing_kkart-services' ) ) {
			$plugins[] = array(
				'name' => __( 'Kkart Services', 'kkart' ),
				'slug' => 'kkart-services',
			);
		}
		if ( ! is_plugin_active( 'jetpack/jetpack.php' ) && ! get_option( 'kkart_setup_background_installing_jetpack' ) ) {
			$plugins[] = array(
				'name' => __( 'Jetpack', 'kkart' ),
				'slug' => 'jetpack',
			);
		}
		return $plugins;
	}

	/**
	 * Plugin install info message markup with heading.
	 *
	 * @deprecated 4.6.0
	 */
	public function plugin_install_info() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		?>
		<span class="plugin-install-info">
			<span class="plugin-install-info-label"><?php esc_html_e( 'The following plugins will be installed and activated for you:', 'kkart' ); ?></span>
			<span class="plugin-install-info-list"></span>
		</span>
		<?php
	}

	/**
	 * Get shipping methods based on country code.
	 *
	 * @param string $country_code Country code.
	 * @param string $currency_code Currency code.
	 *
	 * @deprecated 4.6.0
	 * @return array
	 */
	protected function get_wizard_shipping_methods( $country_code, $currency_code ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$shipping_methods = array(
			'flat_rate'     => array(
				'name'        => __( 'Flat Rate', 'kkart' ),
				'description' => __( 'Set a fixed price to cover shipping costs.', 'kkart' ),
				'settings'    => array(
					'cost' => array(
						'type'          => 'text',
						'default_value' => __( 'Cost', 'kkart' ),
						'description'   => __( 'What would you like to charge for flat rate shipping?', 'kkart' ),
						'required'      => true,
					),
				),
			),
			'free_shipping' => array(
				'name'        => __( 'Free Shipping', 'kkart' ),
				'description' => __( "Don't charge for shipping.", 'kkart' ),
			),
		);

		return $shipping_methods;
	}

	/**
	 * Render the available shipping methods for a given country code.
	 *
	 * @param string $country_code Country code.
	 * @param string $currency_code Currency code.
	 * @param string $input_prefix Input prefix.
	 *
	 * @deprecated 4.6.0
	 */
	protected function shipping_method_selection_form( $country_code, $currency_code, $input_prefix ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$selected         = 'flat_rate';
		$shipping_methods = $this->get_wizard_shipping_methods( $country_code, $currency_code );
		?>
		<div class="kkart-wizard-shipping-method-select">
			<div class="kkart-wizard-shipping-method-dropdown">
				<select
					id="<?php echo esc_attr( "{$input_prefix}[method]" ); ?>"
					name="<?php echo esc_attr( "{$input_prefix}[method]" ); ?>"
					class="method kkart-enhanced-select"
					data-plugins="<?php echo kkart_esc_json( wp_json_encode( $this->get_wcs_requisite_plugins() ) ); ?>"
				>
				<?php foreach ( $shipping_methods as $method_id => $method ) : ?>
					<option value="<?php echo esc_attr( $method_id ); ?>" <?php selected( $selected, $method_id ); ?>><?php echo esc_html( $method['name'] ); ?></option>
				<?php endforeach; ?>
				</select>
			</div>
			<div class="shipping-method-descriptions">
				<?php foreach ( $shipping_methods as $method_id => $method ) : ?>
					<p class="shipping-method-description <?php echo esc_attr( $method_id ); ?> <?php echo $method_id !== $selected ? 'hide' : ''; ?>">
						<?php echo esc_html( $method['description'] ); ?>
					</p>
				<?php endforeach; ?>
			</div>
		</div>

		<div class="shipping-method-settings">
		<?php foreach ( $shipping_methods as $method_id => $method ) : ?>
			<?php
			if ( empty( $method['settings'] ) ) {
				continue;
			}
			?>
			<div class="shipping-method-setting <?php echo esc_attr( $method_id ); ?> <?php echo $method_id !== $selected ? 'hide' : ''; ?>">
			<?php foreach ( $method['settings'] as $setting_id => $setting ) : ?>
				<?php $method_setting_id = "{$input_prefix}[{$method_id}][{$setting_id}]"; ?>
				<input
					type="<?php echo esc_attr( $setting['type'] ); ?>"
					placeholder="<?php echo esc_attr( $setting['default_value'] ); ?>"
					id="<?php echo esc_attr( $method_setting_id ); ?>"
					name="<?php echo esc_attr( $method_setting_id ); ?>"
					class="<?php echo esc_attr( $setting['required'] ? 'shipping-method-required-field' : '' ); ?>"
					<?php echo ( $method_id === $selected && $setting['required'] ) ? 'required' : ''; ?>
				/>
				<p class="description">
					<?php echo esc_html( $setting['description'] ); ?>
				</p>
			<?php endforeach; ?>
			</div>
		<?php endforeach; ?>
		</div>
		<?php
	}

	/**
	 * Render a product weight unit dropdown.
	 *
	 * @deprecated 4.6.0
	 * @return string
	 */
	protected function get_product_weight_selection() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$weight_unit = get_option( 'kkart_weight_unit' );
		ob_start();
		?>
		<span class="kkart-setup-shipping-unit">
			<select id="weight_unit" name="weight_unit" class="kkart-enhanced-select">
				<option value="kg" <?php selected( $weight_unit, 'kg' ); ?>><?php esc_html_e( 'Kilograms', 'kkart' ); ?></option>
				<option value="g" <?php selected( $weight_unit, 'g' ); ?>><?php esc_html_e( 'Grams', 'kkart' ); ?></option>
				<option value="lbs" <?php selected( $weight_unit, 'lbs' ); ?>><?php esc_html_e( 'Pounds', 'kkart' ); ?></option>
				<option value="oz" <?php selected( $weight_unit, 'oz' ); ?>><?php esc_html_e( 'Ounces', 'kkart' ); ?></option>
			</select>
		</span>
		<?php

		return ob_get_clean();
	}

	/**
	 * Render a product dimension unit dropdown.
	 *
	 * @deprecated 4.6.0
	 * @return string
	 */
	protected function get_product_dimension_selection() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$dimension_unit = get_option( 'kkart_dimension_unit' );
		ob_start();
		?>
		<span class="kkart-setup-shipping-unit">
			<select id="dimension_unit" name="dimension_unit" class="kkart-enhanced-select">
				<option value="m" <?php selected( $dimension_unit, 'm' ); ?>><?php esc_html_e( 'Meters', 'kkart' ); ?></option>
				<option value="cm" <?php selected( $dimension_unit, 'cm' ); ?>><?php esc_html_e( 'Centimeters', 'kkart' ); ?></option>
				<option value="mm" <?php selected( $dimension_unit, 'mm' ); ?>><?php esc_html_e( 'Millimeters', 'kkart' ); ?></option>
				<option value="in" <?php selected( $dimension_unit, 'in' ); ?>><?php esc_html_e( 'Inches', 'kkart' ); ?></option>
				<option value="yd" <?php selected( $dimension_unit, 'yd' ); ?>><?php esc_html_e( 'Yards', 'kkart' ); ?></option>
			</select>
		</span>
		<?php

		return ob_get_clean();
	}

	/**
	 * Shipping.
	 *
	 * @deprecated 4.6.0
	 */
	public function kkart_setup_shipping() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$country_code          = KKART()->countries->get_base_country();
		$country_name          = KKART()->countries->countries[ $country_code ];
		$prefixed_country_name = KKART()->countries->estimated_for_prefix( $country_code ) . $country_name;
		$currency_code         = get_kkart_currency();
		$existing_zones        = KKART_Shipping_Zones::get_zones();
		$intro_text            = '';

		if ( empty( $existing_zones ) ) {
			$intro_text = sprintf(
				/* translators: %s: country name including the 'the' prefix if needed */
				__( "We've created two Shipping Zones - for %s and for the rest of the world. Below you can set Flat Rate shipping costs for these Zones or offer Free Shipping.", 'kkart' ),
				$prefixed_country_name
			);
		}

		$is_wcs_labels_supported  = $this->is_wcs_shipping_labels_supported_country( $country_code );
		$is_shipstation_supported = $this->is_shipstation_supported_country( $country_code );

		?>
		<h1><?php esc_html_e( 'Shipping', 'kkart' ); ?></h1>
		<?php if ( $intro_text ) : ?>
			<p><?php echo wp_kses_post( $intro_text ); ?></p>
		<?php endif; ?>
		<form method="post">
			<?php if ( $is_wcs_labels_supported || $is_shipstation_supported ) : ?>
				<ul class="kkart-setup-shipping-recommended">
				<?php
				if ( $is_wcs_labels_supported ) :
					$this->display_recommended_item(
						array(
							'type'        => 'kkart_services',
							'title'       => __( 'Did you know you can print shipping labels at home?', 'kkart' ),
							'description' => __( 'Use Kkart Shipping (powered by Kkart Services & Jetpack) to save time at the post office by printing your shipping labels at home.', 'kkart' ),
							'img_url'     => KKART()->plugin_url() . '/assets/images/obw-kkart-services-icon.png',
							'img_alt'     => __( 'Kkart Services icon', 'kkart' ),
							'plugins'     => $this->get_wcs_requisite_plugins(),
						)
					);
				elseif ( $is_shipstation_supported ) :
					$this->display_recommended_item(
						array(
							'type'        => 'shipstation',
							'title'       => __( 'Did you know you can print shipping labels at home?', 'kkart' ),
							'description' => __( 'We recommend using ShipStation to save time at the post office by printing your shipping labels at home. Try ShipStation free for 30 days.', 'kkart' ),
							'img_url'     => KKART()->plugin_url() . '/assets/images/obw-shipstation-icon.png',
							'img_alt'     => __( 'ShipStation icon', 'kkart' ),
							'plugins'     => array(
								array(
									'name' => __( 'ShipStation', 'kkart' ),
									'slug' => 'kkart-shipstation-integration',
								),
							),
						)
					);
				endif;
				?>
				</ul>
			<?php endif; ?>

			<?php if ( empty( $existing_zones ) ) : ?>
				<ul class="kkart-wizard-services shipping">
					<li class="kkart-wizard-service-item">
						<div class="kkart-wizard-service-name">
							<p><?php echo esc_html_e( 'Shipping Zone', 'kkart' ); ?></p>
						</div>
						<div class="kkart-wizard-service-description">
							<p><?php echo esc_html_e( 'Shipping Method', 'kkart' ); ?></p>
						</div>
					</li>
					<li class="kkart-wizard-service-item">
						<div class="kkart-wizard-service-name">
							<p><?php echo esc_html( $country_name ); ?></p>
						</div>
						<div class="kkart-wizard-service-description">
							<?php $this->shipping_method_selection_form( $country_code, $currency_code, 'shipping_zones[domestic]' ); ?>
						</div>
						<div class="kkart-wizard-service-enable">
							<span class="kkart-wizard-service-toggle">
								<input id="shipping_zones[domestic][enabled]" type="checkbox" name="shipping_zones[domestic][enabled]" value="yes" checked="checked" class="kkart-wizard-shipping-method-enable" data-plugins="true" />
								<label for="shipping_zones[domestic][enabled]">
							</span>
						</div>
					</li>
					<li class="kkart-wizard-service-item">
						<div class="kkart-wizard-service-name">
							<p><?php echo esc_html_e( 'Locations not covered by your other zones', 'kkart' ); ?></p>
						</div>
						<div class="kkart-wizard-service-description">
							<?php $this->shipping_method_selection_form( $country_code, $currency_code, 'shipping_zones[intl]' ); ?>
						</div>
						<div class="kkart-wizard-service-enable">
							<span class="kkart-wizard-service-toggle">
								<input id="shipping_zones[intl][enabled]" type="checkbox" name="shipping_zones[intl][enabled]" value="yes" checked="checked" class="kkart-wizard-shipping-method-enable" data-plugins="true" />
								<label for="shipping_zones[intl][enabled]">
							</span>
						</div>
					</li>
					<li class="kkart-wizard-service-info">
						<p>
						<?php
						printf(
							wp_kses(
								/* translators: %1$s: live rates tooltip text, %2$s: shipping extensions URL */
								__( 'If you\'d like to offer <span class="help_tip" data-tip="%1$s">live rates</span> from a specific carrier (e.g. UPS) you can find a variety of extensions available for Kkart <a href="%2$s" target="_blank">here</a>.', 'kkart' ),
								array(
									'span' => array(
										'class'    => array(),
										'data-tip' => array(),
									),
									'a'    => array(
										'href'   => array(),
										'target' => array(),
									),
								)
							),
							esc_attr__( 'A live rate is the exact cost to ship an order, quoted directly from the shipping carrier.', 'kkart' ),
							'https://kkart.com/product-category/kkart-extensions/shipping-methods/shipping-carriers/'
						);
						?>
						</p>
					</li>
				</ul>
			<?php endif; ?>

			<div class="kkart-setup-shipping-units">
				<p>
					<?php
						echo wp_kses(
							sprintf(
								/* translators: %1$s: weight unit dropdown, %2$s: dimension unit dropdown */
								esc_html__( 'We\'ll use %1$s for product weight and %2$s for product dimensions.', 'kkart' ),
								$this->get_product_weight_selection(),
								$this->get_product_dimension_selection()
							),
							array(
								'span'   => array(
									'class' => array(),
								),
								'select' => array(
									'id'    => array(),
									'name'  => array(),
									'class' => array(),
								),
								'option' => array(
									'value'    => array(),
									'selected' => array(),
								),
							)
						);
					?>
				</p>
			</div>

			<p class="kkart-setup-actions step">
				<?php $this->plugin_install_info(); ?>
				<button class="button-primary button button-large button-next" value="<?php esc_attr_e( 'Continue', 'kkart' ); ?>" name="save_step"><?php esc_html_e( 'Continue', 'kkart' ); ?></button>
				<?php wp_nonce_field( 'kkart-setup' ); ?>
			</p>
		</form>
		<?php
	}

	/**
	 * Save shipping options.
	 *
	 * @deprecated 4.6.0
	 */
	public function kkart_setup_shipping_save() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
	}

	/**
	 * Is Stripe country supported
	 * https://stripe.com/global .
	 *
	 * @param string $country_code Country code.
	 *
	 * @deprecated 4.6.0
	 */
	protected function is_stripe_supported_country( $country_code ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$stripe_supported_countries = array(
			'AU',
			'AT',
			'BE',
			'CA',
			'DK',
			'FI',
			'FR',
			'DE',
			'HK',
			'IE',
			'JP',
			'LU',
			'NL',
			'NZ',
			'NO',
			'SG',
			'ES',
			'SE',
			'CH',
			'GB',
			'US',
		);

		return in_array( $country_code, $stripe_supported_countries, true );
	}

	/**
	 * Is PayPal currency supported.
	 *
	 * @param string $currency Currency code.
	 * @return boolean
	 *
	 * @deprecated 4.6.0
	 */
	protected function is_paypal_supported_currency( $currency ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$supported_currencies = array(
			'AUD',
			'BRL',
			'CAD',
			'MXN',
			'NZD',
			'HKD',
			'SGD',
			'USD',
			'EUR',
			'JPY',
			'TRY',
			'NOK',
			'CZK',
			'DKK',
			'HUF',
			'ILS',
			'MYR',
			'PHP',
			'PLN',
			'SEK',
			'CHF',
			'TWD',
			'THB',
			'GBP',
			'RMB',
			'RUB',
			'INR',
		);
		return in_array( $currency, $supported_currencies, true );
	}

	/**
	 * Is Klarna Checkout country supported.
	 *
	 * @param string $country_code Country code.
	 *
	 * @deprecated 4.6.0
	 */
	protected function is_klarna_checkout_supported_country( $country_code ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$supported_countries = array(
			'SE', // Sweden.
			'FI', // Finland.
			'NO', // Norway.
			'NL', // Netherlands.
		);
		return in_array( $country_code, $supported_countries, true );
	}

	/**
	 * Is Klarna Payments country supported.
	 *
	 * @param string $country_code Country code.
	 *
	 * @deprecated 4.6.0
	 */
	protected function is_klarna_payments_supported_country( $country_code ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$supported_countries = array(
			'DK', // Denmark.
			'DE', // Germany.
			'AT', // Austria.
		);
		return in_array( $country_code, $supported_countries, true );
	}

	/**
	 * Is Square country supported
	 *
	 * @param string $country_code Country code.
	 *
	 * @deprecated 4.6.0
	 */
	protected function is_square_supported_country( $country_code ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$square_supported_countries = array(
			'US',
			'CA',
			'JP',
			'GB',
			'AU',
		);
		return in_array( $country_code, $square_supported_countries, true );
	}

	/**
	 * Is eWAY Payments country supported
	 *
	 * @param string $country_code Country code.
	 *
	 * @deprecated 4.6.0
	 */
	protected function is_eway_payments_supported_country( $country_code ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$supported_countries = array(
			'AU', // Australia.
			'NZ', // New Zealand.
		);
		return in_array( $country_code, $supported_countries, true );
	}

	/**
	 * Is ShipStation country supported
	 *
	 * @param string $country_code Country code.
	 *
	 * @deprecated 4.6.0
	 */
	protected function is_shipstation_supported_country( $country_code ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$supported_countries = array(
			'AU', // Australia.
			'CA', // Canada.
			'GB', // United Kingdom.
		);
		return in_array( $country_code, $supported_countries, true );
	}

	/**
	 * Is Kkart Services shipping label country supported
	 *
	 * @param string $country_code Country code.
	 *
	 * @deprecated 4.6.0
	 */
	protected function is_wcs_shipping_labels_supported_country( $country_code ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$supported_countries = array(
			'US', // United States.
		);
		return in_array( $country_code, $supported_countries, true );
	}

	/**
	 * Helper method to retrieve the current user's email address.
	 *
	 * @deprecated 4.6.0
	 * @return string Email address
	 */
	protected function get_current_user_email() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$current_user = wp_get_current_user();
		$user_email   = $current_user->user_email;

		return $user_email;
	}

	/**
	 * Array of all possible "in cart" gateways that can be offered.
	 *
	 * @deprecated 4.6.0
	 * @return array
	 */
	protected function get_wizard_available_in_cart_payment_gateways() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$user_email = $this->get_current_user_email();

		$stripe_description = '<p>' . sprintf(
			/* translators: %s: URL */
			__( 'Accept debit and credit cards in 135+ currencies, methods such as Alipay, and one-touch checkout with Apple Pay. <a href="%s" target="_blank">Learn more</a>.', 'kkart' ),
			'https://kkart.com/products/stripe/'
		) . '</p>';
		$paypal_checkout_description = '<p>' . sprintf(
			/* translators: %s: URL */
			__( 'Safe and secure payments using credit cards or your customer\'s PayPal account. <a href="%s" target="_blank">Learn more</a>.', 'kkart' ),
			'https://kkart.com/products/kkart-gateway-paypal-checkout/'
		) . '</p>';
		$klarna_checkout_description = '<p>' . sprintf(
			/* translators: %s: URL */
			__( 'Full checkout experience with pay now, pay later and slice it. No credit card numbers, no passwords, no worries. <a href="%s" target="_blank">Learn more about Klarna</a>.', 'kkart' ),
			'https://kkart.com/products/klarna-checkout/'
		) . '</p>';
		$klarna_payments_description = '<p>' . sprintf(
			/* translators: %s: URL */
			__( 'Choose the payment that you want, pay now, pay later or slice it. No credit card numbers, no passwords, no worries. <a href="%s" target="_blank">Learn more about Klarna</a>.', 'kkart' ),
			'https://kkart.com/products/klarna-payments/ '
		) . '</p>';
		$square_description = '<p>' . sprintf(
			/* translators: %s: URL */
			__( 'Securely accept credit and debit cards with one low rate, no surprise fees (custom rates available). Sell online and in store and track sales and inventory in one place. <a href="%s" target="_blank">Learn more about Square</a>.', 'kkart' ),
			'https://kkart.com/products/square/'
		) . '</p>';

		return array(
			'stripe'          => array(
				'name'        => __( 'Kkart Stripe Gateway', 'kkart' ),
				'image'       => KKART()->plugin_url() . '/assets/images/stripe.png',
				'description' => $stripe_description,
				'class'       => 'checked stripe-logo',
				'repo-slug'   => 'kkart-gateway-stripe',
				'settings'    => array(
					'create_account' => array(
						'label'       => __( 'Set up Stripe for me using this email:', 'kkart' ),
						'type'        => 'checkbox',
						'value'       => 'yes',
						'default'     => 'yes',
						'placeholder' => '',
						'required'    => false,
						'plugins'     => $this->get_wcs_requisite_plugins(),
					),
					'email'          => array(
						'label'       => __( 'Stripe email address:', 'kkart' ),
						'type'        => 'email',
						'value'       => $user_email,
						'placeholder' => __( 'Stripe email address', 'kkart' ),
						'required'    => true,
					),
				),
			),
			'ppec_paypal'     => array(
				'name'        => __( 'Kkart PayPal Checkout Gateway', 'kkart' ),
				'image'       => KKART()->plugin_url() . '/assets/images/paypal.png',
				'description' => $paypal_checkout_description,
				'enabled'     => false,
				'class'       => 'checked paypal-logo',
				'repo-slug'   => 'kkart-gateway-paypal-express-checkout',
				'settings'    => array(
					'reroute_requests' => array(
						'label'       => __( 'Set up PayPal for me using this email:', 'kkart' ),
						'type'        => 'checkbox',
						'value'       => 'yes',
						'default'     => 'yes',
						'placeholder' => '',
						'required'    => false,
						'plugins'     => $this->get_wcs_requisite_plugins(),
					),
					'email'            => array(
						'label'       => __( 'Direct payments to email address:', 'kkart' ),
						'type'        => 'email',
						'value'       => $user_email,
						'placeholder' => __( 'Email address to receive payments', 'kkart' ),
						'required'    => true,
					),
				),
			),
			'paypal'          => array(
				'name'        => __( 'PayPal Standard', 'kkart' ),
				'description' => __( 'Accept payments via PayPal using account balance or credit card.', 'kkart' ),
				'image'       => '',
				'settings'    => array(
					'email' => array(
						'label'       => __( 'PayPal email address:', 'kkart' ),
						'type'        => 'email',
						'value'       => $user_email,
						'placeholder' => __( 'PayPal email address', 'kkart' ),
						'required'    => true,
					),
				),
			),
			'klarna_checkout' => array(
				'name'        => __( 'Klarna Checkout for Kkart', 'kkart' ),
				'description' => $klarna_checkout_description,
				'image'       => KKART()->plugin_url() . '/assets/images/klarna-black.png',
				'enabled'     => true,
				'class'       => 'klarna-logo',
				'repo-slug'   => 'klarna-checkout-for-kkart',
			),
			'klarna_payments' => array(
				'name'        => __( 'Klarna Payments for Kkart', 'kkart' ),
				'description' => $klarna_payments_description,
				'image'       => KKART()->plugin_url() . '/assets/images/klarna-black.png',
				'enabled'     => true,
				'class'       => 'klarna-logo',
				'repo-slug'   => 'klarna-payments-for-kkart',
			),
			'square'          => array(
				'name'        => __( 'Kkart Square', 'kkart' ),
				'description' => $square_description,
				'image'       => KKART()->plugin_url() . '/assets/images/square-black.png',
				'class'       => 'square-logo',
				'enabled'     => false,
				'repo-slug'   => 'kkart-square',
			),
			'eway'            => array(
				'name'        => __( 'Kkart eWAY Gateway', 'kkart' ),
				'description' => __( 'The eWAY extension for Kkart allows you to take credit card payments directly on your store without redirecting your customers to a third party site to make payment.', 'kkart' ),
				'image'       => KKART()->plugin_url() . '/assets/images/eway-logo.jpg',
				'enabled'     => false,
				'class'       => 'eway-logo',
				'repo-slug'   => 'kkart-gateway-eway',
			),
			'payfast'         => array(
				'name'        => __( 'Kkart PayFast Gateway', 'kkart' ),
				'description' => __( 'The PayFast extension for Kkart enables you to accept payments by Credit Card and EFT via one of South Africa’s most popular payment gateways. No setup fees or monthly subscription costs.', 'kkart' ),
				'image'       => KKART()->plugin_url() . '/assets/images/payfast.png',
				'class'       => 'payfast-logo',
				'enabled'     => false,
				'repo-slug'   => 'kkart-payfast-gateway',
				'file'        => 'gateway-payfast.php',
			),
		);
	}

	/**
	 * Simple array of "in cart" gateways to show in wizard.
	 *
	 * @deprecated 4.6.0
	 * @return array
	 */
	public function get_wizard_in_cart_payment_gateways() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$gateways = $this->get_wizard_available_in_cart_payment_gateways();
		$country  = KKART()->countries->get_base_country();
		$currency = get_kkart_currency();

		$can_stripe  = $this->is_stripe_supported_country( $country );
		$can_eway    = $this->is_eway_payments_supported_country( $country );
		$can_payfast = ( 'ZA' === $country ); // South Africa.
		$can_paypal  = $this->is_paypal_supported_currency( $currency );

		if ( ! current_user_can( 'install_plugins' ) ) {
			return $can_paypal ? array( 'paypal' => $gateways['paypal'] ) : array();
		}

		$klarna_or_square = false;

		if ( $this->is_klarna_checkout_supported_country( $country ) ) {
			$klarna_or_square = 'klarna_checkout';
		} elseif ( $this->is_klarna_payments_supported_country( $country ) ) {
			$klarna_or_square = 'klarna_payments';
		} elseif ( $this->is_square_supported_country( $country ) && get_option( 'kkart_sell_in_person' ) ) {
			$klarna_or_square = 'square';
		}

		$offered_gateways = array();

		if ( $can_stripe ) {
			$gateways['stripe']['enabled']  = true;
			$gateways['stripe']['featured'] = true;
			$offered_gateways              += array( 'stripe' => $gateways['stripe'] );
		} elseif ( $can_paypal ) {
			$gateways['ppec_paypal']['enabled'] = true;
		}

		if ( $klarna_or_square ) {
			if ( in_array( $klarna_or_square, array( 'klarna_checkout', 'klarna_payments' ), true ) ) {
				$gateways[ $klarna_or_square ]['enabled']  = true;
				$gateways[ $klarna_or_square ]['featured'] = false;
				$offered_gateways                         += array(
					$klarna_or_square => $gateways[ $klarna_or_square ],
				);
			} else {
				$offered_gateways += array(
					$klarna_or_square => $gateways[ $klarna_or_square ],
				);
			}
		}

		if ( $can_paypal ) {
			$offered_gateways += array( 'ppec_paypal' => $gateways['ppec_paypal'] );
		}

		if ( $can_eway ) {
			$offered_gateways += array( 'eway' => $gateways['eway'] );
		}

		if ( $can_payfast ) {
			$offered_gateways += array( 'payfast' => $gateways['payfast'] );
		}

		return $offered_gateways;
	}

	/**
	 * Simple array of "manual" gateways to show in wizard.
	 *
	 * @deprecated 4.6.0
	 * @return array
	 */
	public function get_wizard_manual_payment_gateways() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$gateways = array(
			'cheque' => array(
				'name'        => _x( 'Check payments', 'Check payment method', 'kkart' ),
				'description' => __( 'A simple offline gateway that lets you accept a check as method of payment.', 'kkart' ),
				'image'       => '',
				'class'       => '',
			),
			'bacs'   => array(
				'name'        => __( 'Bank transfer (BACS) payments', 'kkart' ),
				'description' => __( 'A simple offline gateway that lets you accept BACS payment.', 'kkart' ),
				'image'       => '',
				'class'       => '',
			),
			'cod'    => array(
				'name'        => __( 'Cash on delivery', 'kkart' ),
				'description' => __( 'A simple offline gateway that lets you accept cash on delivery.', 'kkart' ),
				'image'       => '',
				'class'       => '',
			),
		);

		return $gateways;
	}

	/**
	 * Display service item in list.
	 *
	 * @param int   $item_id Item ID.
	 * @param array $item_info Item info array.
	 *
	 * @deprecated 4.6.0
	 */
	public function display_service_item( $item_id, $item_info ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$item_class = 'kkart-wizard-service-item';
		if ( isset( $item_info['class'] ) ) {
			$item_class .= ' ' . $item_info['class'];
		}

		$previously_saved_settings = get_option( 'kkart_' . $item_id . '_settings' );

		// Show the user-saved state if it was previously saved.
		// Otherwise, rely on the item info.
		if ( is_array( $previously_saved_settings ) ) {
			$should_enable_toggle = ( isset( $previously_saved_settings['enabled'] ) && 'yes' === $previously_saved_settings['enabled'] ) ? true : ( isset( $item_info['enabled'] ) && $item_info['enabled'] );
		} else {
			$should_enable_toggle = isset( $item_info['enabled'] ) && $item_info['enabled'];
		}

		$plugins = null;
		if ( isset( $item_info['repo-slug'] ) ) {
			$plugin  = array(
				'slug' => $item_info['repo-slug'],
				'name' => $item_info['name'],
			);
			$plugins = array( $plugin );
		}

		?>
		<li class="<?php echo esc_attr( $item_class ); ?>">
			<div class="kkart-wizard-service-name">
				<?php if ( ! empty( $item_info['image'] ) ) : ?>
					<img src="<?php echo esc_attr( $item_info['image'] ); ?>" alt="<?php echo esc_attr( $item_info['name'] ); ?>" />
				<?php else : ?>
					<p><?php echo esc_html( $item_info['name'] ); ?></p>
				<?php endif; ?>
			</div>
			<div class="kkart-wizard-service-enable">
				<span class="kkart-wizard-service-toggle <?php echo esc_attr( $should_enable_toggle ? '' : 'disabled' ); ?>" tabindex="0">
					<input
						id="kkart-wizard-service-<?php echo esc_attr( $item_id ); ?>"
						type="checkbox"
						name="kkart-wizard-service-<?php echo esc_attr( $item_id ); ?>-enabled"
						value="yes" <?php checked( $should_enable_toggle ); ?>
						data-plugins="<?php echo kkart_esc_json( wp_json_encode( $plugins ) ); ?>"
					/>
					<label for="kkart-wizard-service-<?php echo esc_attr( $item_id ); ?>">
				</span>
			</div>
			<div class="kkart-wizard-service-description">
				<?php echo wp_kses_post( wpautop( $item_info['description'] ) ); ?>
				<?php if ( ! empty( $item_info['settings'] ) ) : ?>
					<div class="kkart-wizard-service-settings <?php echo $should_enable_toggle ? '' : 'hide'; ?>">
						<?php foreach ( $item_info['settings'] as $setting_id => $setting ) : ?>
							<?php
							$is_checkbox = 'checkbox' === $setting['type'];

							if ( $is_checkbox ) {
								$checked = false;
								if ( isset( $previously_saved_settings[ $setting_id ] ) ) {
									$checked = 'yes' === $previously_saved_settings[ $setting_id ];
								} elseif ( false === $previously_saved_settings && isset( $setting['default'] ) ) {
									$checked = 'yes' === $setting['default'];
								}
							}
							if ( 'email' === $setting['type'] ) {
								$value = empty( $previously_saved_settings[ $setting_id ] )
									? $setting['value']
									: $previously_saved_settings[ $setting_id ];
							}
							?>
							<?php $input_id = $item_id . '_' . $setting_id; ?>
							<div class="<?php echo esc_attr( 'kkart-wizard-service-setting-' . $input_id ); ?>">
								<label
									for="<?php echo esc_attr( $input_id ); ?>"
									class="<?php echo esc_attr( $input_id ); ?>"
								>
									<?php echo esc_html( $setting['label'] ); ?>
								</label>
								<input
									type="<?php echo esc_attr( $setting['type'] ); ?>"
									id="<?php echo esc_attr( $input_id ); ?>"
									class="<?php echo esc_attr( 'payment-' . $setting['type'] . '-input' ); ?>"
									name="<?php echo esc_attr( $input_id ); ?>"
									value="<?php echo esc_attr( isset( $value ) ? $value : $setting['value'] ); ?>"
									placeholder="<?php echo esc_attr( $setting['placeholder'] ); ?>"
									<?php echo ( $setting['required'] ) ? 'required' : ''; ?>
									<?php echo $is_checkbox ? checked( isset( $checked ) && $checked, true, false ) : ''; ?>
									data-plugins="<?php echo kkart_esc_json( wp_json_encode( isset( $setting['plugins'] ) ? $setting['plugins'] : null ) ); ?>"
								/>
								<?php if ( ! empty( $setting['description'] ) ) : ?>
									<span class="kkart-wizard-service-settings-description"><?php echo esc_html( $setting['description'] ); ?></span>
								<?php endif; ?>
							</div>
						<?php endforeach; ?>
					</div>
				<?php endif; ?>
			</div>
		</li>
		<?php
	}

	/**
	 * Is it a featured service?
	 *
	 * @param array $service Service info array.
	 *
	 * @deprecated 4.6.0
	 * @return boolean
	 */
	public function is_featured_service( $service ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		return ! empty( $service['featured'] );
	}

	/**
	 * Is this a non featured service?
	 *
	 * @param array $service Service info array.
	 *
	 * @deprecated 4.6.0
	 * @return boolean
	 */
	public function is_not_featured_service( $service ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		return ! $this->is_featured_service( $service );
	}

	/**
	 * Payment Step.
	 *
	 * @deprecated 4.6.0
	 */
	public function kkart_setup_payment() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$featured_gateways = array_filter( $this->get_wizard_in_cart_payment_gateways(), array( $this, 'is_featured_service' ) );
		$in_cart_gateways  = array_filter( $this->get_wizard_in_cart_payment_gateways(), array( $this, 'is_not_featured_service' ) );
		$manual_gateways   = $this->get_wizard_manual_payment_gateways();
		?>
		<h1><?php esc_html_e( 'Payment', 'kkart' ); ?></h1>
		<form method="post" class="kkart-wizard-payment-gateway-form">
			<p>
				<?php
				printf(
					wp_kses(
						/* translators: %s: Link */
						__( 'Kkart can accept both online and offline payments. <a href="%s" target="_blank">Additional payment methods</a> can be installed later.', 'kkart' ),
						array(
							'a' => array(
								'href'   => array(),
								'target' => array(),
							),
						)
					),
					esc_url( admin_url( 'admin.php?page=kkart-addons&section=payment-gateways' ) )
				);
				?>
			</p>
			<?php if ( $featured_gateways ) : ?>
			<ul class="kkart-wizard-services featured">
				<?php
				foreach ( $featured_gateways as $gateway_id => $gateway ) {
					$this->display_service_item( $gateway_id, $gateway );
				}
				?>
			</ul>
			<?php endif; ?>
			<?php if ( $in_cart_gateways ) : ?>
			<ul class="kkart-wizard-services in-cart">
				<?php
				foreach ( $in_cart_gateways as $gateway_id => $gateway ) {
					$this->display_service_item( $gateway_id, $gateway );
				}
				?>
			</ul>
			<?php endif; ?>
			<ul class="kkart-wizard-services manual">
				<li class="kkart-wizard-services-list-toggle closed">
					<div class="kkart-wizard-service-name">
						<?php esc_html_e( 'Offline Payments', 'kkart' ); ?>
					</div>
					<div class="kkart-wizard-service-description">
						<?php esc_html_e( 'Collect payments from customers offline.', 'kkart' ); ?>
					</div>
					<div class="kkart-wizard-service-enable" tabindex="0">
						<input class="kkart-wizard-service-list-toggle" id="kkart-wizard-service-list-toggle" type="checkbox">
						<label for="kkart-wizard-service-list-toggle"></label>
					</div>
				</li>
				<?php
				foreach ( $manual_gateways as $gateway_id => $gateway ) {
					$this->display_service_item( $gateway_id, $gateway );
				}
				?>
			</ul>
			<p class="kkart-setup-actions step">
				<?php $this->plugin_install_info(); ?>
				<button type="submit" class="button-primary button button-large button-next" value="<?php esc_attr_e( 'Continue', 'kkart' ); ?>" name="save_step"><?php esc_html_e( 'Continue', 'kkart' ); ?></button>
				<?php wp_nonce_field( 'kkart-setup' ); ?>
			</p>
		</form>
		<?php
	}

	/**
	 * Payment Step save.
	 *
	 * @deprecated 4.6.0
	 */
	public function kkart_setup_payment_save() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
	}

	protected function display_recommended_item( $item_info ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$type        = $item_info['type'];
		$title       = $item_info['title'];
		$description = $item_info['description'];
		$img_url     = $item_info['img_url'];
		$img_alt     = $item_info['img_alt'];
		?>
		<li class="recommended-item checkbox">
			<input
				id="<?php echo esc_attr( 'kkart_recommended_' . $type ); ?>"
				type="checkbox"
				name="<?php echo esc_attr( 'setup_' . $type ); ?>"
				value="yes"
				checked
				data-plugins="<?php echo kkart_esc_json( wp_json_encode( isset( $item_info['plugins'] ) ? $item_info['plugins'] : null ) ); ?>"
			/>
			<label for="<?php echo esc_attr( 'kkart_recommended_' . $type ); ?>">
				<img
					src="<?php echo esc_url( $img_url ); ?>"
					class="<?php echo esc_attr( 'recommended-item-icon-' . $type ); ?> recommended-item-icon"
					alt="<?php echo esc_attr( $img_alt ); ?>" />
				<div class="recommended-item-description-container">
					<h3><?php echo esc_html( $title ); ?></h3>
					<p><?php echo wp_kses( $description, array(
						'a' => array(
							'href'   => array(),
							'target' => array(),
							'rel'    => array(),
						),
						'em' => array(),
					) ); ?></p>
				</div>
			</label>
		</li>
		<?php
	}

	/**
	 * Recommended step
	 *
	 * @deprecated 4.6.0
	 */
	public function kkart_setup_recommended() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		?>
		<h1><?php esc_html_e( 'Recommended for All Kkart Stores', 'kkart' ); ?></h1>
		<p>
			<?php esc_html_e( 'Enhance your store with these recommended free features.', 'kkart' ); ?>
		</p>
		<form method="post">
			<ul class="recommended-step">
				<?php
				if ( $this->should_show_theme() ) :
					$theme      = wp_get_theme();
					$theme_name = $theme['Name'];
					$this->display_recommended_item( array(
						'type'        => 'storefront_theme',
						'title'       => __( 'Storefront Theme', 'kkart' ),
						'description' => sprintf( __(
								'Design your store with deep Kkart integration. If toggled on, we’ll install <a href="https://kkart.com/storefront/" target="_blank" rel="noopener noreferrer">Storefront</a>, and your current theme <em>%s</em> will be deactivated.', 'kkart' ),
								$theme_name
						),
						'img_url'     => KKART()->plugin_url() . '/assets/images/obw-storefront-icon.svg',
						'img_alt'     => __( 'Storefront icon', 'kkart' ),
					) );
				endif;

				if ( $this->should_show_automated_tax() ) :
					$this->display_recommended_item( array(
						'type'        => 'automated_taxes',
						'title'       => __( 'Automated Taxes', 'kkart' ),
						'description' => __( 'Save time and errors with automated tax calculation and collection at checkout. Powered by Kkart Services and Jetpack.', 'kkart' ),
						'img_url'     => KKART()->plugin_url() . '/assets/images/obw-taxes-icon.svg',
						'img_alt'     => __( 'automated taxes icon', 'kkart' ),
						'plugins'     => $this->get_wcs_requisite_plugins(),
					) );
				endif;

				if ( $this->should_show_kkart_admin() ) :
					$this->display_recommended_item( array(
						'type'        => 'kkart_admin',
						'title'       => __( 'Kkart Admin', 'kkart' ),
						'description' => __( 'Manage your store\'s reports and monitor key metrics with a new and improved interface and dashboard.', 'kkart' ),
						'img_url'     => KKART()->plugin_url() . '/assets/images/obw-kkart-admin-icon.svg',
						'img_alt'     => __( 'Kkart Admin icon', 'kkart' ),
						'plugins'     => array( array( 'name' => __( 'Kkart Admin', 'kkart' ), 'slug' => 'kkart-admin' ) ),
					) );
				endif;

				if ( $this->should_show_mailchimp() ) :
					$this->display_recommended_item( array(
						'type'        => 'mailchimp',
						'title'       => __( 'Mailchimp', 'kkart' ),
						'description' => __( 'Join the 16 million customers who use Mailchimp. Sync list and store data to send automated emails, and targeted campaigns.', 'kkart' ),
						'img_url'     => KKART()->plugin_url() . '/assets/images/obw-mailchimp-icon.svg',
						'img_alt'     => __( 'Mailchimp icon', 'kkart' ),
						'plugins'     => array( array( 'name' => __( 'Mailchimp for Kkart', 'kkart' ), 'slug' => 'mailchimp-for-kkart' ) ),
					) );
				endif;

				if ( $this->should_show_facebook() ) :
					$this->display_recommended_item( array(
						'type'        => 'facebook',
						'title'       => __( 'Facebook', 'kkart' ),
						'description' => __( 'Enjoy all Facebook products combined in one extension: pixel tracking, catalog sync, messenger chat, shop functionality and Instagram shopping (coming soon)!', 'kkart' ),
						'img_url'     => KKART()->plugin_url() . '/assets/images/obw-facebook-icon.svg',
						'img_alt'     => __( 'Facebook icon', 'kkart' ),
						'plugins'     => array( array( 'name' => __( 'Facebook for Kkart', 'kkart' ), 'slug' => 'facebook-for-kkart' ) ),
					) );
				endif;
			?>
		</ul>
			<p class="kkart-setup-actions step">
				<?php $this->plugin_install_info(); ?>
				<button type="submit" class="button-primary button button-large button-next" value="<?php esc_attr_e( 'Continue', 'kkart' ); ?>" name="save_step"><?php esc_html_e( 'Continue', 'kkart' ); ?></button>
				<?php wp_nonce_field( 'kkart-setup' ); ?>
			</p>
		</form>
		<?php
	}

	/**
	 * Recommended step save.
	 *
	 * @deprecated 4.6.0
	 */
	public function kkart_setup_recommended_save() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
	}

	/**
	 * Go to the next step if Jetpack was connected.
	 */
	protected function kkart_setup_activate_actions() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		if (
			isset( $_GET['from'] ) &&
			'wpcom' === $_GET['from'] &&
			class_exists( 'Jetpack' ) &&
			Jetpack::is_active()
		) {
			wp_redirect( esc_url_raw( remove_query_arg( 'from', $this->get_next_step_link() ) ) );
			exit;
		}
	}

	/**
	 *
	 * @deprecated 4.6.0
	 */
	protected function kkart_setup_activate_get_feature_list() {
		$features = array();

		$stripe_settings = get_option( 'kkart_stripe_settings', false );
		$stripe_enabled  = is_array( $stripe_settings )
			&& isset( $stripe_settings['create_account'] ) && 'yes' === $stripe_settings['create_account']
			&& isset( $stripe_settings['enabled'] ) && 'yes' === $stripe_settings['enabled'];
		$ppec_settings   = get_option( 'kkart_ppec_paypal_settings', false );
		$ppec_enabled    = is_array( $ppec_settings )
			&& isset( $ppec_settings['reroute_requests'] ) && 'yes' === $ppec_settings['reroute_requests']
			&& isset( $ppec_settings['enabled'] ) && 'yes' === $ppec_settings['enabled'];

		$features['payment'] = $stripe_enabled || $ppec_enabled;
		$features['taxes']   = (bool) get_option( 'kkart_setup_automated_taxes', false );
		$features['labels']  = (bool) get_option( 'kkart_setup_shipping_labels', false );

		return $features;
	}

	/**
	 *
	 * @deprecated 4.6.0
	 */
	protected function kkart_setup_activate_get_feature_list_str() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$features = $this->kkart_setup_activate_get_feature_list();
		if ( $features['payment'] && $features['taxes'] && $features['labels'] ) {
			return __( 'payment setup, automated taxes and discounted shipping labels', 'kkart' );
		} else if ( $features['payment'] && $features['taxes'] ) {
			return __( 'payment setup and automated taxes', 'kkart' );
		} else if ( $features['payment'] && $features['labels'] ) {
			return __( 'payment setup and discounted shipping labels', 'kkart' );
		} else if ( $features['payment'] ) {
			return __( 'payment setup', 'kkart' );
		} else if ( $features['taxes'] && $features['labels'] ) {
			return __( 'automated taxes and discounted shipping labels', 'kkart' );
		} else if ( $features['taxes'] ) {
			return __( 'automated taxes', 'kkart' );
		} else if ( $features['labels'] ) {
			return __( 'discounted shipping labels', 'kkart' );
		}
		return false;
	}

	/**
	 * Activate step.
	 *
	 * @deprecated 4.6.0
	 */
	public function kkart_setup_activate() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$this->kkart_setup_activate_actions();

		$jetpack_connected = class_exists( 'Jetpack' ) && Jetpack::is_active();

		$has_jetpack_error = false;
		if ( isset( $_GET['activate_error'] ) ) {
			$has_jetpack_error = true;

			$title = __( "Sorry, we couldn't connect your store to Jetpack", 'kkart' );

			$error_message = $this->get_activate_error_message( sanitize_text_field( wp_unslash( $_GET['activate_error'] ) ) );
			$description = $error_message;
		} else {
			$feature_list = $this->kkart_setup_activate_get_feature_list_str();

			$description = false;

			if ( $feature_list ) {
				if ( ! $jetpack_connected ) {
					/* translators: %s: list of features, potentially comma separated */
					$description_base = __( 'Your store is almost ready! To activate services like %s, just connect with Jetpack.', 'kkart' );
				} else {
					$description_base = __( 'Thanks for using Jetpack! Your store is almost ready: to activate services like %s, just connect your store.', 'kkart' );
				}
				$description = sprintf( $description_base, $feature_list );
			}

			if ( ! $jetpack_connected ) {
				$title = $feature_list ?
					__( 'Connect your store to Jetpack', 'kkart' ) :
					__( 'Connect your store to Jetpack to enable extra features', 'kkart' );
				$button_text = __( 'Continue with Jetpack', 'kkart' );
			} elseif ( $feature_list ) {
				$title = __( 'Connect your store to activate Kkart Services', 'kkart' );
				$button_text = __( 'Continue with Kkart Services', 'kkart' );
			} else {
				wp_redirect( esc_url_raw( $this->get_next_step_link() ) );
				exit;
			}
		}
		?>
		<h1><?php echo esc_html( $title ); ?></h1>
		<p><?php echo esc_html( $description ); ?></p>

		<?php if ( $jetpack_connected ) : ?>
			<div class="activate-splash">
				<img
					class="jetpack-logo"
					src="<?php echo esc_url( KKART()->plugin_url() . '/assets/images/jetpack_horizontal_logo.png' ); ?>"
					alt="<?php esc_attr_e( 'Jetpack logo', 'kkart' ); ?>"
				/>
				<img
					class="wcs-notice"
					src="<?php echo esc_url( KKART()->plugin_url() . '/assets/images/wcs-notice.png' ); ?>"
				/>
			</div>
		<?php else : ?>
			<img
				class="jetpack-logo"
				src="<?php echo esc_url( KKART()->plugin_url() . '/assets/images/jetpack_vertical_logo.png' ); ?>"
				alt="<?php esc_attr_e( 'Jetpack logo', 'kkart' ); ?>"
			/>
		<?php endif; ?>

		<?php if ( $has_jetpack_error ) : ?>
			<p class="kkart-setup-actions step">
				<a
					href="<?php echo esc_url( $this->get_next_step_link() ); ?>"
					class="button-primary button button-large"
				>
					<?php esc_html_e( 'Finish setting up your store', 'kkart' ); ?>
				</a>
			</p>
		<?php else : ?>
			<p class="jetpack-terms">
				<?php
					printf(
						wp_kses_post( __( 'By connecting your site you agree to our fascinating <a href="%1$s" target="_blank">Terms of Service</a> and to <a href="%2$s" target="_blank">share details</a> with WordPress.com', 'kkart' ) ),
						'https://wordpress.com/tos',
						'https://jetpack.com/support/what-data-does-jetpack-sync'
					);
				?>
			</p>
			<form method="post" class="activate-jetpack">
				<p class="kkart-setup-actions step">
					<button type="submit" class="button-primary button button-large" value="<?php echo esc_attr( $button_text ); ?>"><?php echo esc_html( $button_text ); ?></button>
				</p>
				<input type="hidden" name="save_step" value="activate" />
				<?php wp_nonce_field( 'kkart-setup' ); ?>
			</form>
			<?php if ( ! $jetpack_connected ) : ?>
				<h3 class="jetpack-reasons">
					<?php
						echo esc_html( $description ?
							__( "Bonus reasons you'll love Jetpack", 'kkart' ) :
							__( "Reasons you'll love Jetpack", 'kkart' )
						);
					?>
				</h3>
				<ul class="kkart-wizard-features">
					<li class="kkart-wizard-feature-item">
						<p class="kkart-wizard-feature-name">
							<strong><?php esc_html_e( 'Better security', 'kkart' ); ?></strong>
						</p>
						<p class="kkart-wizard-feature-description">
							<?php esc_html_e( 'Protect your store from unauthorized access.', 'kkart' ); ?>
						</p>
					</li>
					<li class="kkart-wizard-feature-item">
						<p class="kkart-wizard-feature-name">
							<strong><?php esc_html_e( 'Store stats', 'kkart' ); ?></strong>
						</p>
						<p class="kkart-wizard-feature-description">
							<?php esc_html_e( 'Get insights on how your store is doing, including total sales, top products, and more.', 'kkart' ); ?>
						</p>
					</li>
					<li class="kkart-wizard-feature-item">
						<p class="kkart-wizard-feature-name">
							<strong><?php esc_html_e( 'Store monitoring', 'kkart' ); ?></strong>
						</p>
						<p class="kkart-wizard-feature-description">
							<?php esc_html_e( 'Get an alert if your store is down for even a few minutes.', 'kkart' ); ?>
						</p>
					</li>
					<li class="kkart-wizard-feature-item">
						<p class="kkart-wizard-feature-name">
							<strong><?php esc_html_e( 'Product promotion', 'kkart' ); ?></strong>
						</p>
						<p class="kkart-wizard-feature-description">
							<?php esc_html_e( "Share new items on social media the moment they're live in your store.", 'kkart' ); ?>
						</p>
					</li>
				</ul>
			<?php endif; ?>
		<?php endif; ?>
	<?php
	}

	/**
	 *
	 * @deprecated 4.6.0
	 */
	protected function get_all_activate_errors() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		return array(
			'default' => __( "Sorry! We tried, but we couldn't connect Jetpack just now 😭. Please go to the Plugins tab to connect Jetpack, so that you can finish setting up your store.", 'kkart' ),
			'jetpack_cant_be_installed' => __( "Sorry! We tried, but we couldn't install Jetpack for you 😭. Please go to the Plugins tab to install it, and finish setting up your store.", 'kkart' ),
			'register_http_request_failed' => __( "Sorry! We couldn't contact Jetpack just now 😭. Please make sure that your site is visible over the internet, and that it accepts incoming and outgoing requests via curl. You can also try to connect to Jetpack again, and if you run into any more issues, please contact support.", 'kkart' ),
			'siteurl_private_ip_dev' => __( "Your site might be on a private network. Jetpack can only connect to public sites. Please make sure your site is visible over the internet, and then try connecting again 🙏." , 'kkart' ),
		);
	}

	/**
	 *
	 * @deprecated 4.6.0
	 */
	protected function get_activate_error_message( $code = '' ) {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		$errors = $this->get_all_activate_errors();
		return array_key_exists( $code, $errors ) ? $errors[ $code ] : $errors['default'];
	}

	/**
	 * Activate step save.
	 *
	 * Install, activate, and launch connection flow for Jetpack.
	 *
	 * @deprecated 4.6.0
	 */
	public function kkart_setup_activate_save() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
	}

	/**
	 * Final step.
	 *
	 * @deprecated 4.6.0
	 */
	public function kkart_setup_ready() {
		_deprecated_function( __CLASS__ . '::' . __FUNCTION__, '4.6.0', 'Onboarding is maintained in Kkart Admin.' );
		// We've made it! Don't prompt the user to run the wizard again.
		KKART_Admin_Notices::remove_notice( 'install', true );

		$user_email   = $this->get_current_user_email();
		$docs_url     = 'https://docs.kkart.com/documentation/plugins/kkart/getting-started/?utm_source=setupwizard&utm_medium=product&utm_content=docs&utm_campaign=kkartplugin';
		$help_text    = sprintf(
			/* translators: %1$s: link to docs */
			__( 'Visit Kkart.com to learn more about <a href="%1$s" target="_blank">getting started</a>.', 'kkart' ),
			$docs_url
		);
		?>
		<h1><?php esc_html_e( "You're ready to start selling!", 'kkart' ); ?></h1>

		<div class="kkart-message kkart-newsletter">
			<p><?php esc_html_e( "We're here for you — get tips, product updates, and inspiration straight to your mailbox.", 'kkart' ); ?></p>
			<form action="//kkart.us8.list-manage.com/subscribe/post?u=2c1434dc56f9506bf3c3ecd21&amp;id=13860df971&amp;SIGNUPPAGE=plugin" method="post" target="_blank" novalidate>
				<div class="newsletter-form-container">
					<input
						class="newsletter-form-email"
						type="email"
						value="<?php echo esc_attr( $user_email ); ?>"
						name="EMAIL"
						placeholder="<?php esc_attr_e( 'Email address', 'kkart' ); ?>"
						required
					>
					<p class="kkart-setup-actions step newsletter-form-button-container">
						<button
							type="submit"
							value="<?php esc_attr_e( 'Yes please!', 'kkart' ); ?>"
							name="subscribe"
							id="mc-embedded-subscribe"
							class="button-primary button newsletter-form-button"
						><?php esc_html_e( 'Yes please!', 'kkart' ); ?></button>
					</p>
				</div>
			</form>
		</div>

		<ul class="kkart-wizard-next-steps">
			<li class="kkart-wizard-next-step-item">
				<div class="kkart-wizard-next-step-description">
					<p class="next-step-heading"><?php esc_html_e( 'Next step', 'kkart' ); ?></p>
					<h3 class="next-step-description"><?php esc_html_e( 'Create some products', 'kkart' ); ?></h3>
					<p class="next-step-extra-info"><?php esc_html_e( "You're ready to add products to your store.", 'kkart' ); ?></p>
				</div>
				<div class="kkart-wizard-next-step-action">
					<p class="kkart-setup-actions step">
						<a class="button button-primary button-large" href="<?php echo esc_url( admin_url( 'post-new.php?post_type=product&tutorial=true' ) ); ?>">
							<?php esc_html_e( 'Create a product', 'kkart' ); ?>
						</a>
					</p>
				</div>
			</li>
			<li class="kkart-wizard-next-step-item">
				<div class="kkart-wizard-next-step-description">
					<p class="next-step-heading"><?php esc_html_e( 'Have an existing store?', 'kkart' ); ?></p>
					<h3 class="next-step-description"><?php esc_html_e( 'Import products', 'kkart' ); ?></h3>
					<p class="next-step-extra-info"><?php esc_html_e( 'Transfer existing products to your new store — just import a CSV file.', 'kkart' ); ?></p>
				</div>
				<div class="kkart-wizard-next-step-action">
					<p class="kkart-setup-actions step">
						<a class="button button-large" href="<?php echo esc_url( admin_url( 'edit.php?post_type=product&page=product_importer' ) ); ?>">
							<?php esc_html_e( 'Import products', 'kkart' ); ?>
						</a>
					</p>
				</div>
			</li>
			<li class="kkart-wizard-additional-steps">
				<div class="kkart-wizard-next-step-description">
					<p class="next-step-heading"><?php esc_html_e( 'You can also:', 'kkart' ); ?></p>
				</div>
				<div class="kkart-wizard-next-step-action">
					<p class="kkart-setup-actions step">
						<a class="button button-large" href="<?php echo esc_url( admin_url() ); ?>">
							<?php esc_html_e( 'Visit Dashboard', 'kkart' ); ?>
						</a>
						<a class="button button-large" href="<?php echo esc_url( admin_url( 'admin.php?page=kkart-settings' ) ); ?>">
							<?php esc_html_e( 'Review Settings', 'kkart' ); ?>
						</a>
						<a class="button button-large" href="<?php echo esc_url( add_query_arg( array( 'autofocus' => array( 'panel' => 'kkart' ), 'url' => kkart_get_page_permalink( 'shop' ) ), admin_url( 'customize.php' ) ) ); ?>">
							<?php esc_html_e( 'View &amp; Customize', 'kkart' ); ?>
						</a>
					</p>
				</div>
			</li>
		</ul>
		<p class="next-steps-help-text"><?php echo wp_kses_post( $help_text ); ?></p>
		<?php
	}
}

