<?php
/**
 * Add some content to the help tab
 *
 * @package     Kkart\Admin
 * @version     2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( class_exists( 'KKART_Admin_Help', false ) ) {
	return new KKART_Admin_Help();
}

/**
 * KKART_Admin_Help Class.
 */
class KKART_Admin_Help {

	/**
	 * Hook in tabs.
	 */
	public function __construct() {
		add_action( 'current_screen', array( $this, 'add_tabs' ), 50 );
	}

	/**
	 * Add help tabs.
	 */
	public function add_tabs() {
		$screen = get_current_screen();

		if ( ! $screen || ! in_array( $screen->id, kkart_get_screen_ids() ) ) {
			return;
		}

		$screen->add_help_tab(
			array(
				'id'      => 'kkart_support_tab',
				'title'   => __( 'Help &amp; Support', 'kkart' ),
				'content' =>
					'<h2>' . __( 'Help &amp; Support', 'kkart' ) . '</h2>' .
					'<p>' . sprintf(
						/* translators: %s: Documentation URL */
						__( 'Should you need help understanding, using, or extending Kkart, <a href="%s">please read our documentation</a>. You will find all kinds of resources including snippets, tutorials and much more.', 'kkart' ),
						'https://docs.kkart.com/documentation/plugins/kkart/?utm_source=helptab&utm_medium=product&utm_content=docs&utm_campaign=kkartplugin'
					) . '</p>' .
					'<p>' . sprintf(
						/* translators: %s: Forum URL */
						__( 'For further assistance with Kkart core, use the <a href="%1$s">community forum</a>. For help with premium extensions sold on Kkart.com, <a href="%2$s">open a support request at Kkart.com</a>.', 'kkart' ),
						'https://wordpress.org/support/plugin/kkart',
						'https://kkart.com/my-account/create-a-ticket/?utm_source=helptab&utm_medium=product&utm_content=tickets&utm_campaign=kkartplugin'
					) . '</p>' .
					'<p>' . __( 'Before asking for help, we recommend checking the system status page to identify any problems with your configuration.', 'kkart' ) . '</p>' .
					'<p><a href="' . admin_url( 'admin.php?page=kkart-status' ) . '" class="button button-primary">' . __( 'System status', 'kkart' ) . '</a> <a href="https://wordpress.org/support/plugin/kkart" class="button">' . __( 'Community forum', 'kkart' ) . '</a> <a href="https://kkart.com/my-account/create-a-ticket/?utm_source=helptab&utm_medium=product&utm_content=tickets&utm_campaign=kkartplugin" class="button">' . __( 'Kkart.com support', 'kkart' ) . '</a></p>',
			)
		);

		$screen->add_help_tab(
			array(
				'id'      => 'kkart_bugs_tab',
				'title'   => __( 'Found a bug?', 'kkart' ),
				'content' =>
					'<h2>' . __( 'Found a bug?', 'kkart' ) . '</h2>' .
					/* translators: 1: GitHub issues URL 2: GitHub contribution guide URL 3: System status report URL */
					'<p>' . sprintf( __( 'If you find a bug within Kkart core you can create a ticket via <a href="%1$s">Github issues</a>. Ensure you read the <a href="%2$s">contribution guide</a> prior to submitting your report. To help us solve your issue, please be as descriptive as possible and include your <a href="%3$s">system status report</a>.', 'kkart' ), 'https://github.com/kkart/kkart/issues?state=open', 'https://github.com/kkart/kkart/blob/master/.github/CONTRIBUTING.md', admin_url( 'admin.php?page=kkart-status' ) ) . '</p>' .
					'<p><a href="https://github.com/kkart/kkart/issues/new?template=4-Bug-report.md" class="button button-primary">' . __( 'Report a bug', 'kkart' ) . '</a> <a href="' . admin_url( 'admin.php?page=kkart-status' ) . '" class="button">' . __( 'System status', 'kkart' ) . '</a></p>',

			)
		);

		$screen->set_help_sidebar(
			'<p><strong>' . __( 'For more information:', 'kkart' ) . '</strong></p>' .
			'<p><a href="https://kkart.com/?utm_source=helptab&utm_medium=product&utm_content=about&utm_campaign=kkartplugin" target="_blank">' . __( 'About Kkart', 'kkart' ) . '</a></p>' .
			'<p><a href="https://wordpress.org/plugins/kkart/" target="_blank">' . __( 'WordPress.org project', 'kkart' ) . '</a></p>' .
			'<p><a href="https://github.com/kkart/kkart/" target="_blank">' . __( 'Github project', 'kkart' ) . '</a></p>' .
			'<p><a href="https://kkart.com/storefront/?utm_source=helptab&utm_medium=product&utm_content=wcthemes&utm_campaign=kkartplugin" target="_blank">' . __( 'Official theme', 'kkart' ) . '</a></p>' .
			'<p><a href="https://kkart.com/product-category/kkart-extensions/?utm_source=helptab&utm_medium=product&utm_content=wcextensions&utm_campaign=kkartplugin" target="_blank">' . __( 'Official extensions', 'kkart' ) . '</a></p>'
		);
	}
}

return new KKART_Admin_Help();
