/**
 * External dependencies
 */
import { getCategories, setCategories } from '@wordpress/blocks';
import { __ } from '@wordpress/i18n';
import { woo, atom, Icon } from '@kkart/icons';

/**
 * Internal dependencies
 */
import '../css/editor.scss';
import '../css/style.scss';
import './filters/block-list-block';
import './filters/get-block-attributes';

setCategories( [
	...getCategories().filter(
		( { slug } ) =>
			slug !== 'kkart' && slug !== 'kkart-product-elements'
	),
	{
		slug: 'kkart',
		title: __( 'Kkart', 'kkart' ),
		icon: <Icon srcElement={ woo } />,
	},
	{
		slug: 'kkart-product-elements',
		title: __(
			'Kkart Product Elements',
			'kkart'
		),
		icon: <Icon srcElement={ atom } style={ { fill: '#874FB9' } } />,
	},
] );
