/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import PropTypes from 'prop-types';
import { Icon, comment, external } from '@kkart/icons';

/**
 * Internal dependencies
 */
import './style.scss';

/**
 * Component to render a Feedback prompt in the sidebar.
 *
 * @param {Object} props Incoming props for the component.
 * @param {string} props.text
 * @param {string} props.url
 */
const FeedbackPrompt = ( {
	text,
	url = 'https://ideas.kkart.com/forums/133476-kkart?category_id=384565',
} ) => {
	return (
		<div className="kkart-block-feedback-prompt">
			<Icon srcElement={ comment } />
			<h2 className="kkart-block-feedback-prompt__title">
				{ __( 'Feedback?', 'kkart' ) }
			</h2>
			<p className="kkart-block-feedback-prompt__text">{ text }</p>
			<a
				href={ url }
				className="kkart-block-feedback-prompt__link"
				rel="noreferrer noopener"
				target="_blank"
			>
				{ __(
					'Give us your feedback.',
					'kkart'
				) }
				<Icon srcElement={ external } size={ 16 } />
			</a>
		</div>
	);
};

FeedbackPrompt.propTypes = {
	text: PropTypes.string,
	url: PropTypes.string,
};

export default FeedbackPrompt;

export const CartCheckoutFeedbackPrompt = () => (
	<FeedbackPrompt
		text={ __(
			'We are currently working on improving our cart and checkout blocks to provide merchants with the tools and customization options they need.',
			'kkart'
		) }
		url="https://github.com/kkart/kkart-gutenberg-products-block/issues/new?template=--cart-checkout-feedback.md"
	/>
);
