/**
 * External dependencies
 */
import { renderFrontend } from '@kkart/base-utils';

/**
 * Internal dependencies
 */
import FrontendContainerBlock from './frontend-container-block.js';

const selector = `
	.wp-block-kkart-all-reviews,
	.wp-block-kkart-reviews-by-product,
	.wp-block-kkart-reviews-by-category
`;

const getProps = ( el ) => {
	return {
		attributes: {
			showReviewDate: el.classList.contains( 'has-date' ),
			showReviewerName: el.classList.contains( 'has-name' ),
			showReviewImage: el.classList.contains( 'has-image' ),
			showReviewRating: el.classList.contains( 'has-rating' ),
			showReviewContent: el.classList.contains( 'has-content' ),
			showProductName: el.classList.contains( 'has-product-name' ),
		},
	};
};

renderFrontend( { selector, Block: FrontendContainerBlock, getProps } );
