/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { Button, Placeholder } from '@wordpress/components';
import classNames from 'classnames';
import { ADMIN_URL } from '@kkart/settings';
import { Icon, external } from '@kkart/icons';

export const getBlockClassName = ( blockClassName, attributes ) => {
	const { className, contentVisibility } = attributes;

	return classNames( blockClassName, className, {
		'has-image': contentVisibility && contentVisibility.image,
		'has-title': contentVisibility && contentVisibility.title,
		'has-rating': contentVisibility && contentVisibility.rating,
		'has-price': contentVisibility && contentVisibility.price,
		'has-button': contentVisibility && contentVisibility.button,
	} );
};

export const renderNoProductsPlaceholder = ( blockTitle, blockIcon ) => (
	<Placeholder
		className="kkart-block-products"
		icon={ blockIcon }
		label={ blockTitle }
	>
		<p>
			{ __(
				"You haven't published any products to list here yet.",
				'kkart'
			) }
		</p>
		<Button
			className="kkart-block-products__add-product-button"
			isDefault
			isLarge
			href={ ADMIN_URL + 'post-new.php?post_type=product' }
		>
			{ __( 'Add new product', 'kkart' ) + ' ' }
			<Icon srcElement={ external } />
		</Button>
		<Button
			className="kkart-block-products__read_more_button"
			isTertiary
			href="https://docs.kkart.com/document/managing-products/"
		>
			{ __( 'Learn more', 'kkart' ) }
		</Button>
	</Placeholder>
);

export const renderHiddenContentPlaceholder = ( blockTitle, blockIcon ) => (
	<Placeholder
		className="kkart-block-products"
		icon={ blockIcon }
		label={ blockTitle }
	>
		{ __(
			'The content for this block is hidden due to block settings.',
			'kkart'
		) }
	</Placeholder>
);
