/**
 * External dependencies
 */
import { withRestApiHydration } from '@kkart/block-hocs';
import { renderFrontend } from '@kkart/base-utils';

/**
 * Internal dependencies
 */
import Block from './block.js';

const getProps = ( el ) => {
	return {
		attributes: {
			showInputFields: el.dataset.showinputfields === 'true',
			showFilterButton: el.dataset.showfilterbutton === 'true',
		},
	};
};

renderFrontend( {
	selector: '.wp-block-kkart-price-filter',
	Block: withRestApiHydration( Block ),
	getProps,
} );
