/**
 * External dependencies
 */
import { withInstanceId } from '@kkart/base-hocs/with-instance-id';
import classnames from 'classnames';
import { __ } from '@wordpress/i18n';
import { useTabState, Tab, TabList, TabPanel } from 'reakit/Tab';
/**
 * Internal dependencies
 */
import './style.scss';

const Tabs = ( {
	className,
	onSelect = () => null,
	tabs,
	activeClass = 'is-active',
	initialTabName,
	ariaLabel = __( 'Tabbed Content', 'kkart' ),
	instanceId,
	id,
} ) => {
	const initialTab = initialTabName
		? { selectedId: `${ instanceId }-${ initialTabName }` }
		: undefined;
	const tabState = useTabState( initialTab );
	if ( tabs.length === 0 ) {
		return null;
	}
	return (
		<div className={ classnames( 'kkart-block-components-tabs', className ) }>
			<TabList
				{ ...tabState }
				id={ id }
				className={ 'kkart-block-components-tabs__list' }
				aria-label={ ariaLabel }
			>
				{ tabs.map( ( { name, title, ariaLabel: tabAriaLabel } ) => (
					<Tab
						{ ...tabState }
						id={ `${ instanceId }-${ name }` }
						manual={ true }
						className={ classnames(
							'kkart-block-components-tabs__item',
							{
								[ activeClass ]:
									// reakit uses the ID as the selectedId
									`${ instanceId }-${ name }` ===
									tabState.selectedId,
							}
						) }
						onClick={ () => onSelect( name ) }
						type="button"
						key={ name }
						aria-label={ tabAriaLabel }
					>
						<span className="kkart-block-components-tabs__item-content">
							{ title }
						</span>
					</Tab>
				) ) }
			</TabList>

			{ tabs.map( ( { name, content } ) => (
				<TabPanel
					{ ...tabState }
					key={ name }
					id={ `${ instanceId }-${ name }-view` }
					tabId={ `${ instanceId }-${ name }` }
					className="kkart-block-components-tabs__content"
				>
					{ tabState.selectedId === `${ instanceId }-${ name }` &&
						content }
				</TabPanel>
			) ) }
		</div>
	);
};

export default withInstanceId( Tabs );
