/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { Placeholder, Button, Notice } from 'wordpress-components';
import { Icon, card } from '@kkart/icons';
import { ADMIN_URL } from '@kkart/settings';
import { useEditorContext } from '@kkart/base-context';
import classnames from 'classnames';

/**
 * Internal dependencies
 */
import './style.scss';

/**
 * Render content when no payment methods are found depending on context.
 */
const NoPaymentMethods = () => {
	const { isEditor } = useEditorContext();

	return isEditor ? (
		<NoPaymentMethodsPlaceholder />
	) : (
		<NoPaymentMethodsNotice />
	);
};

/**
 * Renders a placeholder in the editor.
 */
const NoPaymentMethodsPlaceholder = () => {
	return (
		<Placeholder
			icon={ <Icon srcElement={ card } /> }
			label={ __( 'Payment methods', 'kkart' ) }
			className="kkart-block-checkout__no-payment-methods-placeholder"
		>
			<span className="kkart-block-checkout__no-payment-methods-placeholder-description">
				{ __(
					'Your store does not have any payment methods configured that support the checkout block. Once you have configured a compatible payment method (e.g. Stripe) it will be shown here.',
					'kkart'
				) }
			</span>
			<Button
				isDefault
				href={ `${ ADMIN_URL }admin.php?page=kkart-settings&tab=checkout` }
				target="_blank"
				rel="noopener noreferrer"
			>
				{ __(
					'Configure Payment Methods',
					'kkart'
				) }
			</Button>
		</Placeholder>
	);
};

/**
 * Renders a notice on the frontend.
 */
const NoPaymentMethodsNotice = () => {
	return (
		<Notice
			isDismissible={ false }
			className={ classnames(
				'kkart-block-checkout__no-payment-methods-notice',
				'kkart-message',
				'kkart-error'
			) }
		>
			{ __(
				'There are no payment methods available. This may be an error on our side. Please contact us if you need any help placing your order.',
				'kkart'
			) }
		</Notice>
	);
};

export default NoPaymentMethods;
