/**
 * External dependencies
 */
import { KKART_BLOCKS_ASSET_URL } from '@kkart/block-settings';

/**
 * Array of common assets.
 */
export const commonIcons = [
	{
		id: 'alipay',
		alt: 'Alipay',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/alipay.svg',
	},
	{
		id: 'amex',
		alt: 'American Express',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/amex.svg',
	},
	{
		id: 'bancontact',
		alt: 'Bancontact',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/bancontact.svg',
	},
	{
		id: 'diners',
		alt: 'Diners Club',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/diners.svg',
	},
	{
		id: 'discover',
		alt: 'Discover',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/discover.svg',
	},
	{
		id: 'eps',
		alt: 'EPS',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/eps.svg',
	},
	{
		id: 'giropay',
		alt: 'Giropay',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/giropay.svg',
	},
	{
		id: 'ideal',
		alt: 'iDeal',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/ideal.svg',
	},
	{
		id: 'jcb',
		alt: 'JCB',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/jcb.svg',
	},
	{
		id: 'laser',
		alt: 'Laser',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/laser.svg',
	},
	{
		id: 'maestro',
		alt: 'Maestro',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/maestro.svg',
	},
	{
		id: 'mastercard',
		alt: 'Mastercard',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/mastercard.svg',
	},
	{
		id: 'multibanco',
		alt: 'Multibanco',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/multibanco.svg',
	},
	{
		id: 'p24',
		alt: 'Przelewy24',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/p24.svg',
	},
	{
		id: 'sepa',
		alt: 'Sepa',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/sepa.svg',
	},
	{
		id: 'sofort',
		alt: 'Sofort',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/sofort.svg',
	},
	{
		id: 'unionpay',
		alt: 'Union Pay',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/unionpay.svg',
	},
	{
		id: 'visa',
		alt: 'Visa',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/visa.svg',
	},
	{
		id: 'wechat',
		alt: 'WeChat',
		src: KKART_BLOCKS_ASSET_URL + 'img/payment-methods/wechat.svg',
	},
];

/**
 * For a given ID, see if a common icon exists and return it's props.
 *
 * @param {string} id Icon ID.
 */
export const getCommonIconProps = ( id ) => {
	return (
		commonIcons.find( ( icon ) => {
			return icon.id === id;
		} ) || {}
	);
};
