<?php
/**
 * Define deprecated classes to support changing the naming convention of
 * admin notes.
 */

namespace Automattic\Kkart\Admin\Notes;

defined( 'ABSPATH' ) || exit;

use Automattic\Kkart\Admin\DeprecatedClassFacade;

// phpcs:disable Generic.Files.OneObjectStructurePerFile.MultipleFound

/**
 * KKART_Admin_Note.
 *
 * @deprecated since 1.7.0, use Note
 */
class KKART_Admin_Note extends DeprecatedClassFacade {
	// These constants must be redeclared as to not break plugins that use them.
	const E_KKART_ADMIN_NOTE_ERROR         = Note::E_KKART_ADMIN_NOTE_ERROR;
	const E_KKART_ADMIN_NOTE_WARNING       = Note::E_KKART_ADMIN_NOTE_WARNING;
	const E_KKART_ADMIN_NOTE_UPDATE        = Note::E_KKART_ADMIN_NOTE_UPDATE;
	const E_KKART_ADMIN_NOTE_INFORMATIONAL = Note::E_KKART_ADMIN_NOTE_INFORMATIONAL;
	const E_KKART_ADMIN_NOTE_MARKETING     = Note::E_KKART_ADMIN_NOTE_MARKETING;
	const E_KKART_ADMIN_NOTE_SURVEY        = Note::E_KKART_ADMIN_NOTE_SURVEY;
	const E_KKART_ADMIN_NOTE_PENDING       = Note::E_KKART_ADMIN_NOTE_PENDING;
	const E_KKART_ADMIN_NOTE_UNACTIONED    = Note::E_KKART_ADMIN_NOTE_UNACTIONED;
	const E_KKART_ADMIN_NOTE_ACTIONED      = Note::E_KKART_ADMIN_NOTE_ACTIONED;
	const E_KKART_ADMIN_NOTE_SNOOZED       = Note::E_KKART_ADMIN_NOTE_SNOOZED;

	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\Note';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';

	/**
	 * Note constructor. Loads note data.
	 *
	 * @param mixed $data Note data, object, or ID.
	 */
	public function __construct( $data = '' ) {
		$this->instance = new static::$facade_over_classname( $data );
	}
}

/**
 * KKART_Admin_Notes.
 *
 * @deprecated since 1.7.0, use Notes
 */
class KKART_Admin_Notes extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\Notes';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Choose_Niche.
 *
 * @deprecated since 1.7.0, use ChooseNiche
 */
class KKART_Admin_Notes_Choose_Niche extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\ChooseNiche';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Coupon_Page_Moved.
 *
 * @deprecated since 1.7.0, use CouponPageMoved
 */
class KKART_Admin_Notes_Coupon_Page_Moved extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\CouponPageMoved';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Customize_Store_With_Blocks.
 *
 * @deprecated since 1.7.0, use CustomizeStoreWithBlocks
 */
class KKART_Admin_Notes_Customize_Store_With_Blocks extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\CustomizeStoreWithBlocks';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Deactivate_Plugin.
 *
 * @deprecated since 1.7.0, use DeactivatePlugin
 */
class KKART_Admin_Notes_Deactivate_Plugin extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\DeactivatePlugin';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Draw_Attention.
 *
 * @deprecated since 1.7.0, use DrawAttention
 */
class KKART_Admin_Notes_Draw_Attention extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\DrawAttention';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Edit_Products_On_The_Move.
 *
 * @deprecated since 1.7.0, use EditProductsOnTheMove
 */
class KKART_Admin_Notes_Edit_Products_On_The_Move extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\EditProductsOnTheMove';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_EU_VAT_Number.
 *
 * @deprecated since 1.7.0, use EUVATNumber
 */
class KKART_Admin_Notes_EU_VAT_Number extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\EUVATNumber';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Facebook_Marketing_Expert.
 *
 * @deprecated since 1.7.0, use FacebookMarketingExpert
 */
class KKART_Admin_Notes_Facebook_Marketing_Expert extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\FacebookMarketingExpert';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_First_Product.
 *
 * @deprecated since 1.7.0, use FirstProduct
 */
class KKART_Admin_Notes_First_Product extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\FirstProduct';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Giving_Feedback_Notes.
 *
 * @deprecated since 1.7.0, use GivingFeedbackNotes
 */
class KKART_Admin_Notes_Giving_Feedback_Notes extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\GivingFeedbackNotes';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Historical_Data.
 *
 * @deprecated since 1.7.0, use HistoricalData
 */
class KKART_Admin_Notes_Historical_Data extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\HistoricalData';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Home_Screen_Feedback.
 *
 * @deprecated since 1.7.0, use HomeScreenFeedback
 */
class KKART_Admin_Notes_Home_Screen_Feedback extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\HomeScreenFeedback';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Insight_First_Sale.
 *
 * @deprecated since 1.7.0, use InsightFirstSale
 */
class KKART_Admin_Notes_Insight_First_Sale extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\InsightFirstSale';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Install_JP_And_KKARTS_Plugins.
 *
 * @deprecated since 1.7.0, use InstallJPAndKKARTSPlugins
 */
class KKART_Admin_Notes_Install_JP_And_KKARTS_Plugins extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\InstallJPAndKKARTSPlugins';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Launch_Checklist.
 *
 * @deprecated since 1.7.0, use LaunchChecklist
 */
class KKART_Admin_Notes_Launch_Checklist extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\LaunchChecklist';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Marketing.
 *
 * @deprecated since 1.7.0, use Marketing
 */
class KKART_Admin_Notes_Marketing extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\Marketing';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Migrate_From_Shopify.
 *
 * @deprecated since 1.7.0, use MigrateFromShopify
 */
class KKART_Admin_Notes_Migrate_From_Shopify extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\MigrateFromShopify';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Mobile_App.
 *
 * @deprecated since 1.7.0, use MobileApp
 */
class KKART_Admin_Notes_Mobile_App extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\MobileApp';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Need_Some_Inspiration.
 *
 * @deprecated since 1.7.0, use NeedSomeInspiration
 */
class KKART_Admin_Notes_Need_Some_Inspiration extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\NeedSomeInspiration';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_New_Sales_Record.
 *
 * @deprecated since 1.7.0, use NewSalesRecord
 */
class KKART_Admin_Notes_New_Sales_Record extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\NewSalesRecord';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Onboarding_Email_Marketing.
 *
 * @deprecated since 1.7.0, use OnboardingEmailMarketing
 */
class KKART_Admin_Notes_Onboarding_Email_Marketing extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\OnboardingEmailMarketing';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Onboarding_Payments.
 *
 * @deprecated since 1.7.0, use OnboardingPayments
 */
class KKART_Admin_Notes_Onboarding_Payments extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\OnboardingPayments';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Online_Clothing_Store.
 *
 * @deprecated since 1.7.0, use OnlineClothingStore
 */
class KKART_Admin_Notes_Online_Clothing_Store extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\OnlineClothingStore';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Order_Milestones.
 *
 * @deprecated since 1.7.0, use OrderMilestones
 */
class KKART_Admin_Notes_Order_Milestones extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\OrderMilestones';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Performance_On_Mobile.
 *
 * @deprecated since 1.7.0, use PerformanceOnMobile
 */
class KKART_Admin_Notes_Performance_On_Mobile extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\PerformanceOnMobile';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Personalize_Store.
 *
 * @deprecated since 1.7.0, use PersonalizeStore
 */
class KKART_Admin_Notes_Personalize_Store extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\PersonalizeStore';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Real_Time_Order_Alerts.
 *
 * @deprecated since 1.7.0, use RealTimeOrderAlerts
 */
class KKART_Admin_Notes_Real_Time_Order_Alerts extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\RealTimeOrderAlerts';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Review_Shipping_Settings.
 *
 * @deprecated since 1.7.0, use ReviewShippingSettings
 */
class KKART_Admin_Notes_Review_Shipping_Settings extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\ReviewShippingSettings';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Selling_Online_Courses.
 *
 * @deprecated since 1.7.0, use SellingOnlineCourses
 */
class KKART_Admin_Notes_Selling_Online_Courses extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\SellingOnlineCourses';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Set_Up_Additional_Payment_Types.
 *
 * @deprecated since 1.7.0, use SetUpAdditionalPaymentTypes
 */
class KKART_Admin_Notes_Set_Up_Additional_Payment_Types extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\SetUpAdditionalPaymentTypes';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Start_Dropshipping_Business.
 *
 * @deprecated since 1.7.0, use StartDropshippingBusiness
 */
class KKART_Admin_Notes_Start_Dropshipping_Business extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\StartDropshippingBusiness';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Test_Checkout.
 *
 * @deprecated since 1.7.0, use TestCheckout
 */
class KKART_Admin_Notes_Test_Checkout extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\TestCheckout';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Tracking_Opt_In.
 *
 * @deprecated since 1.7.0, use TrackingOptIn
 */
class KKART_Admin_Notes_Tracking_Opt_In extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\TrackingOptIn';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Woo_Subscriptions_Notes.
 *
 * @deprecated since 1.7.0, use WooSubscriptionsNotes
 */
class KKART_Admin_Notes_Woo_Subscriptions_Notes extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\WooSubscriptionsNotes';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Kkart_Payments.
 *
 * @deprecated since 1.7.0, use KkartPayments
 */
class KKART_Admin_Notes_Kkart_Payments extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\KkartPayments';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}

/**
 * KKART_Admin_Notes_Kkart_Subscriptions.
 *
 * @deprecated since 1.7.0, use KkartSubscriptions
 */
class KKART_Admin_Notes_Kkart_Subscriptions extends DeprecatedClassFacade {
	/**
	 * The name of the non-deprecated class that this facade covers.
	 *
	 * @var string
	 */
	protected static $facade_over_classname = 'Automattic\Kkart\Admin\Notes\KkartSubscriptions';

	/**
	 * The version that this class was deprecated in.
	 *
	 * @var string
	 */
	protected static $deprecated_in_version = '1.7.0';
}
