<?php
/**
 * Kkart Analytics.
 * NOTE: DO NOT edit this file in Kkart core, this is generated from kkart-admin.
 */

namespace Automattic\Kkart\Admin\Features;

use Automattic\Kkart\Admin\Loader;
use Automattic\Kkart\Admin\API\Reports\Cache;

/**
 * Contains backend logic for the Analytics feature.
 */
class Analytics {
	/**
	 * Clear cache tool identifier.
	 */
	const CACHE_TOOL_ID = 'clear_kkart_analytics_cache';

	/**
	 * Class instance.
	 *
	 * @var Analytics instance
	 */
	protected static $instance = null;

	/**
	 * Get class instance.
	 */
	public static function get_instance() {
		if ( ! self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Hook into Kkart.
	 */
	public function __construct() {
		add_filter( 'kkart_component_settings_preload_endpoints', array( $this, 'add_preload_endpoints' ) );
		add_filter( 'kkart_admin_get_user_data_fields', array( $this, 'add_user_data_fields' ) );
		add_action( 'admin_menu', array( $this, 'register_pages' ) );
		add_filter( 'kkart_debug_tools', array( $this, 'register_cache_clear_tool' ) );
	}

	/**
	 * Preload data from the countries endpoint.
	 *
	 * @param array $endpoints Array of preloaded endpoints.
	 * @return array
	 */
	public function add_preload_endpoints( $endpoints ) {
		$endpoints['countries'] = '/kkart-analytics/data/countries';
		return $endpoints;
	}

	/**
	 * Adds fields so that we can store user preferences for the columns to display on a report.
	 *
	 * @param array $user_data_fields User data fields.
	 * @return array
	 */
	public function add_user_data_fields( $user_data_fields ) {
		return array_merge(
			$user_data_fields,
			array(
				'categories_report_columns',
				'coupons_report_columns',
				'customers_report_columns',
				'orders_report_columns',
				'products_report_columns',
				'revenue_report_columns',
				'taxes_report_columns',
				'variations_report_columns',
			)
		);
	}

	/**
	 * Register the cache clearing tool on the Kkart > Status > Tools page.
	 *
	 * @param array $debug_tools Available debug tool registrations.
	 * @return array Filtered debug tool registrations.
	 */
	public function register_cache_clear_tool( $debug_tools ) {
		$settings_url = add_query_arg(
			array(
				'page' => 'kkart-admin',
				'path' => '/analytics/settings',
			),
			get_admin_url( null, 'admin.php' )
		);

		$debug_tools[ self::CACHE_TOOL_ID ] = array(
			'name'     => __( 'Clear analytics cache', 'kkart' ),
			'button'   => __( 'Clear', 'kkart' ),
			'desc'     => sprintf(
				/* translators: 1: opening link tag, 2: closing tag */
				__( 'This tool will reset the cached values used in Kkart Analytics. If numbers still look off, try %1$sReimporting Historical Data%2$s.', 'kkart' ),
				'<a href="' . esc_url( $settings_url ) . '">',
				'</a>'
			),
			'callback' => array( $this, 'run_clear_cache_tool' ),
		);

		return $debug_tools;
	}

	/**
	 * Registers report pages.
	 */
	public function register_pages() {
		$report_pages = self::get_report_pages();
		foreach ( $report_pages as $report_page ) {
			if ( ! is_null( $report_page ) ) {
				kkart_admin_register_page( $report_page );
			}
		}
	}

	/**
	 * Get report pages.
	 */
	public static function get_report_pages() {
		$overview_page = array(
			'id'       => 'kkart-analytics',
			'title'    => __( 'Analytics', 'kkart' ),
			'path'     => '/analytics/overview',
			'icon'     => 'dashicons-chart-bar',
			'position' => 56, // After Kkart & Product menu items.
		);

		$report_pages = array(
			$overview_page,
			array(
				'id'       => 'kkart-analytics-overview',
				'title'    => __( 'Overview', 'kkart' ),
				'parent'   => 'kkart-analytics',
				'path'     => '/analytics/overview',
				'nav_args' => array(
					'order'  => 10,
					'parent' => 'analytics',
				),
			),
			array(
				'id'       => 'kkart-analytics-products',
				'title'    => __( 'Products', 'kkart' ),
				'parent'   => 'kkart-analytics',
				'path'     => '/analytics/products',
				'nav_args' => array(
					'order'  => 20,
					'parent' => 'analytics',
				),
			),
			array(
				'id'       => 'kkart-analytics-revenue',
				'title'    => __( 'Revenue', 'kkart' ),
				'parent'   => 'kkart-analytics',
				'path'     => '/analytics/revenue',
				'nav_args' => array(
					'order'  => 30,
					'parent' => 'analytics',
				),
			),
			array(
				'id'       => 'kkart-analytics-orders',
				'title'    => __( 'Orders', 'kkart' ),
				'parent'   => 'kkart-analytics',
				'path'     => '/analytics/orders',
				'nav_args' => array(
					'order'  => 40,
					'parent' => 'analytics',
				),
			),
			array(
				'id'       => 'kkart-analytics-variations',
				'title'    => __( 'Variations', 'kkart' ),
				'parent'   => 'kkart-analytics',
				'path'     => '/analytics/variations',
				'nav_args' => array(
					'order'  => 50,
					'parent' => 'analytics',
				),
			),
			array(
				'id'       => 'kkart-analytics-categories',
				'title'    => __( 'Categories', 'kkart' ),
				'parent'   => 'kkart-analytics',
				'path'     => '/analytics/categories',
				'nav_args' => array(
					'order'  => 60,
					'parent' => 'analytics',
				),
			),
			array(
				'id'       => 'kkart-analytics-coupons',
				'title'    => __( 'Coupons', 'kkart' ),
				'parent'   => 'kkart-analytics',
				'path'     => '/analytics/coupons',
				'nav_args' => array(
					'order'  => 70,
					'parent' => 'analytics',
				),
			),
			array(
				'id'       => 'kkart-analytics-taxes',
				'title'    => __( 'Taxes', 'kkart' ),
				'parent'   => 'kkart-analytics',
				'path'     => '/analytics/taxes',
				'nav_args' => array(
					'order'  => 80,
					'parent' => 'analytics',
				),
			),
			array(
				'id'       => 'kkart-analytics-downloads',
				'title'    => __( 'Downloads', 'kkart' ),
				'parent'   => 'kkart-analytics',
				'path'     => '/analytics/downloads',
				'nav_args' => array(
					'order'  => 90,
					'parent' => 'analytics',
				),
			),
			'yes' === get_option( 'kkart_manage_stock' ) ? array(
				'id'       => 'kkart-analytics-stock',
				'title'    => __( 'Stock', 'kkart' ),
				'parent'   => 'kkart-analytics',
				'path'     => '/analytics/stock',
				'nav_args' => array(
					'order'  => 100,
					'parent' => 'analytics',
				),
			) : null,
			array(
				'id'       => 'kkart-analytics-customers',
				'title'    => __( 'Customers', 'kkart' ),
				'parent'   => 'kkart',
				'path'     => '/customers',
				'nav_args' => array(
					'is_top_level' => true,
					'order'        => 50,
				),
			),
			array(
				'id'       => 'kkart-analytics-settings',
				'title'    => __( 'Settings', 'kkart' ),
				'parent'   => 'kkart-analytics',
				'path'     => '/analytics/settings',
				'nav_args' => array(
					'title'  => __( 'Analytics', 'kkart' ),
					'parent' => 'settings',
				),
			),
		);

		return apply_filters( 'kkart_analytics_report_menu_items', $report_pages );
	}

	/**
	 * "Clear" analytics cache by invalidating it.
	 */
	public function run_clear_cache_tool() {
		Cache::invalidate();

		return __( 'Analytics cache cleared.', 'kkart' );
	}
}
