<?php
/**
 * Convenience functions for PageController.
 *
 * @package Kkart\Admin
 */

use Automattic\Kkart\Admin\PageController;

/**
 * Connect an existing page to Kkart Admin.
 * Passthrough to PageController::connect_page().
 *
 * @param array $options Options for PageController::connect_page().
 */
function kkart_admin_connect_page( $options ) {
	$controller = PageController::get_instance();
	$controller->connect_page( $options );
}

/**
 * Register JS-powered Kkart Admin Page.
 * Passthrough to PageController::register_page().
 *
 * @param array $options Options for PageController::register_page().
 */
function kkart_admin_register_page( $options ) {
	$controller = PageController::get_instance();
	$controller->register_page( $options );
}

/**
 * Is this page connected to Kkart Admin?
 * Passthrough to PageController::is_connected_page().
 *
 * @return boolean True if the page is connected to Kkart Admin.
 */
function kkart_admin_is_connected_page() {
	$controller = PageController::get_instance();
	return $controller->is_connected_page();
}

/**
 * Is this a Kkart Admin Page?
 * Passthrough to PageController::is_registered_page().
 *
 * @return boolean True if the page is a Kkart Admin page.
 */
function kkart_admin_is_registered_page() {
	$controller = PageController::get_instance();
	return $controller->is_registered_page();
}

/**
 * Get breadcrumbs for Kkart Admin Page navigation.
 * Passthrough to PageController::get_breadcrumbs().
 *
 * @return array Navigation pieces (breadcrumbs).
 */
function kkart_admin_get_breadcrumbs() {
	$controller = PageController::get_instance();
	return $controller->get_breadcrumbs();
}
