<?php
/**
 * Helpers for managing connection to Kkart.com.
 */

namespace Automattic\Kkart\Internal\KKARTCom;

defined( 'ABSPATH' ) || exit;

/**
 * Class KKARTConnectionHelper.
 *
 * Helpers for managing connection to Kkart.com.
 */
final class ConnectionHelper {
	/**
	 * Check if Kkart.com account is connected.
	 *
	 * @since 4.4.0
	 * @return bool Whether account is connected.
	 */
	public static function is_connected() {
		$helper_options    = get_option( 'kkart_helper_data', array() );
		if ( array_key_exists( 'auth', $helper_options ) && ! empty( $helper_options['auth'] ) ) {
			return true;
		}
		return false;
	}
}
