<?php
/**
 * @package    Joomla.Language
 * @copyright  (C) 2005 - 2024 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use \Joomla\String\StringHelper;

/**
 * bg-BG localise class
 *
 * @since 1.6
 */
abstract class Bg_BGLocalise
{
    /**
     * Returns the potential suffixes for a specific number of items
     *
     * @param   integer  $count  The number of items
     *
     * @return  array  An array of potential suffixes
     *
     * @since   1.6
     */
    public static function getPluralSuffixes($count)
    {
        if ($count == 0) {
            return ['0'];
        } elseif ($count == 1) {
            return ['ONE', '1'];
        }

        return ['OTHER', 'MORE'];
    }

    /**
     * Transliterates Cyrillic to Latin characters
     *
     * @param   string  $string  The string to transliterate
     *
     * @return  string  The transliterated string
     *
     * @since   5.x
     */
    public static function transliterate($string)
    {
        $str = StringHelper::strtolower($string);

        $glyph_array = [
            'a' => 'а',
            'b' => 'б',
            'v' => 'в',
            'g' => 'г',
            'd' => 'д',
            'e' => 'е',
            'zh' => 'ж',
            'z' => 'з',
            'i' => 'и',
            'y' => 'й',
            'k' => 'к',
            'l' => 'л',
            'm' => 'м',
            'n' => 'н',
            'o' => 'о',
            'p' => 'п',
            'r' => 'р',
            's' => 'с',
            't' => 'т',
            'u' => 'у',
            'f' => 'ф',
            'h' => 'х',
            'ts' => 'ц',
            'ch' => 'ч',
            'sh' => 'ш',
            'sht' => 'щ',
            'a' => 'ъ',
            '' => 'ь',
            'yu' => 'ю',
            'ya' => 'я',
        ];

        foreach ($glyph_array as $latin => $cyrillics)
        {
            $glyphs = explode(',', $cyrillics);
            $str = StringHelper::str_ireplace($glyphs, $latin, $str);
        }

        $str = preg_replace('#\&\#?[a-z0-9]+\;#ismu', '', $str);

        return $str;
    }
}
