<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: unsubscribe
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_unsubscribe($_post, $_user, $_conf)
{
    $url = jrCore_get_base_url();
    $_ln = jrUser_load_lang_strings();

    // Are we getting JUST an email address to unsubscribe?
    if (!isset($_post['_1'])) {
        jrCore_notice_page('error', 'Invalid unique email ID<br><br>Please make sure you are entering the full URL from the unsubscribe link', $url, $_ln['jrUser'][113], false);
    }
    elseif (!jrCore_checktype($_post['_1'], 'email') && !jrCore_checktype($_post['_1'], 'md5')) {
        jrCore_notice_page('error', 'Invalid unique email ID<br><br>Please make sure you are entering the full URL from the unsubscribe link (2)', $url, $_ln['jrUser'][113], false);
    }

    $_rt = false;
    if (jrCore_checktype($_post['_1'], 'email')) {

        if (!isset($_post['_2']) || !jrCore_checktype($_post['_2'], 'md5')) {
            jrCore_notice_page('error', 'Invalid unique email hash<br><br>Please make sure you are entering the full URL from the unsubscribe link', $url, $_ln['jrUser'][113], false);
        }
        // Check incoming hash
        if ($_post['_2'] != md5($_conf['jrCore_unique_string'] . $_post['_1'])) {
            jrCore_notice_page('error', 'Invalid unique email hash<br><br>Please make sure you are entering the full URL from the unsubscribe link (2)', $url, $_ln['jrUser'][113], false);
        }
        // This unsubscribe request has come in for an email - let's see if there is account
        $_rt = jrCore_db_get_item_by_key('jrUser', 'user_email', $_post['_1'], true);
        if (!$_rt || !is_array($_rt)) {
            // No account - block sending to this email address any longer
            jrUser_suppress_email_address($_post['_1']);
            jrCore_notice_page('success', $_ln['jrUser'][121], $url, $_ln['jrUser'][113]);
        }
    }

    // Fall through - this user has an ACCOUNT on the system
    if (jrUser_is_logged_in()) {
        // User is logged in - redirect to notifications tab
        $pid = jrUser_get_profile_home_key('_profile_id');
        jrCore_location("{$url}/{$_post['module_url']}/notifications/profile_id={$pid}/user_id={$_user['_user_id']}");
    }

    // @note $_rt will be false if $_post._1 == user_validate (MD5)
    if (!$_rt) {
        $_rt = jrCore_db_get_item_by_key('jrUser', 'user_validate', $_post['_1'], true);
    }
    if (!$_rt || !is_array($_rt)) {
        jrCore_notice_page('error', 'Invalid unique subscriber ID<br><br>Please make sure you are entering the full URL from the unsubscribe link', $url, $_ln['jrUser'][113], false);
    }

    // Is this user already unsubscribed?
    if (!empty($_rt['user_notifications_disabled']) && $_rt['user_notifications_disabled'] == 'on') {
        // Yes - let them know
        jrCore_notice_page('success', $_ln['jrUser'][95], jrCore_get_base_url(), $_ln['jrCore'][87]);
    }

    jrCore_page_banner(118, $_rt['user_email']);
    jrCore_set_form_notice('notice', $_ln['jrUser'][121]);
    jrCore_get_form_notice();

    // Form init
    $_tmp = array(
        'submit_value'     => $_ln['jrUser'][118],
        'form_ajax_submit' => false,
        'cancel'           => jrCore_get_base_url()
    );
    jrCore_form_create($_tmp);

    $_tmp = array(
        'name'     => 'block_notifications',
        'label'    => 119,
        'help'     => 120,
        'type'     => 'checkbox',
        'value'    => 'on',
        'validate' => 'onoff',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'  => 'user_validate',
        'type'  => 'hidden',
        'value' => $_post['_1']
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
