<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: password_create_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_password_create_save($_post, $_user, $_conf)
{
    jrUser_admin_only();
    jrCore_validate_location_url();
    if (!isset($_post['user_id']) || !jrCore_checktype($_post['user_id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid user_id');
        jrCore_location('referrer');
    }
    $uid = (int) $_post['user_id'];
    if (!$_usr = jrCore_db_get_item('jrUser', $uid, true)) {
        jrCore_set_form_notice('error', 'invalid user_id - data not found');
        jrCore_location('referrer');
    }

    $pass = jrCore_create_unique_string(8);
    $hash = jrUser_get_password_hash($pass);
    $_up  = array('user_password' => $hash);
    $_cr  = array('_profile_id' => $_usr['_profile_id']);
    if (jrCore_db_update_item('jrUser', $uid, $_up, $_cr, true, true, false)) {
        $_rp = array(
            'system_name' => $_conf['jrCore_system_name'],
            'jamroom_url' => $_conf['jrCore_base_url'],
            'user_name'   => $_usr['user_name'],
            'user_pass'   => $pass,
            'user_email'  => $_usr['user_email']
        );
        list($sub, $msg) = jrCore_parse_email_templates('jrUser', 'password_changed', $_rp);
        jrCore_send_email($_usr['user_email'], $sub, $msg);
        jrCore_set_form_notice('success', 'A new password has been generated and the user has been notified');
        jrCore_logger('INF', "user: a new password has been generated for user_id {$uid} - {$_usr['user_email']}");
    }
    else {
        jrCore_set_form_notice('error', 'An error was encountered saving the new password - please try again');
    }
    jrCore_location('referrer');
}
