<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: log_in
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_log_in($_post, $_user, $_conf)
{
    // If the user is already logged in, redirect to profile page
    if (jrUser_is_logged_in()) {
        $url = jrUser_get_profile_home_key('profile_url');
        jrCore_location("{$_conf['jrCore_base_url']}/{$url}");
    }
    // See if we are being asked to remember our location URL
    if (isset($_post['r']) && strlen($_post['r']) > 0) {
        if ($_post['r'] != 1) {
            if ($url = jrCore_get_memory_url($_post['r'])) {
                jrUser_save_location_to_cookie($url);
            }
        }
        elseif ($url = jrCore_get_local_referrer()) {
            jrUser_save_location_to_cookie($url);
        }
    }

    // Check for maintenance mode
    if (isset($_conf['jrCore_maintenance_mode']) && $_conf['jrCore_maintenance_mode'] == 'on') {
        $_ln = jrUser_load_lang_strings();
        jrCore_set_form_notice('notice', $_ln['jrCore'][35]);
    }
    else {
        if ($msg = jrCore_get_form_notice(false)) {
            if (is_array($msg)) {
                $type = array_keys($msg);
                $type = reset($type);
                $text = $msg[$type];

                $_user['form_message_type'] = $type;
                $_user['form_message_text'] = $text;
            }
        }
    }
    echo jrCore_parse_template('user_login.tpl', $_user, 'jrUser');
}
