<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: import_language_options_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_import_language_options_save($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_form_validate($_post);
    if (!isset($_post['import_id']) || strlen($_post['import_id']) !== 12) {
        jrCore_set_form_notice('error', "invalid unique file id - unable to import");
        jrCore_form_result();
    }
    // Get file
    $dir = jrCore_get_module_cache_dir('jrUser');
    $fil = "{$dir}/{$_post['import_id']}.lang";
    if (!is_file($fil)) {
        jrCore_set_form_notice('error', "language file not found - unable to import");
        jrCore_form_result();
    }

    $_tm = explode("\n", file_get_contents($fil));
    if (!$_tm || !is_array($_tm)) {
        jrCore_set_form_notice('error', "invalid language file - unable to import");
        jrCore_form_result();
    }

    $_td = array();
    if (isset($_post['import_modules']) && strlen($_post['import_modules']) > 0) {
        $_td = explode(',', $_post['import_modules']);
    }
    if (isset($_post['import_skins']) && strlen($_post['import_skins']) > 0) {
        $_td = array_merge($_td, explode(',', $_post['import_skins']));
    }
    $_td = array_flip($_td);

    $_skn = jrCore_get_skins();
    $done = 0;
    $_ex  = false;
    $tbl  = jrCore_db_table_name('jrUser', 'language');
    foreach ($_tm as $line) {
        list($mod, $lng, $chr, $dir, $idx, $txt) = explode(':', $line, 6);
        $idx = (int) $idx;
        if ($idx < 10000 && isset($_td[$mod]) && (isset($_mods[$mod]) || isset($_skn[$mod]))) {

            // Load up existing strings
            if (!$_ex) {
                $req = "SELECT * FROM {$tbl} WHERE lang_module = '{$mod}' AND lang_code = '{$lng}'";
                $_ex = jrCore_db_query($req, 'lang_key');
                if (!$_ex || !is_array($_ex)) {
                    $_ex = array();
                }
            }
            $txt = jrCore_db_escape(trim($txt));
            if (isset($_ex[$idx])) {
                $req = "UPDATE {$tbl} SET lang_text = '{$txt}' WHERE lang_id = '{$_ex[$idx]['lang_id']}'";
            }
            else {
                $lng = trim($lng);
                $chr = trim($chr);
                $dir = trim($dir);
                $req = "INSERT INTO {$tbl} (lang_module, lang_code, lang_charset, lang_ltr, lang_key, lang_text, lang_default) VALUES ('{$mod}', '{$lng}', '{$chr}', '{$dir}', '{$idx}', '{$txt}', '{$txt}')";
            }
            jrCore_db_query($req);
            $done++;
        }
    }

    unlink($fil);
    jrCore_form_delete_session();
    jrCore_delete_all_cache_entries();
    jrCore_set_form_notice('success', jrCore_number_format($done) . " language strings were successfully imported");
    jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/import_language");

}
