<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: export_language_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_export_language_save($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_form_validate($_post);

    $_td = array();
    if (isset($_post['export_modules']) && strlen($_post['export_modules']) > 0) {
        $_td = explode(',', $_post['export_modules']);
    }
    if (isset($_post['export_skins']) && strlen($_post['export_skins']) > 0) {
        $_td = array_merge($_td, explode(',', $_post['export_skins']));
    }
    $_td = array_flip($_td);

    $_tm = jrUser_load_lang_strings($_post['export_lang'], false, false);
    if ($_tm && is_array($_tm)) {
        $_sk = jrCore_get_skins();
        $tmp = jrCore_create_unique_string(12);
        $dir = jrCore_get_module_cache_dir('jrUser');
        $_fl = array();
        ksort($_tm);
        foreach ($_tm as $mod => $_strings) {
            if (isset($_td[$mod]) && (isset($_mods[$mod]) || isset($_sk[$mod]))) {
                $_fl[] = '';
                foreach ($_strings as $key => $val) {
                    // NOTE: custom lang strings have an id > 10,000
                    if (strlen($val) > 0 && $key < 10000) {
                        $_fl[] = "{$mod}:{$_tm['_settings']['code']}:{$_tm['_settings']['charset']}:{$_tm['_settings']['direction']}:{$key}:{$val}";
                    }
                }
            }
        }
        $dat = implode("\n", $_fl);
        jrCore_form_delete_session();
        jrCore_write_to_file("{$dir}/{$_post['export_lang']}_{$tmp}.lang", $dat);
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/export_language/{$_post['export_lang']}/{$tmp}");
    }
    else {
        jrCore_notice_page('error', "No language strings found for {$_post['export_lang']}");
    }
}
