<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: export_language
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_export_language($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrUser');

    $iframe = '';
    if (isset($_post['_2']) && strlen($_post['_2']) === 12) {
        $iframe = "<iframe src=\"{$_conf['jrCore_base_url']}/{$_post['module_url']}/export_language_download/{$_post['_1']}/{$_post['_2']}\" style=\"display:none;\"></iframe>";
    }
    $button = jrCore_page_button('uncheck', 'unselect all', "$('#jrUser_export_language').find('.form_checkbox').prop('checked', false)");
    jrCore_page_banner('export language strings', $iframe . $button);
    jrCore_get_form_notice();

    $tbl = jrCore_db_table_name('jrUser', 'language');
    $req = "SELECT lang_module FROM {$tbl} GROUP BY lang_module";
    $_ln = jrCore_db_query($req, 'lang_module', false, 'lang_module');

    // Get modules and skins
    $_mds = array();
    foreach ($_mods as $dir => $_inf) {
        if (isset($_ln[$dir])) {
            $_mds[$dir] = $_inf['module_name'];
        }
    }
    $_sks = jrCore_get_skins();
    $_skn = array();
    foreach ($_sks as $dir => $_inf) {
        $_tmp = jrCore_skin_meta_data($dir);
        if ($_tmp && isset($_ln[$dir])) {
            $_skn[$dir] = $_tmp['title'];
        }
    }

    // Form init
    $_tmp = array(
        'submit_value'     => 'export language strings',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // Export Language
    $_opt = jrUser_get_languages();
    $_tmp = array(
        'name'     => 'export_lang',
        'label'    => 'language to export',
        'help'     => 'Select the existing User Language you would like to export',
        'type'     => 'select',
        'options'  => $_opt,
        'default'  => 'en-US',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Modules
    natcasesort($_mds);
    $_tmp = array(
        'name'     => 'export_modules',
        'label'    => 'Selected for Export',
        'help'     => 'Select the modules you would like to export language strings for',
        'type'     => 'optionlist',
        'options'  => $_mds,
        'default'  => implode(',', array_keys($_mds)),
        'layout'   => 'columns',
        'columns'  => 3,
        'required' => true,
        'section'  => 'module language strings'
    );
    jrCore_form_field_create($_tmp);

    // Skins
    natcasesort($_skn);
    $_tmp = array(
        'name'     => 'export_skins',
        'label'    => 'Selected for Export',
        'help'     => 'Select the skins you would like to export language strings for',
        'type'     => 'optionlist',
        'options'  => $_skn,
        'default'  => implode(',', array_keys($_skn)),
        'layout'   => 'columns',
        'columns'  => 3,
        'required' => true,
        'section'  => 'skin language strings'
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
