<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: user_link
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_user_link($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrProfile');

    jrCore_set_form_notice('notice', 'User Accounts can be linked to multiple profiles - each works the same as the User\'s home profile.');
    jrCore_page_banner('User Profile Link');

    $_tmp = array(
        'submit_value'     => 'link user to profile',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'form_ajax_submit' => false
    );
    if (strpos(jrCore_get_local_referrer(), 'create')) {
        $_tmp['cancel'] = false;
    }
    jrCore_form_create($_tmp);

    // Select User
    if (isset($_post['user_id']) && jrCore_checktype($_post['user_id'], 'number_nz')) {
        $_us = jrCore_db_get_item('jrUser', $_post['user_id'], true);
        if (!$_us || !is_array($_us)) {
            jrCore_notice_page('error', 'Invalid User ID');
        }
        jrCore_page_custom("<strong>{$_us['user_name']}</strong>", 'user name');

        $_tmp = array(
            'name'     => 'link_user_id',
            'type'     => 'hidden',
            'validate' => 'number_nz',
            'value'    => $_post['user_id']
        );
        jrCore_form_field_create($_tmp);
    }
    else {
        $_tmp = array(
            'name'      => 'link_user_id',
            'label'     => 'user name',
            'type'      => 'live_search',
            'help'      => 'Select the User Account you want to link to an existing profile. The User Account can already be linked to an existing profile, and you can link a User Account to more than 1 profile.<br><br><b>NOTE:</b> Master and Admin User Accounts can already work with any profile in the system, so do not show up in this list.',
            'validate'  => 'not_empty',
            'required'  => true,
            'error_msg' => 'You have selected an invalid User Account - please try again',
            'target'    => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/user_link_get_user"
        );
        jrCore_form_field_create($_tmp);
    }

    // Select Profile
    $_tmp = array(
        'name'      => 'link_profile_id',
        'label'     => 'profile name',
        'type'      => 'live_search',
        'help'      => 'Select the Profile you want to link the User Account to.  The linked User Account will have full access to the profile as if it was their own.',
        'validate'  => 'not_empty',
        'required'  => true,
        'error_msg' => 'You have selected an invalid Profile - please try again',
        'target'    => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/user_link_get_profile"
    );
    jrCore_form_field_create($_tmp);

    // Replace Home Profile
    $_tmp = array(
        'name'     => 'link_replace',
        'label'    => 'set as profile owner',
        'type'     => 'checkbox',
        'help'     => 'If this option is checked, the existing User ID on the profile will be replaced with the selected User',
        'validate' => 'onoff',
        'required' => true,
        'default'  => 'off'
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
