<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: rebuild_count
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_rebuild_count($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs($_post['module']);

    // Select form to jump to other item owner changes
    $js   = 'var murl=this.options[this.selectedIndex].value;location=\'{$_conf[\'jrCore_base_url\']}/\' + murl + \'/change\';';
    $htm  = "<select name=\"change_owner\" class=\"form_select form_select_item_jumper\" onchange=\"{$js}\">\n";
    $_tmp = jrProfile_get_valid_modules();
    if ($_tmp && is_array($_tmp)) {
        natcasesort($_tmp);
        foreach ($_tmp as $mod => $name) {
            if (jrCore_module_is_active($mod)) {
                if (isset($_post['module']) && $mod == $_post['module']) {
                    $htm .= '<option value="' . jrCore_get_module_url($mod) . '" selected="selected"> ' . $name . '</option>' . "\n";
                }
                else {
                    $htm .= '<option value="' . jrCore_get_module_url($mod) . '"> ' . $name . '</option>' . "\n";
                }
            }
        }
    }
    $htm .= '</select>';
    jrCore_page_banner('Rebuild Profile Counts', $htm);

    // First check that we have some items
    if (jrCore_checktype(jrCore_db_get_ds_row_count($_post['module']), 'number_nz')) {
        jrCore_page_notice('success', 'This tool will rebuild the Profile counts for the <b>' . $_mods["{$_post['module']}"]['module_name'] . '</b> module', false);

        // Form init
        $_tmp = array(
            'submit_value'  => 'rebuild profile counts',
            'cancel'        => 'referrer',
            'submit_prompt' => 'Rebuild Profile Counts? On large systems this could take a few minutes to complete',
            'submit_modal'  => 'update',
            'modal_width'   => 600,
            'modal_height'  => 400,
            'modal_note'    => 'Please be patient while the Profile counts are rebuilt'
        );
        jrCore_form_create($_tmp);

        // Rebuild
        $_tmp = array(
            'name'     => 'rebuild_count',
            'label'    => 'rebuild count',
            'help'     => 'If this is checked, the profile counts for this module will be rebuilt for each profile',
            'type'     => 'checkbox',
            'value'    => 'on',
            'validate' => 'onoff'
        );
        jrCore_form_field_create($_tmp);

    }
    else {
        jrCore_page_notice('error', 'This module has no items in the DataStore - unable to rebuild counts');
    }
    jrCore_page_display();
}
