<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: quota_transfer_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_quota_transfer_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    // Get affected profile id's
    $tid = intval($_post['transfer_id']);
    $nid = intval($_post['new_quota_id']);

    $cnt = 0;
    $iid = 0;
    while (true) {

        $_sc = array(
            'search'              => array(
                "profile_quota_id = {$tid}",
                "_item_id > {$iid}"
            ),
            'order_by'            => array('_item_id' => 'asc'),
            'return_item_id_only' => true,
            'skip_all_checks'     => true,
            'limit'               => 250
        );
        $_rt = jrCore_db_search_items('jrProfile', $_sc);
        if ($_rt && is_array($_rt)) {

            $_up = array();
            foreach ($_rt as $pid) {
                $_up[$pid] = array('profile_quota_id' => $nid);
                $iid       = $pid;
            }
            jrCore_db_update_multiple_items('jrProfile', $_up);

            // Update profile counts
            $cnt += count($_rt);

        }
        else {
            break;
        }
    }
    if ($cnt > 0) {

        // Set old quota to 0 - no more profiles in it
        jrProfile_set_quota_value('jrProfile', $tid, 'profile_count', 0);

        // Increment new quota profile count by amount we have transferred
        jrProfile_increment_quota_profile_count($nid, $cnt);

        // Reset all caches - this is WAY faster then resetting caches for each profile_id
        jrCore_delete_all_cache_entries();

        jrCore_form_delete_session();
        jrCore_set_form_notice('success', "Successfully transferred {$cnt} profiles to the new quota");
        jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/quota_browser");

    }
    jrCore_set_form_notice('error', 'no profiles were found to transfer - please try again');
    jrCore_form_result();
}
