<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: list_profiles
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_list_profiles($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    if (!jrUser_is_power_user() && !jrUser_is_multi_user()) {
        jrCore_location(jrCore_get_base_url() . "/{$_user['profile_url']}");
    }

    // We're a power user or multi user and want to see the list of
    // profiles that we have access to - list them out here
    jrCore_page_banner(25);

    if (!$_rt = jrProfile_get_user_linked_profiles($_user['_user_id'])) {
        jrCore_notice_page('error', 'Unable to retrieve any profiles from the database - please try again');
    }

    $_rt = array(
        'search'          => array(
            '_item_id in ' . implode(',', array_keys($_rt))
        ),
        'return_keys'     => array('_updated', 'profile_url', '_profile_id', 'profile_name', 'profile_image_time', 'profile_image_extension'),
        'simplepagebreak' => 24,
        'page'            => (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) ? intval($_post['p']) : 1,
        'privacy_check'   => false
    );
    $_rt = jrCore_db_search_items('jrProfile', $_rt);
    if (!$_rt || !is_array($_rt['_items'])) {
        jrCore_notice_page('error', 'Unable to retrieve any profiles from the database - please try again');
    }

    $html = '<div class="profile_grid">';
    foreach ($_rt['_items'] as $_pr) {
        $_im  = array(
            'crop'  => 'portrait',
            'alt'   => $_pr['profile_name'],
            'title' => $_pr['profile_name'],
            'ext'   => (!empty($_pr['profile_image_extension'])) ? $_pr['profile_image_extension'] : '',
            '_v'    => (!empty($_pr['profile_image_time'])) ? $_pr['profile_image_time'] : $_pr['_updated']
        );
        $name = $_pr['profile_name'];
        if (strlen($name) > 25) {
            $name = substr($name, 0, 25) . '...';
        }
        $isrc = jrImage_get_image_src('jrProfile', 'profile_image', $_pr['_profile_id'], 'large', $_im);
        $html .= "<div class=\"item center\"><a href=\"" . jrCore_get_base_url() . "/{$_pr['profile_url']}\">{$isrc}</a><br><a href=\"{$_conf['jrCore_base_url']}/{$_pr['profile_url']}\">{$name}</a></div>";
    }
    $html .= '</div><div style="clear:both"></div>';
    jrCore_page_custom($html);

    $_rt['info']['total_pages'] = 0;  // This disables the page jumper
    $_rt['disable_page_select'] = true;
    jrCore_page_table_pager($_rt);

    jrCore_page_cancel_button('referrer');
    jrCore_page_display();
}
