<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: delete_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_delete_save($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();

    // Make sure we get a valid ID
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_notice_page('error', 'invalid profile id - please try again');
    }
    $_pr = jrCore_db_get_item('jrProfile', $_post['id'], true);
    if (!$_pr || !is_array($_pr)) {
        jrCore_notice_page('error', 'invalid profile id - no data for profile found');
    }

    // Make sure user is allowed to create profiles....
    if (!jrUser_is_admin()) {
        // Are we a power user?
        if (jrUser_is_power_user()) {
            if (!jrProfile_is_profile_owner($_post['id'])) {
                jrUser_not_authorized();
            }
        }
        // We are not a power user or admin - see if we are allowed to delete our profile
        elseif (isset($_conf['jrProfile_allow_delete']) && $_conf['jrProfile_allow_delete'] == 'on') {
            if (!jrProfile_is_profile_owner($_post['id'])) {
                jrUser_not_authorized();
            }
        }
        else {
            jrUser_not_authorized();
        }
    }

    // We need to get info about this profile first, and make sure any users are NOT admin users
    $_sp = array(
        'search'        => array(
            "_profile_id = {$_post['id']}"
        ),
        'return_keys'   => array(
            'user_name', 'user_group'
        ),
        'skip_triggers' => true,
        'no_cache'      => true,
        'limit'         => 1000
    );
    $_rt = jrCore_db_search_items('jrUser', $_sp);

    if ($_rt && is_array($_rt) && isset($_rt['_items'])) {
        foreach ($_rt['_items'] as $_v) {
            if (isset($_v['user_group'])) {
                switch ($_v['user_group']) {
                    case 'master':
                    case 'admin':
                        $murl = jrCore_get_module_url('jrUser');
                        jrCore_notice_page('error', "You cannot delete the primary profile for an Admin or Master User!<br>You must change the &quot;<a href=\"{$_conf['jrCore_base_url']}/{$murl}/account/user_id={$_v['_user_id']}\">{$_v['user_name']}</a>&quot; User Account to the &quot;user&quot; group before you can delete this profile.", 'referrer', 'continue', false);
                        break;
                }
            }
        }
    }

    // Delete Profile
    jrProfile_delete_profile($_post['id']);

    // If we just delete our OWN profile, and we are not associated with any other profiles, log out
    if (!jrUser_is_admin() && !jrUser_is_power_user()) {

        jrCore_start_timer('sleep');
        sleep(1);
        jrCore_stop_timer('sleep');

        // We no longer exist!?
        if (!jrCore_db_get_item('jrUser', $_user['_user_id'], true, true)) {

            // Send logout trigger
            jrCore_trigger_event('jrUser', 'logout', $_user);

            // Destroy session
            jrUser_session_destroy();

            // Redirect to front page
            jrCore_form_result($_conf['jrCore_base_url']);
        }
    }

    // user_active_profile_id will be invalid now - reset to profile home key
    $_SESSION['user_active_profile_id'] = jrUser_get_profile_home_key('_profile_id');

    // Redirect
    $mrl = jrCore_get_module_url('jrUser');
    $url = $_conf['jrCore_base_url'];
    $ref = jrCore_get_local_referrer();
    if (strpos($ref, "{$mrl}/dashboard/browser")) {
        jrCore_set_form_notice('success', 'The User Account <b>and</b> Profile were successfully deleted', false);
        jrCore_location('referrer');
    }
    if (strpos($ref, '/browser') || strpos($ref, '/pending')) {
        jrCore_set_form_notice('success', 33);
        jrCore_location('referrer');
    }
    jrCore_notice_page('success', 33, $url, 'continue', false);
}
