<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: systems_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_systems_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    // Make sure this does not already exist
    $cod = jrCore_db_escape($_post['system_code']);
    $url = jrCore_db_escape(trim($_post['system_url']));
    $tbl = jrCore_db_table_name('jrMarket', 'system');
    $req = "SELECT * FROM {$tbl} WHERE system_url = '{$url}' OR system_code = '{$cod}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (is_array($_rt)) {
        jrCore_set_form_notice('error', 'A system using that URL is already configured!');
        jrCore_form_result();
    }
    $nam = jrCore_db_escape($_post['system_name']);
    $eml = jrCore_db_escape($_post['system_email']);
    $req = "INSERT INTO {$tbl} (system_name, system_url, system_email, system_code, system_active) VALUES ('{$nam}', '{$url}', '{$eml}', '{$cod}', 'on')";
    $sid = jrCore_db_query($req, 'INSERT_ID');
    if (isset($sid) && jrCore_checktype($sid, 'number_nz')) {

        // Add in default stable/beta channels for this new system
        $_chan = array(
            'stable' => 1,
            'beta'   => 0
        );
        $tbl   = jrCore_db_table_name('jrMarket', 'channel');
        foreach ($_chan as $chn => $id) {
            $req = "INSERT INTO {$tbl} (channel_system_id, channel_created, channel_name, channel_active, channel_code) VALUES ('{$sid}', UNIX_TIMESTAMP(), '{$chn}', '{$id}', '') ON DUPLICATE KEY UPDATE channel_created = UNIX_TIMESTAMP()";
            jrCore_db_query($req);
        }
        jrCore_set_form_notice('success', "The new System has been successfully created");
        jrCore_form_delete_session();
    }
    else {
        jrCore_set_form_notice('error', 'An error was encountered trying to create the System - please try again');
    }
    jrCore_form_result();
}
