<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: system_update
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_system_update($_post, $_user, $_conf)
{
    global $_mods;
    $_skins = jrCore_get_skins();
    jrUser_master_only();

    // Check for a refresh code
    if (isset($_post['r']) && jrCore_checktype($_post['r'], 'number_nz')) {
        $url = jrCore_strip_url_params(jrCore_get_current_url(), array('r'));
        jrCore_location($url);
    }

    jrCore_page_include_admin_menu();
    if (isset($_post['all'])) {
        jrCore_page_admin_tabs('jrMarket');
        $title = 'reload modules or skins';
    }
    else {
        jrCore_page_admin_tabs('jrMarket', 'system_update');
        $title = 'system update';
    }

    // delete any old update tmp info
    jrCore_delete_temp_value('jrMarket', 'jrupdate_results');

    if (!$_mkt = jrMarket_get_active_release_system()) {
        jrCore_set_form_notice('error', 'There are no active Marketplace Systems configured where you can download items or get system updates!<br>Enter a new Marketplace System below to enable the Marketplace.', false);
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/systems");
    }
    if (!isset($_mkt['system_email']) || !jrCore_checktype($_mkt['system_email'], 'email')) {
        jrCore_set_form_notice('error', 'The Active Marketplace is missing some information required for System Updates');
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/release_system_update/id={$_mkt['system_id']}");
    }

    // Make sure we are subscribed to at least 1 channel
    $tbl = jrCore_db_table_name('jrMarket', 'channel');
    $req = "SELECT * FROM {$tbl} WHERE channel_active = '1'";
    $_rt = jrCore_db_query($req, 'channel_id');
    if (!isset($_rt) || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'You have not subscribed to any Update Channels - no updates can be provided.<br><br>You can activate an Update Channel from the <a href="' . $_conf['jrCore_base_url'] . '/' . $_post['module_url'] . '/release_channels"><b><u>Update Channels</u></b> tool.', false);
        jrCore_page_banner($title, jrMarket_system_jumper());
        jrCore_get_form_notice();
        jrCore_page_display();
        exit;
    }

    // pre-update checks
    $upd = true;
    if (!is_writable(APP_DIR . '/modules')) {
        // See if we are configured for FTP...
        if (!isset($_conf['jrMarket_ftp_user']) || strlen($_conf['jrMarket_ftp_user']) === 0 || !isset($_conf['jrMarket_ftp_pass']) || strlen($_conf['jrMarket_ftp_pass']) === 0) {
            jrCore_set_form_notice('error', 'Your modules directory is not writable - make sure you have entered FTP settings into the Global Config so the system can install and update modules.');
            jrCore_get_form_notice();
            $upd = false;
        }
    }
    if (!is_writable(APP_DIR . '/skins')) {
        if (!isset($_conf['jrMarket_ftp_user']) || strlen($_conf['jrMarket_ftp_user']) === 0 || !isset($_conf['jrMarket_ftp_pass']) || strlen($_conf['jrMarket_ftp_pass']) === 0) {
            jrCore_set_form_notice('error', 'Your skins directory is not writable - make sure you have entered FTP settings into the Global Config so the system can install and update skins.');
            jrCore_get_form_notice();
            $upd = false;
        }
    }

    $_ds = jrCore_get_disk_usage();
    if ($_ds['percent_used'] > 90 && $_ds['disk_free'] < 100000000) {
        jrCore_set_form_notice('warning', "Your site is low on disk space (currently using {$_ds['percent_used']}%)<br>Try to free up disk space before installing or updating modules or skins.", false);
    }

    $shw  = false;
    $temp = false;
    if ($upd) {

        $_rs = jrMarket_get_system_updates();
        if ($_rs && is_array($_rs)) {

            if (isset($_rs['warning'])) {
                jrCore_set_form_notice('error', $_rs['warning'], false);
                unset($_rs['warning']);
            }

            if (isset($_rs['error'])) {
                if (isset($_post['all'])) {
                    $shw = true;
                    jrCore_set_form_notice('error', $_rs['error']);
                }
            }
            else {
                // Save results so when we run our update we can get the correct version number
                jrCore_set_temp_value('jrMarket', 'latest_system_updates', $_rs);
            }
        }
        else {
            jrCore_page_banner($title, jrMarket_system_jumper());
            if (strpos($_rs, 'system maintenance') || strpos($_rs, 'jrLaunch')) {
                jrCore_set_form_notice('notice', 'The Active Marketplace is currently down for maintenance - please try again shortly');
            }
            else {
                jrCore_set_form_notice('error', 'An error was encountered trying to communicate with the Active Marketplace - please try again');
            }
            jrCore_get_form_notice();
            jrCore_page_display();
            exit;
        }

        $_up = array(
            'module' => array(),
            'skin'   => array(),
        );
        $_rl = array();
        $_mu = array();
        $_mr = array();
        $all = false;

        //----------------------------------------
        // First all the modules that have updates
        //----------------------------------------
        foreach ($_mods as $mod => $_inf) {
            if (isset($_rs['module'][$mod]['v']) && version_compare($_inf['module_version'], $_rs['module'][$mod]['v']) === -1) {
                // See if we have requires
                if (!isset($_post['all']) && isset($_rs['module'][$mod]['r']) && strlen($_rs['module'][$mod]['r']) > 0) {
                    // We have requires
                    foreach (explode(',', $_rs['module'][$mod]['r']) as $rmod) {
                        $rmod = trim($rmod);
                        $rver = false;
                        if (strpos($rmod, ':')) {
                            // We have a MINIMUM version for this requires
                            list($rmod, $rver) = explode(':', $rmod);
                        }
                        // Make sure we have it..
                        if (!isset($_mods[$rmod]) || version_compare($_mods[$rmod]['module_version'], $rver) === -1) {
                            // We'll pick it up after the required module is updated
                            continue 2;
                        }
                    }
                }
                $_up['module'][$mod]      = $_inf;
                $_up['module'][$mod]['d'] = intval($_rs['module'][$mod]['d']);
                $_mr[$mod]                = $_inf['module_name'];
                if (isset($_rs['module'][$mod]['l']) && strlen($_rs['module'][$mod]['l']) === 16) {
                    $all = true;
                }
            }
            elseif (isset($_rs['module'][$mod])) {
                $_rl[$mod] = $_inf;
                $_mr[$mod] = $_inf['module_name'];
            }
            elseif (isset($_post['all'])) {
                $_up['module'][$mod] = $_inf;
            }
            // See if we need to add in the license for this module
            if (isset($_rs['module'][$mod]) && !empty($_rs['module'][$mod]['l']) && empty($_inf['module_license'])) {
                $_mu[$mod] = $_rs['module'][$mod]['l'];
                $_mr[$mod] = $_inf['module_name'];
            }
        }
        if (!empty($_mu) && is_array($_mu)) {
            // We have licenses to update in modules
            $tbl = jrCore_db_table_name('jrCore', 'module');
            $req = "UPDATE {$tbl} SET module_license = CASE module_directory\n";
            foreach ($_mu as $mod => $license) {
                $req .= "WHEN '" . jrCore_db_escape($mod) . "' THEN '" . jrCore_db_escape($license) . "'\n";
            }
            $req .= "ELSE module_license END";
            jrCore_db_query($req);
        }
        unset($_mu);

        $ups  = false;
        $_srl = array();
        $_sr  = array();

        //----------------------------------------
        // Next all skins that have updates
        //----------------------------------------
        foreach ($_skins as $s => $sn) {
            $_sk        = jrCore_skin_meta_data($s);
            $_skins[$s] = $_sk;
        }
        foreach ($_skins as $skin => $_inf) {
            if (isset($_rs['skin'][$skin]['v']) && version_compare($_inf['version'], $_rs['skin'][$skin]['v']) === -1) {
                // See if we have requires
                if (!isset($_post['all']) && isset($_rs['skin'][$skin]['r']) && strlen($_rs['skin'][$skin]['r']) > 0) {
                    // We have requires
                    foreach (explode(',', $_rs['skin'][$skin]['r']) as $rmod) {
                        $rmod = trim($rmod);
                        $rver = false;
                        if (strpos($rmod, ':')) {
                            // We have a MINIMUM version for this requires
                            list($rmod, $rver) = explode(':', $rmod);
                        }
                        // Make sure we have it..
                        if (!isset($_mods[$rmod])) {
                            // We'll pick it up after the required module is updated
                            continue;
                        }
                        if (version_compare($_mods[$rmod]['module_version'], $rver) === -1) {
                            // We'll pick it up after the required module is updated
                            continue 2;
                        }
                    }
                }
                $_up['skin'][$skin]      = $_inf;
                $_up['skin'][$skin]['d'] = intval($_rs['skin'][$skin]['d']);
                $_sr[$skin]              = $_inf['title'];
                if (isset($_rs['skin'][$skin]['l']) && strlen($_rs['skin'][$skin]['l']) === 16) {
                    $all = true;
                }
            }
            elseif (isset($_rs['skin'][$skin])) {
                $_srl[$skin] = $_inf;
                $_sr[$skin]  = $_inf['title'];
            }
            // See if we need to add in the license for this module
            if (isset($_rs['skin'][$skin]) && !empty($_rs['skin'][$skin]['l'])) {
                // See if we have an existing license field for this skin
                if (isset($_conf["{$skin}_license"])) {
                    jrCore_set_setting_value($skin, 'license', $_rs['skin'][$skin]['l']);
                }
                else {
                    // Create it
                    $_fld = array(
                        'name'    => 'license',
                        'value'   => $_rs['skin'][$skin]['l'],
                        'default' => $_rs['skin'][$skin]['l'],
                        'type'    => 'hidden'
                    );
                    jrCore_update_setting($skin, $_fld);
                }
                $ups        = true;
                $_sr[$skin] = $_inf['title'];
            }
        }
        if ($ups) {
            // Reset settings so they reload
            jrCore_delete_config_cache();
        }

        natcasesort($_mr);
        natcasesort($_sr);

        // We need to save our UPDATES to the DB so we can access them
        // during an actual update event (to check for dependencies)
        jrCore_set_temp_value('jrMarket', 'jrupdate_results', $_up);

        $pass = jrCore_get_option_image('pass');
        $fail = jrCore_get_option_image('fail');
        $blk  = false;

        $temp = '';
        if (!isset($_post['all']) && (!empty($_up['module']) || !empty($_up['skin']))) {
            $mkey = md5(microtime() . mt_rand());
            jrCore_delete_temp_value('jrMarket', 'modal_update_key');
            jrCore_set_temp_value('jrMarket', 'modal_update_key', $mkey);
            if ($all && !isset($_up['module']['jrCore'])) {
                $temp = jrCore_page_button("uall", 'update all items', "jrCore_confirm('Install all updates?', '', function() { jrMarket_update_all_items('{$mkey}'); } )");
            }
            else {
                $temp = jrCore_page_button("uall", 'update all items', 'disabled');
            }
            $_args = array(
                'modal_width'   => 600,
                'modal_height'  => 400,
                'modal_note'    => 'Installing all available updates',
                'modal_onclick' => "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/validate_modules/bundle')"
            );
            jrCore_form_modal_window('jrMarket', $_args);
        }

        if (!empty($_up['module']) || !empty($_up['skin']) || isset($_post['all'])) {
            jrCore_page_banner($title, jrMarket_system_jumper() . '&nbsp;' . $temp);
            jrCore_get_form_notice();
        }

        // Our progress indicator for an individual item
        if (isset($_rs['module']['jrCore']) && (isset($_up['module']['jrCore']) || isset($_post['all']))) {

            $dat             = array();
            $dat[1]['title'] = '';
            $dat[1]['width'] = '2%';
            $dat[2]['title'] = 'system core';
            $dat[2]['width'] = '41%';
            $dat[3]['title'] = 'installed';
            $dat[3]['width'] = '8%';
            $dat[4]['title'] = 'available';
            $dat[4]['width'] = '8%';
            $dat[5]['title'] = 'changes';
            $dat[5]['width'] = '8%';
            $dat[6]['title'] = 'channel';
            $dat[6]['width'] = '20%';
            $dat[7]['title'] = 'status';
            $dat[7]['width'] = '8%';
            $dat[8]['title'] = 'action';
            $dat[8]['width'] = '5%';
            jrCore_page_table_header($dat);

            // Check for core first - if there is a core update, it must be done before
            // other modules are going to be updated
            $dat             = array();
            $dat[1]['title'] = jrCore_get_module_icon_html('jrCore', 32);
            $dat[2]['title'] = "<a href=\"{$_conf['jrCore_base_url']}/{$_mods['jrCore']['module_url']}/admin/info\">{$_mods['jrCore']['module_name']}</a>";
            $dat[3]['title'] = $_mods['jrCore']['module_version'];
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = (isset($_rs['module']['jrCore']['v'])) ? $_rs['module']['jrCore']['v'] : '-';
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = ($_rs['module']['jrCore']['o'] == '1') ? "<a onclick=\"popwin('{$_conf['jrCore_base_url']}/{$_post['module_url']}/changelog/jrCore/{$_rs['module']['jrCore']['v']}','changelog',800,500,'yes');return false\"><span style=\"text-decoration:underline;\"> changes</span></a>" : '-';
            $dat[5]['class'] = 'center';
            $dat[6]['title'] = (isset($_rs['module']['jrCore']['c'])) ? ucwords($_rs['module']['jrCore']['c']) : 'stable';
            $dat[6]['class'] = 'center';
            $dat[7]['title'] = $pass;
            $dat[7]['class'] = 'center';
            $dat[8]['title'] = jrCore_get_activity_indicator('ujrCore_spinner', 22);
            if (isset($_rs['module']['jrCore']['v']) && version_compare($_mods['jrCore']['module_version'], $_rs['module']['jrCore']['v']) === -1) {
                $dat[8]['title'] .= jrCore_page_button("ujrCore", 'update', "jrMarket_update_item('module','jrCore','update'," . intval($_rs['module']['jrCore']['d']) . ");");
                $blk             = true;
            }
            else {
                $dat[8]['title'] .= jrCore_page_button("ujrCore", 'reload', "jrCore_confirm('Reload module from Marketplace?', '', function() { jrMarket_update_item('module','jrCore','reload'," . intval($_rs['module']['jrCore']['d']) . "); } )");
            }
            $dat[8]['class'] = 'center';
            jrCore_page_table_row($dat);
            $shw = true;
        }

        // Go through installed modules
        if (!$blk) {

            if (!empty($_up['module']) || (isset($_post['all']) && !empty($_rs['module']))) {
                $dat             = array();
                $dat[1]['title'] = '';
                $dat[1]['width'] = '2%';
                $dat[2]['title'] = 'module';
                $dat[2]['width'] = '41%';
                $dat[3]['title'] = 'installed';
                $dat[3]['width'] = '8%';
                $dat[4]['title'] = 'available';
                $dat[4]['width'] = '8%';
                $dat[5]['title'] = 'changes';
                $dat[5]['width'] = '8%';
                $dat[6]['title'] = 'channel';
                $dat[6]['width'] = '20%';
                $dat[7]['title'] = 'status';
                $dat[7]['width'] = '8%';
                $dat[8]['title'] = 'action';
                $dat[8]['width'] = '5%';
                if ($shw) {
                    jrCore_page_table_header($dat, null, true);
                }
                else {
                    jrCore_page_table_header($dat);
                }
            }

            // Updates
            if (!empty($_up['module'])) {
                foreach ($_up['module'] as $mod => $_inf) {
                    $dat             = array();
                    $dat[1]['title'] = jrCore_get_module_icon_html($mod, 32);
                    $dat[2]['title'] = "<a href=\"{$_conf['jrCore_base_url']}/{$_inf['module_url']}/admin/info\">{$_inf['module_name']}</a>";
                    $dat[3]['title'] = $_inf['module_version'];
                    $dat[3]['class'] = 'center';
                    $dat[4]['title'] = (isset($_rs['module'][$mod]['v'])) ? $_rs['module'][$mod]['v'] : '-';
                    $dat[4]['class'] = 'center';
                    $dat[5]['title'] = (isset($_rs['module'][$mod]) && $_rs['module'][$mod]['o'] == '1') ? "<a onclick=\"popwin('{$_conf['jrCore_base_url']}/{$_post['module_url']}/changelog/{$mod}/{$_rs['module'][$mod]['v']}','changelog',800,500,'yes');return false\"><span style=\"text-decoration:underline;\"> changes</span></a>" : '-';
                    $dat[5]['class'] = 'center';
                    $dat[6]['title'] = (isset($_rs['module'][$mod]['c'])) ? ucwords($_rs['module'][$mod]['c']) : '?';
                    $dat[6]['class'] = 'center';
                    // Is this a custom module?  May not be found in marketplace
                    if (!isset($_rs['module'][$mod])) {
                        $dat[7]['title'] = '?';
                        $dat[7]['class'] = 'center';
                        $dat[8]['title'] = jrCore_page_button("p{$mod}", 'reload', 'disabled');
                        $dat[8]['class'] = 'center';
                    }
                    // We must have a license to update
                    elseif (!isset($_rs['module'][$mod]['l']) || strlen($_rs['module'][$mod]['l']) !== 16) {
                        $dat[7]['title'] = 'no<br>license';
                        $dat[7]['class'] = 'center error';
                        $dat[8]['title'] = jrCore_page_button("p{$mod}", 'purchase', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/browse/module/search_string={$mod}/sli=1');");
                        $dat[8]['class'] = 'error';
                    }
                    elseif (isset($_rs['module'][$mod]['v']) && version_compare($_inf['module_version'], $_rs['module'][$mod]['v']) === -1) {
                        $dat[7]['title'] = $pass;
                        $dat[7]['class'] = 'center';
                        $dat[8]['title'] = jrCore_get_activity_indicator("u{$mod}_spinner", 22) . jrCore_page_button("u{$mod}", 'update', "jrMarket_update_item('module','{$mod}','update'," . intval($_rs['module'][$mod]['d']) . ");");
                        $dat[8]['class'] = 'center';
                    }
                    else {
                        $dat[7]['title'] = $pass;
                        $dat[7]['class'] = 'center';
                        $dat[8]['title'] = jrCore_get_activity_indicator("u{$mod}_spinner", 22) . jrCore_page_button("u{$mod}", 'reload', "jrCore_confirm('Reload module from Marketplace?', '', function() { jrMarket_update_item('module','{$mod}','reload'," . intval($_rs['module'][$mod]['d']) . "); } )");
                        $dat[8]['class'] = 'center';
                    }
                    jrCore_page_table_row($dat);
                }
                $shw = true;
            }

            // Reloads
            if (!empty($_rl) && isset($_post['all'])) {
                foreach ($_mr as $mod => $mnam) {
                    if (!isset($_rl[$mod]) || $mod == 'jrCore') {
                        continue;
                    }
                    $_inf            = $_rl[$mod];
                    $dat             = array();
                    $dat[1]['title'] = jrCore_get_module_icon_html($mod, 32);
                    $dat[2]['title'] = "<a href=\"{$_conf['jrCore_base_url']}/{$_inf['module_url']}/admin/info\">{$_inf['module_name']}</a>";
                    $dat[3]['title'] = $_inf['module_version'];
                    $dat[3]['class'] = 'center';
                    $dat[4]['title'] = (isset($_rs['module'][$mod]['v'])) ? $_rs['module'][$mod]['v'] : '-';
                    $dat[4]['class'] = 'center';
                    $dat[5]['title'] = ($_rs['module'][$mod]['o'] == '1') ? "<a onclick=\"popwin('{$_conf['jrCore_base_url']}/{$_post['module_url']}/changelog/{$mod}/{$_rs['module'][$mod]['v']}','changelog',800,500,'yes');return false\"><span style=\"text-decoration:underline;\"> changes</span></a>" : '-';
                    $dat[5]['class'] = 'center';
                    $dat[6]['title'] = (isset($_rs['module'][$mod]['c'])) ? ucwords($_rs['module'][$mod]['c']) : '?';
                    $dat[6]['class'] = 'center';
                    // We must have a license to update
                    if (!isset($_rs['module'][$mod]['l']) || strlen($_rs['module'][$mod]['l']) !== 16) {
                        $dat[7]['title'] = 'no<br>license';
                        $dat[7]['class'] = 'center error';
                        $dat[8]['title'] = jrCore_page_button("p{$mod}", 'purchase', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/browse/module/search_string={$mod}/sli=1');");
                        $dat[8]['class'] = 'error';
                    }
                    elseif (isset($_rs['module'][$mod]['v']) && version_compare($_inf['module_version'], $_rs['module'][$mod]['v']) === -1) {
                        $dat[7]['title'] = $fail;
                        $dat[7]['class'] = 'center';
                        $dat[8]['title'] = jrCore_get_activity_indicator("u{$mod}_spinner", 22) . jrCore_page_button("u{$mod}", 'update', "jrMarket_update_item('module','{$mod}','update'," . intval($_rs['module'][$mod]['d']) . ");");
                        $dat[8]['class'] = 'center';
                    }
                    else {
                        $dat[7]['title'] = $pass;
                        $dat[7]['class'] = 'center';
                        $dat[8]['title'] = jrCore_get_activity_indicator("u{$mod}_spinner", 22) . jrCore_page_button("u{$mod}", 'reload', "jrCore_confirm('Reload module from Marketplace?', '', function() { jrMarket_update_item('module','{$mod}','reload'," . intval($_rs['module'][$mod]['d']) . "); } )");
                        $dat[8]['class'] = 'center';
                    }
                    jrCore_page_table_row($dat);
                    $shw = true;
                }
            }
        }
        elseif (isset($_up['module']['jrCore'])) {
            $dat             = array();
            $dat[1]['title'] = '<p>You must first update the ' . $_mods['jrCore']['module_name'] . ' module before updating other modules.</p>';
            $dat[1]['class'] = 'center';
            jrCore_page_table_row($dat);
        }

        // Go through installed skins
        if (!$blk) {

            // Skins
            if (!empty($_up['skin']) || (isset($_post['all']) && !empty($_rs['skin']))) {
                $dat             = array();
                $dat[1]['title'] = '';
                $dat[1]['width'] = '2%';
                $dat[2]['title'] = 'skin';
                $dat[2]['width'] = '41%';
                $dat[3]['title'] = 'installed';
                $dat[3]['width'] = '8%';
                $dat[4]['title'] = 'available';
                $dat[4]['width'] = '8%';
                $dat[5]['title'] = 'changes';
                $dat[5]['width'] = '8%';
                $dat[6]['title'] = 'channel';
                $dat[6]['width'] = '20%';
                $dat[7]['title'] = 'status';
                $dat[7]['width'] = '8%';
                $dat[8]['title'] = 'action';
                $dat[8]['width'] = '5%';
                if ($shw) {
                    jrCore_page_table_header($dat, null, true);
                }
                else {
                    jrCore_page_table_header($dat);
                }
            }

            // Updates
            if (!empty($_up['skin'])) {
                foreach ($_up['skin'] as $skin => $_inf) {
                    $dat             = array();
                    $dat[1]['title'] = jrCore_get_skin_icon_html($skin, 32);
                    $dat[2]['title'] = "<a href=\"{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_admin/info/skin={$_inf['name']}\">" . ((isset($_inf['title'])) ? $_inf['title'] : $_inf['name']) . "</a>";
                    $dat[3]['title'] = $_inf['version'];
                    $dat[3]['class'] = 'center';
                    $dat[4]['title'] = (isset($_rs['skin'][$skin]['v'])) ? $_rs['skin'][$skin]['v'] : '-';
                    $dat[4]['class'] = 'center';
                    $dat[5]['title'] = ($_rs['skin'][$skin]['o'] == '1') ? "<a onclick=\"popwin('{$_conf['jrCore_base_url']}/{$_post['module_url']}/changelog/{$skin}/{$_rs['skin'][$skin]['v']}','changelog',800,500,'yes');return false\"><span style=\"text-decoration:underline;\"> changes</span></a>" : '-';
                    $dat[5]['class'] = 'center';
                    $dat[6]['title'] = (isset($_rs['skin'][$skin]['c'])) ? ucwords($_rs['skin'][$skin]['c']) : '?';
                    $dat[6]['class'] = 'center';
                    // Is this a custom skin?  May not be found in marketplace
                    if (!isset($_rs['skin'][$skin])) {
                        $dat[7]['title'] = '?';
                        $dat[7]['class'] = 'center';
                        $dat[8]['title'] = jrCore_page_button("p{$skin}", 'reload', 'disabled');
                        $dat[8]['class'] = 'center';
                    }
                    // We must have a license to update
                    elseif (!isset($_rs['skin'][$skin]['l']) || strlen($_rs['skin'][$skin]['l']) !== 16) {
                        $dat[7]['title'] = 'no<br>license';
                        $dat[7]['class'] = 'center error';
                        $dat[8]['title'] = jrCore_page_button("p{$skin}", 'purchase', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/browse/skin/search_string={$skin}/sli=1');");
                        $dat[8]['class'] = 'error';
                    }
                    elseif (isset($_rs['skin'][$skin]['v']) && version_compare($_inf['version'], $_rs['skin'][$skin]['v']) === -1) {
                        $dat[7]['title'] = $pass;
                        $dat[7]['class'] = 'center';
                        $dat[8]['title'] = jrCore_get_activity_indicator("u{$skin}_spinner", 22) . jrCore_page_button("u{$skin}", 'update', "jrMarket_update_item('skin','{$skin}','update'," . intval($_rs['skin'][$skin]['d']) . ");");
                        $dat[8]['class'] = 'center';
                    }
                    else {
                        $dat[7]['title'] = $pass;
                        $dat[7]['class'] = 'center';
                        $dat[8]['title'] = jrCore_get_activity_indicator("u{$skin}_spinner", 22) . jrCore_page_button("u{$skin}", 'reload', "jrCore_confirm('Reload skin from Marketplace?', '', function() { jrMarket_update_item('skin','{$skin}','reload'," . intval($_rs['skin'][$skin]['d']) . "); } )");
                        $dat[8]['class'] = 'center';
                    }
                    jrCore_page_table_row($dat);
                }
                $shw = true;
            }

            // Reloads
            if (!empty($_srl) && isset($_post['all'])) {
                foreach ($_sr as $skin => $snam) {
                    if (!isset($_srl[$skin])) {
                        continue;
                    }
                    $_inf            = $_srl[$skin];
                    $dat             = array();
                    $dat[1]['title'] = jrCore_get_skin_icon_html($skin, 32);
                    $dat[2]['title'] = "<a href=\"{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_admin/info/skin={$_inf['name']}\">" . ((isset($_inf['title'])) ? $_inf['title'] : $_inf['name']) . "</a>";
                    $dat[3]['title'] = $_inf['version'];
                    $dat[3]['class'] = 'center';
                    $dat[4]['title'] = (isset($_rs['skin'][$skin]['v'])) ? $_rs['skin'][$skin]['v'] : '-';
                    $dat[4]['class'] = 'center';
                    $dat[5]['title'] = ($_rs['skin'][$skin]['o'] == '1') ? "<a onclick=\"popwin('{$_conf['jrCore_base_url']}/{$_post['module_url']}/changelog/{$skin}/{$_rs['skin'][$skin]['v']}','changelog',800,500,'yes');return false\"><span style=\"text-decoration:underline;\"> changes</span></a>" : '-';
                    $dat[5]['class'] = 'center';
                    $dat[6]['title'] = (isset($_rs['skin'][$skin]['c'])) ? $_rs['skin'][$skin]['c'] : '?';
                    $dat[6]['class'] = 'center';
                    // We must have a license to update
                    if (!isset($_rs['skin'][$skin]['l']) || strlen($_rs['skin'][$skin]['l']) !== 16) {
                        $dat[7]['title'] = 'no<br>license';
                        $dat[7]['class'] = 'center error';
                        $dat[8]['title'] = jrCore_page_button("p{$skin}", 'purchase', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/browse/skin/search_string={$skin}/sli=1');");
                        $dat[8]['class'] = 'error';
                    }
                    elseif (isset($_rs['skin'][$skin]['v']) && version_compare($_inf['version'], $_rs['skin'][$skin]['v']) === -1) {
                        $dat[7]['title'] = $fail;
                        $dat[7]['class'] = 'center';
                        $dat[8]['title'] = jrCore_get_activity_indicator("u{$skin}_spinner", 22) . jrCore_page_button("u{$skin}", 'update', "jrMarket_update_item('skin','{$skin}','update'," . intval($_rs['skin'][$skin]['d']) . ");");
                        $dat[8]['class'] = 'center';
                    }
                    else {
                        $dat[7]['title'] = $pass;
                        $dat[7]['class'] = 'center';
                        $dat[8]['title'] = jrCore_get_activity_indicator("u{$skin}_spinner", 22) . jrCore_page_button("u{$skin}", 'reload', "jrCore_confirm('Reload skin from Marketplace?', '', function() { jrMarket_update_item('skin','{$skin}','reload'," . intval($_rs['skin'][$skin]['d']) . "); } )");
                        $dat[8]['class'] = 'center';
                    }
                    jrCore_page_table_row($dat);
                    $shw = true;
                }
            }
        }
        if ($shw) {
            jrCore_page_table_footer();
        }
    }
    if (!$shw) {
        jrCore_set_form_notice('success', 'All modules and skins are up to date');
        jrCore_page_banner($title, jrMarket_system_jumper() . '&nbsp;' . $temp);
        jrCore_get_form_notice();
    }
    jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools");
    jrCore_page_display();
}
