<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: payment_methods
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_payment_methods($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrMarket', 'browse');
    jrCore_page_banner('Payment Methods');
    jrCore_get_form_notice();

    jrMarket_browse_tabs('methods');
    $_inf = jrMarket_get_market_info();

    $note = '<div id="secure_notice" style="padding:0 18px"><div class="item success rounded"><b>' . $_inf['system_name'] . '</b> uses <a href="https://stripe.com/" target="_blank" rel="noreferrer noopener"><b>Stripe</b></a> for all direct Marketplace purchases, which accepts all major credit cards.<br><br>If you would prefer to use an alternate payment provider you can do so by purchasing the module, skin or bundle directly by <b>clicking the &quot;more info...&quot; link for any item</b>.  You will taken directly to the item\'s detail page, where you can add it to your cart.  Upon checking out you will be able to select an alternative payment provider from the following:<br><ul>';
    if (isset($_inf['providers']) && is_array($_inf['providers'])) {
        foreach ($_inf['providers'] as $provider) {
            $note .= "<li>" . strip_tags($provider) . "</li>";
        }
    }
    $note .= '</ul>If you would like to use a Payment Provider not listed here, or have any questions, please don\'t hesitate to contact us.<br><br>Thanks!</div></div>';
    jrCore_page_custom($note);
    jrCore_page_display();
}
