<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: install_item
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_install_item($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_validate_location_url();

    if (!isset($_post['_2']) || strlen($_post['_2']) === 0) {
        $_rs = array('error' => 'Invalid install item received - please try again');
        jrCore_json_response($_rs);
    }
    if (!isset($_post['_3']) || !jrCore_checktype($_post['_3'], 'number_nz')) {
        $_rs = array('error' => 'Invalid install item_id received - please try again');
        jrCore_json_response($_rs);
    }

    // Make sure we have time to run
    ignore_user_abort(true);
    ini_set('max_execution_time', 1800);

    switch ($_post['_1']) {

        case 'module':
            if (!isset($_post['license']) || strlen($_post['license']) !== 16) {
                $_rs = array('error' => 'Invalid module license received - please try again');
                jrCore_json_response($_rs);
            }
            if (jrMarket_install_module($_post['_2'], $_post['license'], $_post['_3'])) {
                $_mta = jrCore_module_meta_data($_post['_2']);

                $old = false;
                if (isset($_mods["{$_post['_2']}"]['module_version'])) {
                    $old = true;
                }
                $_tmp                              = array(
                    'modules' => array(),
                    'skins'   => array()
                );
                $_tmp['modules']["{$_post['_2']}"] = array(
                    'old_version' => ($old) ? $_mods["{$_post['_2']}"]['module_version'] : '-',
                    'action'      => ($old) ? 'updated' : 'installed'
                );
                // Add this item into our history
                $tbl = jrCore_db_table_name('jrMarket', 'install');
                $req = "INSERT INTO {$tbl} (install_time, install_data) VALUES (UNIX_TIMESTAMP(), '" . jrCore_db_escape(json_encode($_tmp)) . "')";
                $iid = jrCore_db_query($req, 'INSERT_ID');
                if (!jrCore_checktype($iid, 'number_nz')) {
                    jrCore_logger('CRI', "Unable to save install history for module: {$_post['_2']}");
                }

                $_rs = array(
                    'success' => 'The new module was successfully installed',
                    'url'     => jrCore_get_base_url() . "/{$_mta['url']}/admin/info"
                );
                jrCore_set_form_notice('success', $_rs['success']);
                jrCore_json_response($_rs);
            }
            break;

        case 'skin':
            if (!isset($_post['license']) || strlen($_post['license']) !== 16) {
                $_rs = array('error' => 'Invalid skin license received - please try again');
                jrCore_json_response($_rs);
            }
            if (jrMarket_install_skin($_post['_2'], $_post['license'], $_post['_3'])) {

                $_mt = jrCore_skin_meta_data($_post['_2']);
                $old = false;
                if (isset($_mt['version'])) {
                    $old = true;
                }
                $_tmp                            = array(
                    'modules' => array(),
                    'skins'   => array()
                );
                $_tmp['skins']["{$_post['_2']}"] = array(
                    'old_version' => ($old) ? $_mt['version'] : '-',
                    'action'      => ($old) ? 'updated' : 'installed'
                );
                // Add this item into our history
                $tbl = jrCore_db_table_name('jrMarket', 'install');
                $req = "INSERT INTO {$tbl} (install_time, install_data) VALUES (UNIX_TIMESTAMP(), '" . jrCore_db_escape(json_encode($_tmp)) . "')";
                $iid = jrCore_db_query($req, 'INSERT_ID');
                if (!jrCore_checktype($iid, 'number_nz')) {
                    jrCore_logger('CRI', "Unable to save install history for skin: {$_post['_2']}");
                }

                $url = jrCore_get_module_url('jrCore');
                $_rs = array(
                    'success' => 'The new skin was successfully installed',
                    'url'     => "{$_conf['jrCore_base_url']}/{$url}/skin_admin/info/skin=" . $_post['_2']
                );
                jrCore_set_form_notice('success', $_rs['success']);
                jrCore_json_response($_rs);
            }
            break;

        case 'bundle':

            if (!isset($_post['license']) || strlen($_post['license']) < 16) {
                $_rs = array('error' => 'Invalid bundle license received - please try again');
                jrCore_json_response($_rs);
            }
            // For a bundle install our returned license will be the items
            // we are installing - i.e.
            // jrYouTube:module:<license>,jrProfileTweaks:module:<license>[,...]
            $_lic = explode(',', jrCore_get_temp_value('jrMarket', $_post['license']));
            jrCore_delete_temp_value('jrMarket', $_post['license']);
            if (!is_array($_lic)) {
                $_rs = array('error' => 'Invalid bundle license received - please try again (2)');
                jrCore_json_response($_rs);
            }
            $_tmp = array(
                'modules' => array(),
                'skins'   => array()
            );
            foreach ($_lic as $item) {
                list($name, $type, $license) = explode(':', $item, 3);
                switch ($type) {
                    case 'module':
                        if (jrMarket_install_module($name, $license)) {
                            $old = false;
                            if (isset($_mods[$name]['module_version'])) {
                                $old = true;
                            }
                            $_tmp['modules'][$name] = array(
                                'old_version' => ($old) ? $_mods[$name]['module_version'] : '-',
                                'action'      => ($old) ? 'updated' : 'installed'
                            );
                        }
                        break;
                    case 'skin':
                        if (jrMarket_install_skin($name, $license)) {
                            if (!isset($_skins)) {
                                $_skins = jrCore_get_skins();
                            }
                            $_mt = false;
                            $old = false;
                            if (isset($_skins[$name])) {
                                $_mt = jrCore_skin_meta_data($name);
                                $old = true;
                            }
                            $_tmp['skins'][$name] = array(
                                'old_version' => ($old) ? $_mt['version'] : '-',
                                'action'      => ($old) ? 'updated' : 'installed'
                            );
                        }
                        break;
                    default:
                        // We should _never_ fall through here
                        $_rs = array('error' => 'Invalid item type returned in license result: ' . htmlentities($type));
                        jrCore_json_response($_rs);
                        break;
                }
            }
            // Make sure we installed something
            if (!empty($_tmp['modules']) || !empty($_tmp['skins'])) {
                // We installed stuff
                $tbl = jrCore_db_table_name('jrMarket', 'install');
                $req = "INSERT INTO {$tbl} (install_time, install_data) VALUES (UNIX_TIMESTAMP(), '" . jrCore_db_escape(json_encode($_tmp)) . "')";
                $iid = jrCore_db_query($req, 'INSERT_ID');
                $_rs = array(
                    'success' => 'bundle installed',
                    'url'     => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/install_result/{$iid}"
                );
                jrCore_json_response($_rs);
            }
            else {
                $_rs = array('error' => 'Unable to install any of the bundle items - please try again');
                jrCore_json_response($_rs);
            }
            break;
    }

    // Fall through from case
    $_rs = array('error' => 'Invalid install type received - please try again');
    jrCore_json_response($_rs);
}
