<?php
 /**
 * Jamroom Image Support module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: img
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrImage_img($_post, $_user, $_conf)
{
    global $_urls;
    // http://site.com/image/img/module/jrAudio/img.png
    // http://site.com/image/img/skin/jrElastic/img.png
    $tag = '';
    if ($_post['_1'] == 'module') {
        if (!jrCore_module_is_active($_post['_2'])) {
            jrCore_notice('Error', 'invalid module');
        }
        $tag = 'mod_';
    }
    elseif ($_post['_1'] != 'skin') {
        // Backwards compatibility check
        if (isset($_urls["{$_post['_1']}"])) {
            $_post['_3'] = $_post['_2'];
            $_post['_2'] = $_urls["{$_post['_1']}"];
            $_post['_1'] = 'module';
        }
        else {
            jrCore_notice('Error', 'invalid module');
        }
    }
    if (!isset($_post['_3']) || strlen($_post['_3']) === 0) {
        jrCore_notice('Error', 'invalid image');
    }
    // See if we have a custom file for this image
    $_im = array();
    if (!empty($_conf["jrCore_{$_post['_2']}_custom_images"])) {
        $_im = json_decode($_conf["jrCore_{$_post['_2']}_custom_images"], true);
    }
    if (isset($_im["{$_post['_3']}"]) && (!isset($_im["{$_post['_3']}"][1]) || $_im["{$_post['_3']}"][1] == 'on')) {
        $img = APP_DIR . "/data/media/0/0/{$tag}{$_post['_2']}_{$_post['_3']}";
    }
    elseif ($_post['_1'] == 'module') {
        // Do we have a skin override?
        $ovr = APP_DIR . "/skins/{$_conf['jrCore_active_skin']}/img/{$_post['_2']}_{$_post['_3']}";
        if (is_file($ovr)) {
            $img = $ovr;
        }
        else {
            $img = APP_DIR . "/modules/{$_post['_2']}/img/{$_post['_3']}";
        }
    }
    else {
        $img = APP_DIR . "/skins/{$_post['_2']}/img/{$_post['_3']}";
    }

    // Custom headers added by modules
    $_tmp = jrCore_get_flag('jrcore_set_custom_header');
    if ($_tmp && is_array($_tmp)) {
        foreach ($_tmp as $header) {
            header($header);
        }
    }

    // Let other modules change our images if needed
    $img = jrCore_trigger_event('jrImage', "{$_post['_1']}_image", $img, $_im);

    switch (jrCore_file_extension($_post['_3'])) {
        case 'jpg':
        case 'jpe':
        case 'jpeg':
        case 'jif':
        case 'jfi':
        case 'jfif':
            header("Content-type: image/jpeg");
            break;
        case 'png':
            header("Content-type: image/png");
            break;
        case 'gif':
            header("Content-type: image/gif");
            break;
        case 'ico':
            header("Content-type: image/x-icon");
            break;
        case 'svg':
            header("Content-type: image/svg+xml");
            break;
        default:
            jrCore_notice('Error', 'invalid image');
            break;
    }

    $tim = filemtime($img);
    jrImage_send_not_modified($tim, $img);

    if (isset($_SESSION)) {
        session_write_close();
    }

    // Required for the process_exit (shutdown function) to detach properly from the client
    if (function_exists('apache_setenv')) {
        apache_setenv('no-gzip', 1);
    }
    ini_set('zlib.output_compression', 0);
    ini_set('implicit_flush', 1);

    // Send output
    // THE ORDER OF THE FOLLOWING STATEMENTS is critical for it
    // to work properly on mod_php, CGI/FastCGI, and FPM - DO NOT CHANGE!
    @ob_end_clean();
    $img = jrCore_file_get_contents($img);
    $len = strlen($img);
    header("Last-Modified: " . gmdate('r', $tim));
    header('Content-Disposition: inline; filename="' . $_post['_3'] . '"');
    header('Content-Length: ' . $len);
    header('Cache-Control: must-revalidate');
    header('Expires: ' . gmdate('D, d M Y H:i:s \G\M\T', time() + 8640000));
    ignore_user_abort();
    ob_start();
    echo $img;
    ob_end_flush();
    @flush();

    // PHP-FPM only
    if (function_exists('fastcgi_finish_request')) {
        fastcgi_finish_request();
    }
    $_tmp = array('img_length' => $len);

    // NOTE: Do not use a process_exit event here - we don't want
    // queues and other items starting up at this point
    jrCore_trigger_event('jrCore', 'process_done', $_tmp); // OK
    exit; // OK
}
