<?php
 /**
 * Jamroom Geo Location module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: zip_search
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrGeo_zip_search($_post, $_user, $_conf)
{
    global $_urls;
    // Our URL will come in one of TWO ways:
    // site.com/geo/zip_search/profile/profile_zip_code/US/98036/20  (with country code)
    // site.com/geo/zip_search/profile/profile_zip_code/98036/20     (without country code)
    // Module URL
    if (!$api = jrGeo_get_google_api_key()) {
        jrCore_notice_page('error', 'Missing required Google API key for maps - check Global Config');
    }
    if (empty($_post['_1']) || !isset($_urls["{$_post['_1']}"])) {
        jrCore_notice_page('error', 'invalid search module');
    }

    $_parts = jrGeo_get_url_components();
    $mod    = $_parts['module'];
    $key    = $_parts['field'];

    // Did we find a zip code?
    if (empty($_parts['zip_code']) || $_parts['zip_code'] === 'unknown') {
        // Try to get zip from IP
        if ($uip = jrCore_get_ip()) {
            if ($_geo = jrGeo_location($uip)) {
                if (!empty($_geo['postal_code'])) {
                    $_parts['zip_code'] = $_geo['postal_code'];
                }
                if (!empty($_geo['country_code']) && strlen($_geo['country_code']) === 2) {
                    $_parts['country'] = $_geo['country_code'];
                }
            }
        }
    }

    $cky = jrCore_get_current_url();
    if (!$out = jrCore_is_cached('jrGeo', $cky)) {

        if (!$_zp = jrGeo_get_info_for_zip_code($_parts['zip_code'], $_parts['country'])) {
            $_zp = array();
        }
        $url = jrCore_get_module_url($mod);
        $pfx = jrCore_db_get_prefix($mod);
        $tpl = 'item_list.tpl';
        if (is_file(APP_DIR . "/modules/{$mod}/templates/item_zip_search.tpl")) {
            $tpl = 'item_zip_search.tpl';
        }
        elseif (is_file(APP_DIR . "/modules/{$mod}/templates/item_search.tpl")) {
            $tpl = 'item_search.tpl';
        }

        // Get default zoom level based on radius
        $zoom = 12;
        if (!empty($_parts['radius'])) {
            if ($_parts['radius'] > 50) {
                $zoom = 8;
            }
            elseif ($_parts['radius'] > 25) {
                $zoom = 9;
            }
            elseif ($_parts['radius'] > 10) {
                $zoom = 10;
            }
        }

        $_rp = array(
            'ds_key'   => $key,
            'api_key'  => $api,
            'module'   => $mod,
            'template' => $tpl,
            'country'  => (!empty($_parts['country']) && strlen($_parts['country']) === 2) ? $_parts['country'] : 'US',
            'radius'   => (int) $_parts['radius'],
            'zoom'     => $zoom
        );
        if (!empty($_parts['zip_code']) && $_parts['zip_code'] !== 'unknown') {

            if (!empty($_parts['country']) && $_parts['country'] == 'CA') {
                $_parts['zip_code'] = $_parts['zip_orig'];
            }
            if (!$_zr = jrGeo_get_cached_radius_info($_parts['country'], $_parts['zip_code'], $_parts['radius'])) {
                $_zr = jrGeo_get_zip_codes_with_radius($_zp['zip_lat'], $_zp['zip_lon'], $_parts['radius'], $_parts['zip_code'], $_parts['country']);
            }
            if (!empty($_zr) && is_array($_zr)) {

                $reorder = false;
                $_sp     = array(
                    'ignore_missing' => true,
                    'limit'          => count($_zr)
                );
                if ($_parts['country'] == 'CA') {
                    // With a canadian postal code only use the first THREE digits of the ZIP code
                    $_sp['search'] = array("{$key} regexp ^" . implode('|^', array_keys($_zr)));
                    // Since we're using a REGEXP match condition, our results will not be ordered by
                    // the key so we need to reorder below so they come out with closest first
                    $reorder = true;
                }
                else {
                    $_sp['search'] = array("{$key} in " . implode(',', array_keys($_zr)));
                }
                $_sp = jrCore_db_search_items($mod, $_sp);
                if ($_sp && is_array($_sp) && !empty($_sp['_items']) && is_array($_sp['_items'])) {

                    if ($reorder) {
                        $_new = array();
                        foreach ($_zr as $zip_prefix => $ignore) {
                            foreach ($_sp['_items'] as $v) {
                                if (strpos($v[$key], $zip_prefix) === 0) {
                                    $_new[] = $v;
                                }
                            }
                        }
                        $_sp['_items'] = $_new;
                    }

                    // Add additional data into our items
                    foreach ($_sp['_items'] as $k => $v) {
                        if (!empty($v["{$pfx}_geocode_lat"])) {
                            $_sp['_items'][$k]['latlng'] = '{ lat: ' . $v["{$pfx}_geocode_lat"] . ', lng: ' . $v["{$pfx}_geocode_lng"] . ' }';
                        }
                        else {
                            if (!empty($v[$key])) {
                                $_sp['_items'][$k]['latlng'] = '{ lat: ' . $_zr["{$v[$key]}"]['zip_lat'] . ', lng: ' . $_zr["{$v[$key]}"]['zip_lon'] . ' }';
                                $v["{$pfx}_geocode_lat"]     = $_zr["{$v[$key]}"]['zip_lat'];
                                $v["{$pfx}_geocode_lng"]     = $_zr["{$v[$key]}"]['zip_lon'];
                            }
                            jrCore_queue_create('jrGeo', 'geocode_address', array('module' => $mod, '_item' => $v));
                        }
                        $item_url = '';
                        if (!empty($v["{$pfx}_title"])) {
                            $_sp['_items'][$k]['title'] = addslashes($v["{$pfx}_title"]);
                            $item_url                   = '/' . $v["{$pfx}_title_url"];
                        }
                        elseif (!empty($v["{$pfx}_name"])) {
                            $_sp['_items'][$k]['title'] = addslashes($v["{$pfx}_name"]);
                        }
                        else {
                            $_sp['_items'][$k]['title'] = $v['_item_id'];
                        }
                        $_sp['_items'][$k]['address'] = jrGeo_get_address_from_item_data($mod, $v);
                        if (empty($_sp['_items'][$k]['address'])) {
                            $_sp['_items'][$k]['address'] = $_parts['zip_code'];
                        }
                        $_sp['_items'][$k]['image_field'] = "{$pfx}_image";

                        switch ($mod) {
                            case 'jrProfile':
                            case 'jrUser':
                                $_sp['_items'][$k]['item_url'] = jrCore_get_base_url() . "/{$v['profile_url']}";
                                break;
                            default:
                                $_sp['_items'][$k]['item_url'] = jrCore_get_base_url() . "/{$v['profile_url']}/{$url}/{$v['_item_id']}{$item_url}";
                                break;
                        }
                    }
                }
                $_rp['_zip']     = $_zp;
                $_rp['_results'] = $_zr;
                $_rp['zip_code'] = $_parts['zip_code'];
                $_rp['_items']   = '';
                if (!empty($_sp['_items']) && is_array($_sp['_items'])) {
                    $_rp['_items'] = $_sp['_items'];
                }
            }
        }
        $out = jrCore_parse_template('zip_search_results.tpl', $_rp, 'jrGeo');
        jrCore_add_to_cache('jrGeo', $cky, $out);
    }
    return $out;
}
