<?php
 /**
 * Jamroom Geo Location module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: install_db
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrGeo_install_db($_post, $_user, $_conf)
{
    // Masters only
    jrUser_master_only();
    jrCore_validate_location_url();

    @ini_set('max_execution_time', 3600); // 1 hour max
    @ini_set('memory_limit', '1024M');

    $_db = jrGeo_get_available_database_info();
    if (!isset($_post['_1']) || !isset($_db["{$_post['_1']}"])) {
        jrCore_set_form_notice('error', 'invalid database - please try again');
        jrCore_location('referrer');
    }
    $_db = $_db["{$_post['_1']}"];

    // Download and save Database File
    $upd = false;
    $cdr = jrCore_get_module_cache_dir('jrGeo');
    $tmp = "{$cdr}/temp.{$_db[3]}";
    if (is_file($tmp)) {
        unlink($tmp);
    }
    jrCore_download_file($_db[2], $tmp, 1800);
    if (is_file($tmp)) {
        $time = time();
        if (jrCore_copy_media_file(0, $tmp, "{$_post['_1']}-{$time}.{$_db[3]}")) {

            jrCore_set_setting_value('jrGeo', $_db[0], $time);
            jrCore_delete_config_cache();
            unlink($tmp);

            // Cleanup OLD entries
            $dir = jrCore_get_media_directory(0, FORCE_LOCAL);
            $_fl = glob("{$dir}/{$_post['_1']}*.{$_db[3]}");
            if ($_fl && is_array($_fl)) {
                foreach ($_fl as $file) {
                    if (!strpos($file, "-{$time}")) {
                        jrCore_delete_media_file(0, basename($file));
                        $upd = true;
                    }
                }
            }

            // Post Processing
            switch ($_post['_1']) {
                case 'zipcode':
                    // Create queue entry to rebuild database
                    jrCore_queue_create('jrGeo', 'install_zipcode_db', array('file' => "{$dir}/{$_post['_1']}-{$time}.{$_db[3]}"));
                    break;
            }
        }
        else {
            jrCore_set_form_notice('error', "Error writing the {$_db[1]} file - please try again");
            jrCore_location('referrer');
        }
    }
    else {
        jrCore_set_form_notice('error', "Error saving the {$_db[1]} file - please try again");
        jrCore_location('referrer');
    }
    if ($upd) {
        jrCore_set_form_notice('success', "The {$_db[1]} was successfully updated");
    }
    else {
        jrCore_set_form_notice('success', "The {$_db[1]} was successfully installed");
    }
    jrCore_form_result();
}
