<?php
 /**
 * Jamroom Followers module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: unfollow
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrFollower_unfollow($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();

    $uid = $_user['_user_id'];
    $pid = (int) $_post['_1'];

    // Make sure user is a follower
    if ($_rt = jrFollower_get_follow($uid, $pid)) {
        jrFollower_delete_follow($uid, $pid);
        // If this follower is ACTIVE, we need to decrement follower counts
        if (isset($_rt['follow_active']) && $_rt['follow_active'] == '1') {
            jrCore_db_decrement_key('jrProfile', $pid, 'profile_jrFollower_item_count', 1);
        }
        jrProfile_reset_cache($pid);
        jrUser_reset_cache($uid);
    }

    $_ln = jrUser_load_lang_strings();
    $_rs = array('OK' => 1, 'VALUE' => $_ln['jrFollower'][1]);
    jrCore_json_response($_rs);
}
