<?php
 /**
 * Jamroom Followers module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: browse
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrFollower_browse($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    $_ln = jrUser_load_lang_strings();

    $pid = $_user['user_active_profile_id'];
    $prn = $_user['profile_name'];
    if (isset($_post['_1']) && jrCore_checktype($_post['_1'], 'number_nz') && jrProfile_is_profile_owner($_post['_1']) && $_post['_1'] != $pid) {
        $pid = (int) $_post['_1'];
        $prn = jrCore_db_get_item_key('jrProfile', $pid, 'profile_name');
    }
    jrCore_page_banner("{$prn} - {$_ln['jrFollower'][26]}");

    $tbl  = jrCore_db_table_name('jrFollower', 'follow');
    $req  = "SELECT * FROM {$tbl} WHERE follow_profile_id = {$pid} ORDER BY follow_created DESC";
    $_ids = jrCore_db_query($req, 'follow_user_id', false, null, false);
    if ($_ids && is_array($_ids) && count($_ids) > 0) {
        $page = (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) ? $_post['p'] : 1;
        $pbrk = jrCore_get_pager_rows();
        $ptot = ceil(count($_ids) / $pbrk);
        $_ids = array_slice($_ids, (($page - 1) * $pbrk), $pbrk, true);
        $_us  = array(
            'search'                 => array(
                "_item_id in " . implode(',', array_keys($_ids))
            ),
            'include_jrProfile_keys' => true,
            'ignore_pending'         => true,
            'index_key'              => '_item_id',
            'limit'                  => count($_ids)
        );
        $_us  = jrCore_db_search_items('jrUser', $_us);
        foreach ($_ids as $k => $_v) {
            if (isset($_us['_items'][$k]) && is_array($_us['_items'][$k])) {
                $_ids[$k] = $_v + $_us['_items'][$k];
            }
        }
    }
    else {
        $page = 1;
        $ptot = 0;
    }

    $dat             = array();
    $dat[1]['title'] = '&nbsp;';
    $dat[1]['width'] = '3%';
    $dat[2]['title'] = $_ln['jrFollower'][27]; // 'user name'
    $dat[2]['width'] = '31%';
    $dat[3]['title'] = $_ln['jrFollower'][28]; // 'profile name'
    $dat[3]['width'] = '31%';
    $dat[4]['title'] = $_ln['jrFollower'][29]; // 'follower since'
    $dat[4]['width'] = '25%';
    $dat[5]['title'] = $_ln['jrFollower'][30]; // 'approve'
    $dat[5]['width'] = '5%';
    $dat[6]['title'] = $_ln['jrFollower'][31]; // 'delete'
    $dat[6]['width'] = '5%';
    jrCore_page_table_header($dat);
    if (is_array($_ids)) {
        foreach ($_ids as $_usr) {
            $dat             = array();
            $_im             = array(
                'crop'  => 'auto',
                'alt'   => $_usr['user_name'],
                'title' => $_usr['user_name'],
                '_v'    => (isset($_usr['user_image_time']) && $_usr['user_image_time'] > 0) ? $_usr['user_image_time'] : false
            );
            $dat[1]['title'] = jrImage_get_image_src('jrUser', 'user_image', $_usr['_user_id'], 'xsmall', $_im);
            $dat[2]['title'] = '<h3>' . $_usr['user_name'] . '</h3>';
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = "{$_usr['profile_name']}&nbsp;&nbsp;(<a href=\"{$_conf['jrCore_base_url']}/{$_usr['profile_url']}\">@{$_usr['profile_url']}</a>)";
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = jrCore_format_time($_usr['follow_created']);
            $dat[4]['class'] = 'center';
            if (isset($_usr['follow_active']) && $_usr['follow_active'] == '0') {
                $dat[5]['title'] = jrCore_page_button("a{$_usr['_user_id']}", 'approve', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/approve/{$pid}/{$_usr['_user_id']}')");
                $dat[5]['class'] = 'center error';
            }
            else {
                $dat[5]['title'] = '-';
                $dat[5]['class'] = 'center';
            }
            $dat[6]['title'] = jrCore_page_button("d{$_usr['_user_id']}", 'delete', "jrCore_confirm('', '" . addslashes($_ln['jrFollower'][33]) . "', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/delete/{$pid}/{$_usr['_user_id']}') } )");
            jrCore_page_table_row($dat);
        }
        $_pinfo = array(
            'info' => array(
                'prev_page'   => $page - 1,
                'this_page'   => $page,
                'next_page'   => ($page == $ptot) ? 0 : $page + 1,
                'total_pages' => $ptot
            ),
        );
        jrCore_page_table_pager($_pinfo);
    }
    else {
        $dat             = array();
        $dat[1]['title'] = $_ln['jrFollower'][32];
        $dat[1]['class'] = 'center p10';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_display();
}
