<?php
 /**
 * Jamroom Followers module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * View profiles that a user is following
 * @param array $_profile
 * @param array $_post
 * @param array $_user
 * @param array $_conf
 * @return mixed|string
 */
function profile_view_jrFollower_profiles_followed($_profile, $_post, $_user, $_conf)
{
    // Check if only logged in users
    if (jrCore_get_config_value('jrFollower', 'logged_in_only', 'off') == 'on') {
        jrUser_session_require_login();
    }
    $key = $_post['_uri'];
    if (!$out = jrCore_is_cached('jrFollower', $key)) {
        $out = 'no_items';
        $pid = (int) $_profile['_profile_id'];
        if ($_id = jrFollower_get_profiles_followed_by_profile_id($pid)) {
            if ($_pt = jrCore_db_get_multiple_items('jrProfile', $_id)) {

                $pagebreak = jrCore_get_config_value('jrFollower', 'pagebreak', 16);
                if (jrCore_checktype($pagebreak, 'number_nz')) {
                    if (!isset($_post['p']) || !jrCore_checktype($_post['p'], 'number_nz')) {
                        $_post['p'] = 1;
                    }
                    $offset      = ($_post['p'] - 1) * $pagebreak;
                    $total_items = count($_pt);
                    $_rep        = array_slice($_pt, $offset, $pagebreak);
                    $_rep        = array(
                        '_items' => $_rep,
                        'info'   => array(
                            'total_items'   => $total_items,
                            'prev_page'     => $_post['p'] - 1,
                            'next_page'     => ($_post['p'] < ceil($total_items / $pagebreak)) ? $_post['p'] + 1 : 0,
                            'this_page'     => $_post['p'],
                            'page_base_url' => jrCore_strip_url_params($_post['_uri'], array('p')),
                            'total_pages'   => ceil($total_items / $pagebreak)
                        )
                    );
                }
                else {
                    $_rep = array('_items' => $_pt);
                }
                $_rep = array_merge($_profile, $_rep);
                // Parse templates and out
                $out = jrCore_parse_template('profiles_followed.tpl', $_rep, 'jrFollower');
                if (jrCore_checktype($pagebreak, 'number_nz')) {
                    $out .= jrCore_parse_template('list_pager.tpl', $_rep, 'jrCore');
                }
            }
        }
        jrCore_add_to_cache('jrFollower', $key, $out, 0, $pid);
    }
    if ($out == 'no_items') {
        // need to parse the template so the tabs are visible
        $out = jrCore_parse_template('profiles_followed.tpl', $_profile, 'jrFollower');
    }
    return $out;
}
