<?php
 /**
 * Jamroom Developer Tools module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: reset_system_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrDeveloper_reset_system_save($_post, $_user, $_conf)
{
    @ini_set('max_execution_time', 7200); // 2 hours max
    @ini_set('memory_limit', '512M');
    jrUser_master_only();
    jrCore_form_validate($_post);
    if (!isset($_post['reset']) || $_post['reset'] != 'on') {
        jrCore_form_modal_notice('error', 'You need to check the Reset System checkbox!');
        jrCore_form_modal_notice('complete', 'errors were encountered resetting the system');
        jrCore_db_close();
        exit;
    }

    $rnd = false;
    if (isset($_post['rand_ids']) && $_post['rand_ids'] == 'on') {
        $rnd = true;
    }

    // Bring in our account info
    $uid = (int) $_user['_user_id'];
    $tbl = jrCore_db_table_name('jrUser', 'item_key');
    $req = "SELECT * FROM {$tbl} WHERE `_item_id` = {$uid}";
    $_rt = jrCore_db_query($req, 'NUMERIC');
    if (!$_rt || !is_array($_rt)) {
        jrCore_form_modal_notice('error', 'Unable to retrieve your account info from the User DataStore!');
        jrCore_form_modal_notice('complete', 'errors were encountered resetting the system');
        jrCore_db_close();
        exit;
    }

    jrCore_form_modal_notice('update', "resetting system...");

    // Bring in our profile info
    $pid = jrUser_get_profile_home_key('_profile_id');
    $tbl = jrCore_db_table_name('jrProfile', 'item_key');
    $req = "SELECT * FROM {$tbl} WHERE `_item_id` = {$pid}";
    $_pr = jrCore_db_query($req, 'NUMERIC');
    if (!$_pr || !is_array($_pr)) {
        jrCore_form_modal_notice('error', 'Unable to retrieve your profile info from the User DataStore!');
        jrCore_form_modal_notice('complete', 'errors were encountered resetting the system');
        jrCore_db_close();
        exit;
    }

    // Get all profile_id's
    $tbl = jrCore_db_table_name('jrProfile', 'item');
    $req = "SELECT * FROM {$tbl}";
    $_ap = jrCore_db_query($req, '_item_id', false, '_item_id');

    // Delete Users
    jrCore_form_modal_notice('update', "resetting user accounts...");

    $u_aid = $uid;
    $p_aid = $pid;
    $o_uid = $uid; // Original User ID - used below
    $o_pid = $uid; // Original Profile ID - used below
    if ($rnd) {
        $u_aid = mt_rand(10000, 19999);
        $p_aid = mt_rand(10000, 19999);
        $uid   = $u_aid;
        $pid   = $p_aid;
    }

    $tbl = jrCore_db_table_name('jrUser', 'item');
    $req = "TRUNCATE TABLE {$tbl}";
    jrCore_db_query($req);
    $req = "OPTIMIZE TABLE {$tbl}";
    jrCore_db_query($req);
    $req = "ALTER TABLE {$tbl} AUTO_INCREMENT = {$u_aid}";
    jrCore_db_query($req);
    $req = "INSERT INTO {$tbl} (`_item_id`) VALUES ({$uid})";
    jrCore_db_query($req);

    $tbl = jrCore_db_table_name('jrUser', 'item_key');
    $req = "TRUNCATE TABLE {$tbl}";
    jrCore_db_query($req);
    $req = "OPTIMIZE TABLE {$tbl}";
    jrCore_db_query($req);
    $_vl = array();
    foreach ($_rt as $v) {
        if (!strpos($v['key'], '_count')) {
            $_vl[] = "({$uid}, {$pid}, '{$v['key']}', " . intval($v['index']) . ", '" . jrCore_db_escape($v['value']) . "')";
        }
    }
    $req = "INSERT INTO {$tbl} (`_item_id`, `_profile_id`, `key`, `index`, `value`) VALUES " . implode(',', $_vl);
    jrCore_db_query($req);
    $req = "UPDATE {$tbl} SET `value` = '{$uid}' WHERE `key` = '_user_id'";
    jrCore_db_query($req);
    $req = "UPDATE {$tbl} SET `value` = '{$pid}' WHERE `key` = '_profile_id'";
    jrCore_db_query($req);

    // Delete Profiles
    jrCore_form_modal_notice('update', "resetting user profiles...");

    $tbl = jrCore_db_table_name('jrProfile', 'item');
    $req = "TRUNCATE TABLE {$tbl}";
    jrCore_db_query($req);
    $req = "OPTIMIZE TABLE {$tbl}";
    jrCore_db_query($req);
    $req = "ALTER TABLE {$tbl} AUTO_INCREMENT = {$p_aid}";
    jrCore_db_query($req);
    $req = "INSERT INTO {$tbl} (`_item_id`) VALUES ({$pid})";
    jrCore_db_query($req);

    $tbl = jrCore_db_table_name('jrProfile', 'item_key');
    $req = "TRUNCATE TABLE {$tbl}";
    jrCore_db_query($req);
    $req = "OPTIMIZE TABLE {$tbl}";
    jrCore_db_query($req);
    $_vl = array();
    $qid = 0;
    foreach ($_pr as $v) {
        if (!strpos($v['key'], '_count')) {
            $_vl[] = "({$pid}, {$pid}, '{$v['key']}', " . intval($v['index']) . ", '" . jrCore_db_escape($v['value']) . "')";
            if ($v['key'] == 'profile_quota_id') {
                $qid = (int) $v['value'];
            }
        }
    }
    $req = "INSERT INTO {$tbl} (`_item_id`, `_profile_id`, `key`, `index`, `value`) VALUES " . implode(',', $_vl);
    jrCore_db_query($req);
    $req = "UPDATE {$tbl} SET `value` = '{$uid}' WHERE `key` = '_user_id'";
    jrCore_db_query($req);
    $req = "UPDATE {$tbl} SET `value` = '{$pid}' WHERE `key` = '_profile_id'";
    jrCore_db_query($req);

    // Reset Quota counts
    $tbl = jrCore_db_table_name('jrProfile', 'quota_value');
    $req = "UPDATE {$tbl} SET `value` = 0 WHERE `module` = 'jrProfile' AND `name` = 'profile_count'";
    jrCore_db_query($req);
    if ($qid > 0) {
        // Set our master admin profile back to 1
        jrProfile_increment_quota_profile_count($qid);
    }

    $tbl = jrCore_db_table_name('jrProfile', 'profile_link');
    $req = "TRUNCATE TABLE {$tbl}";
    jrCore_db_query($req);
    $req = "OPTIMIZE TABLE {$tbl}";
    jrCore_db_query($req);
    jrProfile_create_user_link($uid, $pid);

    // Handle DataStores
    jrCore_form_modal_notice('update', "resetting module datastores...");
    $_mds = jrCore_get_datastore_modules();
    if ($_mds && is_array($_mds)) {
        foreach ($_mds as $mod => $pfx) {
            switch ($mod) {
                case 'jrUser':
                case 'jrProfile':
                    break;
                default:
                    jrCore_db_truncate_datastore($mod);
                    if ($rnd) {
                        $tbl = jrCore_db_table_name($mod, 'item');
                        $aid = mt_rand(10000, 19999);
                        $req = "ALTER TABLE {$tbl} AUTO_INCREMENT = {$aid}";
                        jrCore_db_query($req);
                    }
                    jrCore_form_modal_notice('update', "reset {$mod} module datastore...");
                    break;
            }
        }
    }

    // Extras...
    $_todo = array(
        'log'            => 'jrCore',
        'log_debug'      => 'jrCore',
        'form'           => 'jrCore',
        'form_session'   => 'jrCore',
        'pending'        => 'jrCore',
        'pending_reason' => 'jrCore',
        'count_ip'       => 'jrCore',
        'queue'          => 'jrCore',
        'recycle'        => 'jrCore'
    );
    foreach ($_todo as $name => $mod) {
        if (jrCore_db_table_exists($mod, $name)) {
            $tbl = jrCore_db_table_name($mod, $name);
            $req = "TRUNCATE TABLE {$tbl}";
            jrCore_db_query($req);
            $req = "OPTIMIZE TABLE {$tbl}";
            jrCore_db_query($req);
        }
    }

    // User Sessions
    $_us = jrUser_session_online_user_info(1000000);
    if ($_us && is_array($_us)) {
        $_id = array();
        foreach ($_us as $u) {
            $_id[] = (int) $u['session_user_id'];
        }
        jrUser_session_remove($_id);
    }

    // User Language
    jrCore_form_modal_notice('update', 'deleting custom language strings...');
    $tbl = jrCore_db_table_name('jrUser', 'language');
    $req = "DELETE FROM {$tbl} WHERE lang_key > 9999 AND lang_key != 'menu'";
    jrCore_db_query($req);

    // Any registered Recycle Bin item_id table can be truncated
    $_trn = array();
    $_rbt = jrCore_get_registered_module_features('jrCore', "recycle_bin_item_id_table");
    if ($_rbt && is_array($_rbt)) {
        foreach ($_rbt as $rb_module => $_rb_tables) {
            foreach ($_rb_tables as $rb_table => $rb_column) {
                $tbl = jrCore_db_table_name($rb_module, $rb_table);
                $req = "TRUNCATE TABLE {$tbl}";
                jrCore_db_query($req);
                $req = "OPTIMIZE TABLE {$tbl}";
                jrCore_db_query($req);
                if (!isset($_trn[$rb_module])) {
                    $_trn[$rb_module] = array();
                }
                $_trn[$rb_module][$rb_table] = 1;
            }
        }
    }

    // Any registered Recycle Bin profile_id table can be cleaned up
    $_rbt = jrCore_get_registered_module_features('jrCore', "recycle_bin_profile_id_table");
    if ($_rbt && is_array($_rbt)) {
        foreach ($_rbt as $rb_module => $_rb_tables) {
            foreach ($_rb_tables as $rb_table => $rb_column) {
                if (!isset($_trn[$rb_module][$rb_table])) {
                    $tbl = jrCore_db_table_name($rb_module, $rb_table);
                    if ($o_pid != $pid) {
                        // We are doing a random reset
                        // $pid = NEW profile_id
                        // $o_pid - ORIGINAL profile_id
                        $req = "UPDATE {$tbl} SET `{$rb_column}` = '{$pid}' WHERE `{$rb_column}` = '{$o_pid}'";
                        jrCore_db_query($req);
                    }
                    $req = "DELETE FROM {$tbl} WHERE `{$rb_column}` != {$pid}";
                    jrCore_db_query($req);
                    $req = "OPTIMIZE TABLE {$tbl}";
                    jrCore_db_query($req);
                }
            }
        }
    }

    // Any registered Recycle Bin user_id table can be cleaned up
    $_rbt = jrCore_get_registered_module_features('jrCore', "recycle_bin_user_id_table");
    if ($_rbt && is_array($_rbt)) {
        foreach ($_rbt as $rb_module => $_rb_tables) {
            foreach ($_rb_tables as $rb_table => $rb_column) {
                if (!isset($_trn[$rb_module][$rb_table])) {
                    $tbl = jrCore_db_table_name($rb_module, $rb_table);
                    if ($o_uid != $uid) {
                        // We are doing a random reset
                        // $uid = NEW user_id
                        // $o_uid - ORIGINAL user_id
                        $req = "UPDATE {$tbl} SET `{$rb_column}` = '{$uid}' WHERE `{$rb_column}` = '{$o_uid}'";
                        jrCore_db_query($req);
                    }
                    $req = "DELETE FROM {$tbl} WHERE `{$rb_column}` != {$uid}";
                    jrCore_db_query($req);
                    $req = "OPTIMIZE TABLE {$tbl}";
                    jrCore_db_query($req);
                }
            }
        }
    }

    // Media directories
    jrCore_form_modal_notice('update', 'deleting media directories...');
    foreach ($_ap as $i) {
        if ($i != $_user['_profile_id']) {
            jrCore_delete_media_directory($i);
        }
    }

    // Cleanup system directory
    jrCore_delete_media_directory(0);

    // Reset caches
    jrCore_delete_all_cache_entries();
    jrCore_reset_template_cache();

    // Trigger
    jrCore_trigger_event('jrDeveloper', 'reset_system', array());

    jrCore_form_delete_session();
    jrCore_form_modal_notice('complete', 'The system has been successfully reset');
    jrCore_db_close();
    exit;
}
