<?php
 /**
 * Jamroom Developer Tools module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: package_skin
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrDeveloper_package_skin($_post, $_user, $_conf)
{
    jrUser_master_only();
    if (!isset($_conf['jrDeveloper_developer_prefix']) || strlen($_conf['jrDeveloper_developer_prefix']) === 0 || !isset($_conf['jrDeveloper_developer_name']) || strlen($_conf['jrDeveloper_developer_name']) === 0) {
        jrCore_set_form_notice('error', 'You have not set your Developer Name or Developer Prefix - both are required to package a module or skin');
        $hl = '';
        if (!isset($_conf['jrDeveloper_developer_prefix']) || strlen($_conf['jrDeveloper_developer_prefix']) === 0) {
            $hl .= '/hl[]=developer_prefix';
        }
        if (!isset($_conf['jrDeveloper_developer_name']) || strlen($_conf['jrDeveloper_developer_name']) === 0) {
            $hl .= '/hl[]=developer_name';
        }
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/global{$hl}");
    }

    if (isset($_conf['jrDeveloper_template_debug']) && $_conf['jrDeveloper_template_debug'] == 'on') {
        jrCore_set_form_notice('error', 'Disable template debug mode before packaging skins to avoid template names appearing in parsed templates.');
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/global/hl[]=template_debug");
    }

    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrDeveloper');

    // Get all skins
    $_skins = jrCore_get_skins();
    $mdir   = jrCore_get_media_directory(0, FORCE_LOCAL);
    $_mds   = glob("{$mdir}/{$_conf['jrDeveloper_developer_prefix']}*.zip");
    foreach ($_mds as $k => $file) {
        $nam = basename($file);
        list($dir,) = explode('-', $nam, 2);
        if (!isset($_skins[$dir])) {
            unset($_mds[$k]);
        }
    }

    $missing = false;
    if (isset($_post['show_unreleased']) && $_post['show_unreleased'] == '1') {
        $missing = true;
    }

    // modules ahead of the marketplace:
    $_ahead = array();
    $_ver   = jrMarket_get_system_updates(true);
    if (isset($_ver) && is_array($_ver)) {
        foreach ($_skins as $nam) {
            $_mta = jrCore_skin_meta_data($nam);
            // same versions
            if (!$missing && (!isset($_ver['skin'][$nam]['v']) || strlen($_ver['skin'][$nam]['v']) === 0)) {
                continue;
            }
            // not my module, continue
            if (strpos(' ' . $_mta['name'], $_conf['jrDeveloper_developer_prefix']) != 1) {
                continue;
            }

            if (($missing && !isset($_ver['skin'][$nam])) || $_mta['version'] != $_ver['skin'][$nam]['v']) {
                $_ahead[$nam] = array(
                    'directory' => $_mta['name'],
                    'name'      => $_mta['title'],
                    'local'     => $_mta['version'],
                    'market'    => (!empty($_ver['skin'][$nam]['v'])) ? $_ver['skin'][$nam]['v'] : ''
                );
            }
        }
    }

    if (!empty($_ahead)) {
        ksort($_ahead);
        if ($missing) {
            $button = jrCore_page_button("show-missing", 'Hide Unreleased', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/package_skin')");
        }
        else {
            $button = jrCore_page_button("show-missing", 'Show Unreleased', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/package_skin/show_unreleased=1')");
        }
        jrCore_page_banner('marketplace version differences', $button);

        // Start our output
        $dat             = array();
        $dat[1]['title'] = 'icon';
        $dat[1]['width'] = '1%';
        $dat[2]['title'] = 'skin name';
        $dat[2]['width'] = '49%';
        $dat[3]['title'] = 'directory';
        $dat[3]['width'] = '20%';
        $dat[4]['title'] = 'local';
        $dat[4]['width'] = '10%';
        $dat[5]['title'] = 'marketplace';
        $dat[5]['width'] = '10%';
        jrCore_page_table_header($dat);

        // versions ahead the marketplace
        foreach ($_ahead as $_v) {
            $dat             = array();
            $dat[1]['title'] = jrCore_get_skin_icon_html($_v['directory'], 32);
            $dat[2]['title'] = '<a onclick="var z=$(\'#zip_skin\'); z.val(\'' . $_v['directory'] . '\').change(); $(document).scrollTop(z.offset().top)">' . $_v['name'] . '</a>';
            $dat[3]['title'] = $_v['directory'];
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = jrCore_page_button($_v['directory'], $_v['local'], "window.open('{$_conf['jrCore_base_url']}/skins/{$_v['directory']}/changelog.txt?_v=" . time() . "')");
            $dat[4]['class'] = (jrDeveloper_ver_compare($_v['local'], $_v['market']) == 'greater') ? 'center success' : 'center';
            $dat[5]['title'] = (!empty($_v['market'])) ? $_v['market'] : '-';
            $dat[5]['class'] = (jrDeveloper_ver_compare($_v['market'], $_v['local']) == 'greater') ? 'center error' : 'center';
            jrCore_page_table_row($dat);
        }

        jrCore_page_table_footer();
    }

    $btn = '';
    if ($_mds && is_array($_mds) && count($_mds) > 0) {
        $btn = jrCore_page_button('del', 'delete all zip files', "jrCore_confirm('Delete all ZIP Files?', 'Are you sure you want to delete all the ZIP files that have been created?', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/delete_all/skin') })");
    }
    if (empty($_ahead)) {
        if ($missing) {
            $btn .= jrCore_page_button("show-missing", 'Hide Unreleased', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/package_skin')");
        }
        else {
            $btn .= jrCore_page_button("show-missing", 'Show Unreleased', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/package_skin/show_unreleased=1')");
        }
    }
    jrCore_page_banner('Create Skin ZIP', $btn);

    // Start our output
    $dat             = array();
    $dat[1]['title'] = 'icon';
    $dat[1]['width'] = '2%';
    $dat[2]['title'] = 'skin';
    $dat[2]['width'] = '30%';
    $dat[3]['title'] = 'file';
    $dat[3]['width'] = '27%';
    $dat[4]['title'] = 'license';
    $dat[4]['width'] = '8%';
    $dat[5]['title'] = 'size';
    $dat[5]['width'] = '8%';
    $dat[6]['title'] = 'created';
    $dat[6]['width'] = '15%';
    $dat[7]['title'] = 'download';
    $dat[7]['width'] = '5%';
    $dat[8]['title'] = 'delete';
    $dat[8]['width'] = '5%';
    jrCore_page_table_header($dat);

    // Show existing module packages that can be downloaded
    if (isset($_mds) && is_array($_mds) && count($_mds) > 0) {
        foreach ($_mds as $k => $file) {
            $nam = basename($file);
            list($dir,) = explode('-', $nam, 2);
            $_sk             = jrCore_skin_meta_data($dir);
            $dat             = array();
            $dat[1]['title'] = jrCore_get_skin_icon_html($dir, 32);
            $dat[2]['title'] = (isset($_sk['title'])) ? $_sk['title'] : $_sk['name'];
            $dat[3]['title'] = $nam;
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = (isset($_sk['license'])) ? $_sk['license'] : '?';
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = jrCore_format_size(filesize($file));
            $dat[5]['class'] = 'center';
            $dat[6]['title'] = jrCore_format_time(filemtime($file));
            $dat[6]['class'] = 'center';
            $dat[7]['title'] = jrCore_page_button("d{$k}", 'download', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/download_skin/{$nam}')");
            $dat[8]['title'] = jrCore_page_button("r{$k}", 'delete', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/delete_skin/{$nam}')");
            jrCore_page_table_row($dat);
        }
    }
    else {
        $dat             = array();
        $dat[1]['title'] = '<p>No skin ZIP files to be downloaded</p>';
        $dat[1]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    $_opt = array();
    foreach ($_skins as $m => $v) {
        if (strpos($m, $_conf['jrDeveloper_developer_prefix']) === 0) {
            $_mta     = jrCore_skin_meta_data($m);
            $_opt[$m] = (isset($_mta['title'])) ? $_mta['title'] : $_mta['name'];
        }
    }
    if (count($_opt) > 0) {

        // Form init
        $_tmp = array(
            'submit_value'     => 'create skin ZIP',
            'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
            'form_ajax_submit' => false
        );
        jrCore_form_create($_tmp);

        $_lic = array(
            'mpl'      => 'Mozilla Public License version 2.0',
            'jcl'      => 'Jamroom Commercial License',
            'mit'      => 'MIT License',
            'freeware' => 'Freeware License (no restrictions)',
        );
        jrCore_page_custom('<div id="zip_license_error" class="page_notice error" style="display:none">Invalid <strong>license</strong> field in the module meta data - ensure the license field is set to one of: ' . implode(', ', array_keys($_lic)) . '</div>');

        $_tmp = array(
            'name'     => 'zip_skin',
            'type'     => 'select',
            'options'  => $_opt,
            'required' => 'on',
            'label'    => 'Skin to ZIP',
            'help'     => 'Select the skin you would like to create a ZIP file for. This ZIP file can be used in the Jamroom Marketplace.',
            'onchange' => "var a=this.options[this.selectedIndex].value;jrDeveloper_get_license('skin',a);"
        );
        jrCore_form_field_create($_tmp);

        $_tmp = array(
            'name'     => 'zip_license',
            'type'     => 'select',
            'options'  => $_lic,
            'required' => 'on',
            'label'    => 'Module License',
            'help'     => 'Select the license you would like to use for this product.<br><br><strong>Mozilla Public License version 2.0</strong> - recommended for free modules and skins.<br><br><strong>Jamroom Commercial License</strong> - recommended for paid modules and skins.<br><br><strong>MIT License</strong> - user can resell or rebrand without restriction, but must include attribution.<br><br><strong>Freeware License</strong> - no restriction of any kind.'
        );
        jrCore_form_field_create($_tmp);
    }
    else {
        jrCore_page_notice('error', 'There are no skins found that match your Developer Prefix');
        jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools");
    }

    jrCore_page_display();
}
