<?php
 /**
 * Jamroom Developer Tools module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: package_module_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrDeveloper_package_module_save($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_form_validate($_post);
    if (!isset($_mods["{$_post['zip_mod']}"])) {
        jrCore_set_form_notice('error', 'Invalid module - please select a module from the list');
        jrCore_form_field_hilight('zip_mod');
        jrCore_form_result();
    }

    // Get version
    $_mta = jrCore_module_meta_data($_post['zip_mod']);
    if (!$_mta || !isset($_mta['version'])) {
        jrCore_set_form_notice('error', "The module is missing the required &quot;version&quot; attribute in the {$_post['zip_mod']}_meta() function");
        jrCore_form_result();
    }
    $mdir = jrCore_get_media_directory(0, FORCE_LOCAL);
    if (is_file("{$mdir}/{$_post['zip_mod']}-{$_mta['version']}.zip")) {
        unlink("{$mdir}/{$_post['zip_mod']}-{$_mta['version']}.zip");
    }
    if (is_dir("{$mdir}/modules")) {
        jrCore_delete_dir_contents("{$mdir}/modules", false);
        rmdir("{$mdir}/modules");
    }
    mkdir("{$mdir}/modules", $_conf['jrCore_dir_perms'], true);

    // Copy files to work directory
    jrCore_copy_dir_recursive(APP_DIR . "/modules/{$_post['zip_mod']}", "{$mdir}/modules/{$_post['zip_mod']}");

    $path  = "{$mdir}/modules/{$_post['zip_mod']}";
    $_temp = jrCore_get_directory_files($path);
    if (!$_temp || !is_array($_temp)) {
        jrCore_set_form_notice('error', "Invalid module - unable to find any module files");
        jrCore_form_result();
    }
    $_files = array();
    foreach ($_temp as $fullpath => $file) {

        // Cleanup some files we do not need
        switch ($file) {
            case '.DS_Store':
                unlink($fullpath);
                continue 2;
            default:
                break;
        }

        // Add in the license header depending on the license we got
        if (jrCore_file_extension($file) === 'php') {

            $add_header = false;
            if (basename($file) == $file) {
                switch ($file) {
                    // Files we are specifically ignoring
                    case 'apc.php':
                    case 'adminer.php':
                        break;
                    default:
                        $add_header = true;
                        break;
                }
            }
            else {
                list($subdir,) = explode('/', $file, 2);
                switch ($subdir) {
                    case 'lib':
                    case 'lang':
                    case 'bbcode':
                    case 'tests':
                    case 'functions':
                    case 'views':
                        $add_header = true;
                        break;
                }
            }
            if ($add_header) {
                jrDeveloper_add_license_header('module', $_post['zip_mod'], $fullpath, $_post['zip_license']);
            }

        }

        // export form designer fields, then update the lang strings file too
        if (isset($_post['zip_designer']) && $_post['zip_designer'] == 'on' && $file == 'lang/en-US.php') {
            jrDeveloper_export_lang_strings($_post['zip_mod'], $fullpath);
        }

        // Included for ZIP file
        $_files["modules/{$_post['zip_mod']}/{$file}"] = $fullpath;
    }

    //export form designer fields.
    if (isset($_post['zip_designer']) && $_post['zip_designer'] == 'on') {
        $fullpath = jrDeveloper_export_form_designer_fields($_post['zip_mod'], $path);
        if ($fullpath) {
            $_files["modules/{$_post['zip_mod']}/custom_form_fields.json"] = $fullpath;
        }
    }

    // Add in full license file
    $_rep = array(
        'item_name'      => $_mods["{$_post['zip_mod']}"]['module_name'],
        'item_directory' => $_mods["{$_post['zip_mod']}"]['module_directory'],
        'item_type'      => 'module'
    );
    $temp = jrCore_parse_template("{$_post['zip_license']}.tpl", $_rep, 'jrDeveloper');
    jrCore_write_to_file("{$mdir}/modules/{$_post['zip_mod']}/license.html", $temp);
    $_files["modules/{$_post['zip_mod']}/license.html"] = "{$mdir}/modules/{$_post['zip_mod']}/license.html";

    jrCore_create_zip_file("{$mdir}/{$_post['zip_mod']}-{$_mta['version']}.zip", $_files);
    jrCore_delete_dir_contents("{$mdir}/modules", false);
    rmdir("{$mdir}/modules");
    jrCore_form_delete_session();
    jrCore_location('referrer');
}
