<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: skin_admin_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_skin_admin_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    if (isset($_post['skin_delete']) && $_post['skin_delete'] === 'on') {
        jrCore_validate_location_url();
    }
    else {
        jrCore_form_validate($_post);

        // Make sure we get a good skin
        if (empty($_post['skin'])) {
            $_post['skin'] = $_conf['jrCore_active_skin'];
        }

        // Make sure our skin config is properly loaded
        $_conf = jrCore_load_skin_config($_post['skin'], $_conf);
    }

    // See what we are saving...
    switch ($_post['_1']) {

        case 'global':

            // See if this module is presenting us with a validate function
            if (is_file(APP_DIR . "/skins/{$_post['skin']}/config.php")) {
                $vfunc = "{$_post['skin']}_config_validate";
                if (!function_exists($vfunc)) {
                    require_once APP_DIR . "/skins/{$_post['skin']}/config.php";
                }
                if (function_exists($vfunc)) {
                    $_post = $vfunc($_post);
                }
            }
            // Update
            $show = false;
            foreach ($_post as $k => $v) {
                if (isset($_conf["{$_post['skin']}_{$k}"]) && $v != $_conf["{$_post['skin']}_{$k}"]) {
                    jrCore_set_setting_value($_post['skin'], $k, $v);
                    $show = true;
                }
            }
            jrCore_delete_all_cache_entries('jrCore', 0);
            $text = 'The settings have been successfully saved';
            if ($show) {
                $text .= "<br>Make sure you <a href=\"" . jrCore_get_base_url() . "/{$_post['module_url']}/cache_reset\"><u>Reset Caches</u></a> to activate your changes";
            }
            jrCore_set_form_notice('success', $text, false);
            break;

        case 'language':

            // Get all the lang strings for this module
            $tbl = jrCore_db_table_name('jrUser', 'language');
            $mod = jrCore_db_escape($_post['skin']);
            $req = "SELECT * FROM {$tbl} WHERE lang_module = '{$mod}' AND lang_code = '" . jrCore_db_escape($_post['lang_code']) . "'";
            $_rt = jrCore_db_query($req, 'lang_id');
            if (!isset($_rt) || !is_array($_rt)) {
                jrCore_set_form_notice('error', "Unable to retrieve skin language settings from language table - check debug_log errors");
                jrCore_form_result();
            }
            $req = "UPDATE {$tbl} SET lang_text = CASE lang_id\n";
            foreach ($_rt as $key => $_lng) {
                if (isset($_post["lang_{$key}"])) {
                    $req .= "WHEN {$key} THEN '" . jrCore_db_escape($_post["lang_{$key}"]) . "'\n";
                }
            }
            if (strpos($req, 'THEN')) {
                $req .= "ELSE lang_text END";
                jrCore_db_query($req, 'COUNT');
            }
            jrCore_delete_all_cache_entries('jrUser');
            jrCore_set_form_notice('success', 'The language strings have been successfully saved');
            jrCore_form_delete_session();
            jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_admin/{$_post['_1']}/skin={$_post['skin']}/lang_code={$_post['lang_code']}/p={$_post['p']}");
            break;

        case 'images':

            jrCore_create_media_directory(0);
            // Get existing skin info to see what images we have customized
            $_im = array();
            if (!empty($_conf["jrCore_{$_post['skin']}_custom_images"])) {
                $_im = json_decode($_conf["jrCore_{$_post['skin']}_custom_images"], true);
            }
            // Check for new custom files being uploaded
            $_up = jrCore_get_uploaded_meter_files($_post['upload_token']);
            if (is_array($_up)) {
                foreach ($_up as $_info) {
                    jrCore_write_media_file(0, "{$_post['skin']}_{$_info['name']}", $_info['tmp_name'], 'public-read');
                    jrCore_unlink($_info['tmp_name']);  // OK
                    $_im["{$_info['name']}"] = array($_info['size'], 'on');
                }
            }
            // Go through and save our uploaded images (if any)
            if (isset($_FILES) && is_array($_FILES)) {
                foreach ($_FILES as $k => $_info) {
                    if (isset($_info['size']) && jrCore_checktype($_info['size'], 'number_nz')) {
                        $num = (int) str_replace('file_', '', $k);
                        // Image extensions must match
                        $ext = jrCore_file_extension($_info['name']);
                        switch ($ext) {
                            case 'jpg':
                            case 'png':
                            case 'gif':
                                break;
                            default:
                                jrCore_set_form_notice('error', 'Invalid image type for ' . $_post["name_{$num}"] . ' - only JPG, PNG and GIF images are allowed');
                                jrCore_form_result();
                                break;
                        }
                        if (!empty($_post["name_{$num}"])) {
                            $nam = $_post["name_{$num}"];
                            jrCore_write_media_file(0, "{$_post['skin']}_{$nam}", $_info['tmp_name'], 'public-read');
                            jrCore_unlink($_info['tmp_name']);  // OK
                            $_im[$nam]                   = array($_info['size']);
                            $_post["name_{$num}_active"] = 'on';
                        }
                    }
                }
            }
            // Update setting with new values
            // [name_0_active] => on
            // [name_0] => bckgrd.png
            foreach ($_post as $k => $v) {
                if (strpos($k, 'name_') === 0 && strpos($k, '_active')) {
                    $num = (int) substr($k, 5, strrpos($k, '_'));
                    $nam = $_post["name_{$num}"];
                    if (isset($_im[$nam][0])) {
                        $_im[$nam][1] = $v;
                    }
                    else {
                        unset($_im[$nam]);
                    }
                }
            }
            if (count($_im) > 0) {
                jrCore_set_setting_value('jrCore', "{$_post['skin']}_custom_images", json_encode($_im));
                jrCore_delete_all_cache_entries();
            }
            break;

        case 'style':

            // We need to save our updates to the database so they "override" the defaults...
            $_pcc = false;
            $_out = array();
            $_com = array();

            // Get what we are overriding
            if (isset($_post['section']) && $_post['section'] == 'search') {
                $_pcc = jrCore_get_temp_value('jrCore', $_post['search_key']);
                if (!$_pcc || !is_array($_pcc)) {
                    jrCore_set_form_notice('error', 'invalid search_key - please try again');
                    jrCore_location('referrer');
                }
                $sstr = $_pcc['search_string'];
                $_pcc = $_pcc['found'];
                jrCore_delete_temp_value('jrCore', $_post['search_key']);
            }
            elseif (isset($_post['file']) && strlen($_post['file']) > 0) {
                if (is_file(APP_DIR . "/skins/{$_post['skin']}/css/{$_post['file']}")) {
                    $_pcc = jrCore_parse_css_file(APP_DIR . "/skins/{$_post['skin']}/css/{$_post['file']}");
                }
                else {
                    // Is this a module file?
                    if ($_tm = jrCore_get_registered_module_features('jrCore', 'css')) {
                        foreach ($_tm as $mod => $_css_files) {
                            if (in_array($_post['file'], $_css_files)) {
                                if (is_file(APP_DIR . "/modules/{$mod}/css/{$_post['file']}")) {
                                    $_pcc = jrCore_parse_css_file(APP_DIR . "/modules/{$mod}/css/{$_post['file']}");
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            if (!$_pcc || count($_pcc) === 0) {
                jrCore_set_form_notice('error', 'unable to load existing CSS rules - please try again');
                jrCore_location('referrer');
            }

            // Is this a mobile/tablet override?
            $medq = jrCore_get_flag('jrcore_css_media_enabled');
            foreach ($_post as $k => $v) {
                // all of our custom style entries will start with "jrse"....
                if (strpos($k, 'jrse') === 0) {
                    // We have a style entry.  the key for this entry will in position 4
                    $key = $k;
                    if (strpos($key, '_')) {
                        list($key,) = explode('_', $k);
                    }
                    $key = (int) substr($key, 4);
                    if (!isset($_com[$key])) {
                        // Now we can get our Name, Selector and New Value - i.e.:
                        // [jrse3_s] => body~font-family
                        // [jrse3] => Open Sans,Tahoma,sans-serif
                        list($selector, $rule) = @explode('~', $_post["jrse{$key}_s"], 2);
                        // See if we have a color...
                        if (isset($_post["jrse{$key}_hex"])) {
                            $val                    = trim($_post["jrse{$key}_hex"]);
                            $_out[$selector][$rule] = $val;
                            $tst                    = str_replace('#', '', jrCore_str_to_lower($val));
                        }
                        else {
                            $val = trim($_post["jrse{$key}"]);
                            switch ($rule) {
                                case 'font-family':
                                    if (strpos($val, ',')) {
                                        $_vl = array();
                                        foreach (explode(',', $val) as $vl) {
                                            if (strpos($vl, ' ')) {
                                                $vl = '"' . $vl . '"';
                                            }
                                            $_vl[] = $vl;
                                        }
                                        $val = implode(',', $_vl);
                                        unset($_vl);
                                    }
                                    break;
                            }
                            $_out[$selector][$rule] = $val;
                            $tst                    = str_replace(array('"', "'"), '', jrCore_str_to_lower($val));
                        }

                        // See if we have a match
                        if (isset($_pcc[$selector]['rules'][$rule])) {
                            $compare = str_replace(array('"', "'"), '', jrCore_str_to_lower($_pcc[$selector]['rules'][$rule]));
                            if ($compare == $tst) {
                                unset($_out[$selector][$rule]);
                                continue;
                            }
                        }

                        // See if we are !important
                        if (isset($_post["jrse{$key}_add_important"]) && $_post["jrse{$key}_add_important"] == 'on') {
                            $_out[$selector][$rule] .= ' !important';
                        }
                        if (isset($_post["jrse{$key}_add_auto"]) && $_post["jrse{$key}_add_auto"] == 'on') {
                            $_out[$selector][$rule] .= ' auto';
                        }
                        $_com[$key] = 1;
                    }
                }
            }
            if ($_out && count($_out) > 0) {
                foreach ($_out as $k => $v) {
                    if (count($v) === 0) {
                        unset($_out[$k]);
                    }
                }
            }
            $tbl = jrCore_db_table_name('jrCore', 'skin');
            if (count($_out) > 0) {
                if ($medq) {
                    $_out = array($medq => $_out);
                }
                // Save out to database
                $req = "SELECT skin_custom_css, skin_direct_css, skin_custom_image FROM {$tbl} WHERE skin_directory = '" . jrCore_db_escape($_post['skin']) . "'";
                $_rt = jrCore_db_query($req, 'SINGLE');
                if ($_rt && is_array($_rt) && !empty($_rt['skin_custom_css'])) {
                    $_css = json_decode($_rt['skin_custom_css'], true);
                    $_css = array_merge($_css, $_out);
                    $cimg = $_rt['skin_custom_image'];
                }
                else {
                    $_css = $_out;
                    $cimg = '';
                }
                // Cleanup any empty selectors
                foreach ($_css as $k => $v) {
                    if (!is_array($v) || count($v) === 0) {
                        unset($_css[$k]);
                    }
                }
                $_css = json_encode($_css);
                $skn  = jrCore_db_escape($_post['skin']);
                $req  = "INSERT INTO {$tbl} (skin_directory, skin_updated, skin_custom_css, skin_direct_css, skin_custom_image)
                         VALUES ('{$skn}', UNIX_TIMESTAMP(),'" . jrCore_db_escape($_css) . "', '', '" . jrCore_db_escape($cimg) . "')
                         ON DUPLICATE KEY UPDATE skin_updated = UNIX_TIMESTAMP(), skin_custom_css = '" . jrCore_db_escape($_css) . "'";
                $cnt  = jrCore_db_query($req, 'COUNT');
                if (!$cnt) {
                    jrCore_set_form_notice('error', 'An error was enountered saving the custom style to the database - please try again');
                    jrCore_form_result();
                }
            }
            else {
                $req = "UPDATE {$tbl} SET skin_custom_css = '' WHERE skin_directory = '" . jrCore_db_escape($_post['skin']) . "'";
                jrCore_db_query($req);
            }

            // Recreate our site CSS
            jrCore_create_master_css($_post['skin']);

            jrCore_form_delete_session();
            switch ($_post['section']) {
                case 'simple':
                case 'padding':
                case 'advanced':
                case 'extra':
                    $section = $_post['section'];
                    break;
                default:
                    $section = 'simple';
                    break;
            }
            if (isset($sstr) && strlen($sstr) > 0) {
                jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_admin/{$_post['_1']}/skin={$_post['skin']}?search_string={$sstr}");
            }
            jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_admin/{$_post['_1']}/skin={$_post['skin']}/file={$_post['file']}/section={$section}");
            break;

        case 'templates':

            //  [form_begin_template_active] => on
            $_act = array();
            $_off = array();
            $_all = array();
            foreach ($_post as $k => $v) {
                if (strpos($k, '_template_active')) {
                    $tpl = str_replace('_template_active', '.tpl', $k);
                    // See if we are turning this template on or off
                    if ($v == 'on') {
                        $_act[] = $tpl;
                        $_all[] = $tpl;
                    }
                    else {
                        $_off[] = $tpl;
                        $_all[] = $tpl;
                    }
                }
            }

            // Set active/inactive
            if (isset($_all) && is_array($_all) && count($_all) > 0) {
                $tbl = jrCore_db_table_name('jrCore', 'template');
                $mod = jrCore_db_escape($_post['skin']);
                if (isset($_act) && is_array($_act) && count($_act) > 0) {
                    $req = "UPDATE {$tbl} SET template_active = '1' WHERE template_module = '{$mod}' AND template_name IN('" . implode("','", $_act) . "')";
                    jrCore_db_query($req);
                }
                if (isset($_off) && is_array($_off) && count($_off) > 0) {
                    $req = "UPDATE {$tbl} SET template_active = '0' WHERE template_module = '{$mod}' AND template_name IN('" . implode("','", $_off) . "')";
                    jrCore_db_query($req);
                }
                // Reset cache for any that changed
                foreach ($_all as $tpl) {
                    jrCore_get_template_file($tpl, $_post['skin'], 'reset');
                }
            }
            jrCore_set_form_notice('success', 'The template settings have been successfully saved');
            break;

        case 'info':

            // Update
            if (isset($_post['skin_active']) && $_post['skin_active'] == 'on') {

                if ($_post['skin'] != $_conf['jrCore_active_skin']) {
                    // changing skins, allow deactivation of stuff by parting skin
                    jrCore_skin_deactivate($_conf['jrCore_active_skin']);
                }

                // Setup skin
                jrCore_verify_skin($_post['skin']);

                // Activate it
                jrCore_set_setting_value('jrCore', 'active_skin', $_post['skin']);

                // @note: this event trigger must come BEFORE we reset anything!
                jrCore_trigger_event('jrCore', 'skin_activated', array('skin' => $_post['skin']));

                // Cleanup NEW cache directory to make sure we don't have any old templates
                $dir = jrCore_get_module_cache_dir($_post['skin']);
                jrCore_delete_dir_contents($dir);
                // Delete Core templates
                $dir = jrCore_get_module_cache_dir('jrCore');
                jrCore_delete_dir_contents($dir);

                // @note we have to delete the config cache separately from all cache items to properly support cache plugins
                jrCore_delete_config_cache();

                // @note leave this global here or $_conf is not change after the jrCore_init_conf_mods_and_urls() call
                global $_conf;
                jrCore_load_config_file_and_defaults(true);
                jrCore_init_conf_mods_and_urls();

                // Build skin CSS and JS
                jrCore_create_master_css($_post['skin']);
                jrCore_create_master_javascript($_post['skin']);

                jrCore_delete_all_cache_entries();

                // redirect so we reload
                jrCore_form_delete_session();
                jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_admin/info/skin={$_post['skin']}");
            }
            elseif (isset($_post['skin_delete']) && $_post['skin_delete'] === 'on') {

                $res = jrCore_delete_skin($_post['skin']);
                if ($res && strpos($res, 'error:') === 0) {
                    jrCore_set_form_notice('error', substr($res, 7));
                    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_admin/info/skin={$_conf['jrCore_active_skin']}");
                }

                jrCore_trigger_event('jrCore', 'skin_deleted', $_post);
                jrCore_logger('INF', "core: the {$_post['skin']} skin was successfully deleted");
                jrCore_set_form_notice('success', 'The skin was successfully deleted');
                jrCore_form_delete_session();
                jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_admin/info/skin={$_conf['jrCore_active_skin']}");

            }
            jrCore_set_form_notice('success', 'The settings have been successfully saved');
            break;

    }
    jrCore_form_delete_session();
    jrCore_form_result();
}
