<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: queue_empty_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_queue_empty_save($_post, $_user, $_conf)
{
    jrUser_admin_only();
    jrCore_validate_location_url();
    if (!isset($_post['queue_module']) || strlen($_post['queue_module']) === 0) {
        jrCore_set_form_notice('error', 'invalid queue module - please try again');
    }
    if (!isset($_post['queue_name']) || strlen($_post['queue_name']) === 0) {
        jrCore_set_form_notice('error', 'invalid queue name - please try again');
    }

    ini_set('max_execution_time', 3600);

    $mod = jrCore_db_escape($_post['queue_module']);
    $nam = jrCore_db_escape($_post['queue_name']);
    $tb1 = jrCore_db_table_name('jrCore', 'queue');
    $tb2 = jrCore_db_table_name('jrCore', 'queue_data');
    $req = "DELETE {$tb1}, {$tb2} FROM {$tb1} LEFT JOIN {$tb2} ON ({$tb2}.queue_id = {$tb1}.queue_id) WHERE {$tb1}.queue_module = '{$mod}' AND {$tb1}.queue_name = '{$nam}'";
    jrCore_db_query($req);
    jrCore_validate_queue_info();
    jrCore_location('referrer');
}
