<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: performance_history
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_performance_history($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCore');
    jrCore_page_banner('performance history');

    // See if we have an existing value
    $page = 1;
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $page = (int) $_post['p'];
    }
    $tbl = jrCore_db_table_name('jrCore', 'performance');
    $req = "SELECT * FROM {$tbl} ORDER BY p_id DESC";
    $_tm = jrCore_db_paged_query($req, $page, 12);
    if ($_tm && is_array($_tm) && isset($_tm['_items'])) {

        $dat             = array();
        $dat[1]['title'] = 'date';
        $dat[1]['width'] = '20%';
        $dat[2]['title'] = 'processor';
        $dat[2]['width'] = '20%';
        $dat[3]['title'] = 'database';
        $dat[3]['width'] = '20%';
        $dat[4]['title'] = 'filesystem';
        $dat[4]['width'] = '20%';
        $dat[5]['title'] = 'total score';
        $dat[5]['width'] = '20%';
        jrCore_page_table_header($dat);

        $_inf = jrCore_get_proc_info();
        $pnum = count($_inf);

        foreach ($_tm['_items'] as $_v) {
            $_pt = json_decode($_v['p_val'], true);
            $tot = round((10 / $_pt['total']) * 800);
            if ($pnum > 1) {
                $tot += round(($tot / (8 + $pnum)) * ($pnum / 2));
            }
            $cls = 'success';
            if ($tot < 200) {
                $cls = 'error';
            }
            elseif ($tot < 400) {
                $cls = 'error';
            }
            elseif ($tot < 600) {
                $cls = 'notice';
            }
            elseif ($tot < 800) {
                $cls = 'notice';
            }
            $dat             = array();
            $dat[1]['title'] = jrCore_format_time($_v['p_time']);
            $dat[1]['class'] = 'center';
            $dat[2]['title'] = $_pt['cpu'] . 's';
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = $_pt['db'] . 's';
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = $_pt['fs'] . 's';
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = '<strong>' . jrCore_number_format($tot) . '</strong>';
            $dat[5]['class'] = "{$cls} center";
            jrCore_page_table_row($dat, null, $_pt);
        }
        jrCore_page_table_pager($_tm);
        jrCore_page_table_footer();
    }
    jrCore_page_cancel_button('referrer');
    jrCore_page_display();
}
