<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: item_action_buttons
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_item_action_buttons($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();

    if (!isset($_post['_1']) || strlen($_post['_1']) === 0) {
        jrCore_notice_page('error', 'Invalid button type');
    }
    if (!isset($_post['m']) || !jrCore_module_is_active($_post['m'])) {
        jrCore_notice_page('error', 'Invalid module');
    }
    $type = false;
    $key  = false;
    switch ($_post['_1']) {
        case 'index':
        case 'list':
        case 'detail':
        case 'bundle_index':
        case 'bundle_list':
        case 'bundle_detail':
            $type = $_post['_1'];
            $key  = "{$_post['m']}_item_{$type}_buttons";
            break;
        default:
            jrCore_notice_page('error', 'Invalid button type');
            break;
    }

    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCore');
    jrCore_page_banner($_mods["{$_post['m']}"]['module_name'] . " - " . str_replace('_', ' ', $type) . " buttons");
    jrCore_get_form_notice();

    // Get all registered features
    $_rf = jrCore_get_registered_module_features('jrCore', "item_{$type}_button");
    if (!$_rf || !is_array($_rf)) {
        jrCore_notice_page('notice', 'There are no modules in the system that provide Item Action Buttons');
    }
    $_rs = array();
    foreach ($_rf as $bmod => $_ft) {
        foreach ($_ft as $func => $_inf) {
            $_inf['module']   = $bmod;
            $_inf['function'] = $func;
            $_rs[]            = $_inf;
        }
    }

    // The admin can:
    // set a specific button to not show
    // set the ORDER the buttons appear in (left to right)
    // Our config holds the info, ordered and by function => on|off
    if (!empty($_conf[$key])) {
        // admin has configured
        $_ord = json_decode($_conf[$key], true);
        // "new" modules may not be present in the order until the admin actually
        // re-orders things, so let's add any extra in at the end.
        if ($_ord && is_array($_ord)) {
            foreach ($_rs as $_dat) {
                $found = false;
                foreach ($_ord as $_inf) {
                    if ($_inf['function'] == $_dat['function']) {
                        $found = true;
                        break;
                    }
                }
                if (!$found) {
                    $_ord[] = $_dat;
                }
            }
        }
        else {
            $_ord = $_rs;
        }
    }
    else {
        $_ord = $_rs;
    }

    // Let modules exclude buttons by trigger
    $_ex = array();
    $_ex = jrCore_trigger_event('jrCore', "exclude_item_{$type}_buttons", $_ex, $_ord, $_post['m']);

    // See if they are active for this view
    foreach ($_ord as $k => $_inf) {
        if (isset($_inf['function'])) {
            $func = $_inf['function'];
            if (function_exists($func)) {
                if (isset($_ex[$func]) || $func($_post['m'], false, false, false, true) === false) {
                    unset($_ord[$k]);
                }
            }
        }
    }
    $_ord = array_values($_ord);

    $dat             = array();
    $dat[1]['title'] = 'order';
    $dat[1]['width'] = '3%';
    $dat[2]['title'] = 'icon';
    $dat[2]['width'] = '3%';
    $dat[3]['title'] = 'module';
    $dat[3]['width'] = '27%';
    $dat[4]['title'] = 'button name';
    $dat[4]['width'] = '27%';
    $dat[5]['title'] = 'group';
    $dat[5]['width'] = '10%';
    $dat[6]['title'] = 'quotas';
    $dat[6]['width'] = '20%';
    $dat[7]['title'] = 'active';
    $dat[7]['width'] = '5%';
    $dat[8]['title'] = 'modify';
    $dat[8]['width'] = '5%';
    jrCore_page_table_header($dat);

    if (count($_ord) > 0) {
        $enabled  = jrCore_get_option_image('pass');
        $disabled = jrCore_get_option_image('fail');
        foreach ($_ord as $cnt => $_inf) {
            if (!jrCore_module_is_active($_inf['module'])) {
                continue;
            }
            $dat = array();
            if (!isset($first)) {
                $dat[1]['title'] = '';
                $first           = true;
            }
            else {
                $dat[1]['title'] = jrCore_page_button("f{$cnt}", '&#8679;', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/item_action_button_order/t={$type}/m={$_post['m']}/o={$cnt}')");
            }
            $dat[1]['class'] = 'center';
            $dat[2]['title'] = (isset($_inf['icon'])) ? jrCore_get_icon_html($_inf['icon']) : '';
            $dat[3]['title'] = $_mods["{$_inf['module']}"]['module_name'];
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = ucwords($_inf['title']);
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = (isset($_inf['group'])) ? $_inf['group'] : '';
            $dat[5]['class'] = 'center';
            if (isset($_inf['quota']) && strlen(trim($_inf['quota'])) > 0) {
                $_q = array();
                if (!isset($_qt)) {
                    $_qt = jrProfile_get_quotas();
                }
                foreach (explode(',', $_inf['quota']) as $qid) {
                    if (jrCore_checktype($qid, 'number_nz')) {
                        $_q[] = $_qt[$qid];
                    }
                }
                $dat[6]['title'] = implode('<br>', $_q);
            }
            else {
                $dat[6]['title'] = '-';
            }
            $dat[6]['class'] = 'center';
            $dat[7]['title'] = (isset($_inf['active']) && $_inf['active'] == 'off') ? $disabled : $enabled;
            $dat[7]['class'] = 'center';
            $dat[8]['title'] = jrCore_page_button("m{$cnt}", 'modify', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/item_action_button_modify/t={$type}/m={$_post['m']}/o={$cnt}')");
            jrCore_page_table_row($dat, null, $_inf);
        }
        jrCore_page_table_footer();
    }
    jrCore_page_cancel_button(jrCore_is_profile_referrer(), 'continue');
    jrCore_page_display();
}
