<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: icon
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_icon($_post, $_user, $_conf)
{
    // http://site.com/core/icon/[module|skin]/[dir]
    global $_mods;
    if (empty($_post['_1']) || ($_post['_1'] != 'module' && $_post['_1'] != 'skin')) {
        jrCore_notice('Error', 'invalid icon type - must be one of module or skin');
    }
    if (empty($_post['_2'])) {
        jrCore_notice('Error', 'invalid icon directory - must provided module or skin directory');
    }
    if ($_post['_1'] == 'module') {
        if (!isset($_mods["{$_post['_2']}"])) {
            jrCore_notice('Error', 'invalid icon directory - must provided valid module name');
        }
        $icon = APP_DIR . "/modules/{$_post['_2']}/icon.png";
        if (!is_file($icon)) {
            $icon = APP_DIR . "/modules/jrCore/img/default_module_icon.png";
        }
    }
    else {
        $icon = APP_DIR . "/skins/{$_post['_2']}/icon.png";
        if (!is_file($icon)) {
            $icon = APP_DIR . "/modules/jrCore/img/default_skin_icon.png";
        }
    }
    $tim = filemtime($icon);
    jrImage_send_not_modified($tim, $icon);

    if (isset($_SESSION)) {
        session_write_close();
    }
    // Required for the process_exit (shutdown function) to detach properly from the client
    if (function_exists('apache_setenv')) {
        apache_setenv('no-gzip', 1);
    }
    ini_set('zlib.output_compression', 0);
    ini_set('implicit_flush', 1);

    // Send output
    // THE ORDER OF THE FOLLOWING STATEMENTS is critical for it
    // to work properly on mod_php, CGI/FastCGI, and FPM - DO NOT CHANGE!
    @ob_end_clean();
    $img = jrCore_file_get_contents($icon);
    $len = strlen($img);
    header("Last-Modified: " . gmdate('r', $tim));
    header('Content-Disposition: inline; filename="icon.png"');
    header('Content-Length: ' . $len);
    header('Cache-Control: must-revalidate');
    header('Expires: ' . gmdate('D, d M Y H:i:s \G\M\T', time() + 8640000));
    ignore_user_abort();
    ob_start();
    echo $img;
    ob_end_flush();
    @flush();

    // PHP-FPM only
    if (function_exists('fastcgi_finish_request')) {
        fastcgi_finish_request();
    }
    $_tmp = array('img_length' => $len);

    // NOTE: Do not use a process_exit event here - we don't want
    // queues and other items starting up at this point
    jrCore_trigger_event('jrCore', 'process_done', $_tmp); // OK
    exit; // OK
}
